#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2017 Google
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)
# ----------------------------------------------------------------------------
#
#     ***     AUTO GENERATED CODE    ***    AUTO GENERATED CODE     ***
#
# ----------------------------------------------------------------------------
#
#     This file is automatically generated by Magic Modules and manual
#     changes will be clobbered when the file is regenerated.
#
#     Please read more about how to change this file at
#     https://www.github.com/GoogleCloudPlatform/magic-modules
#
# ----------------------------------------------------------------------------

from __future__ import absolute_import, division, print_function
__metaclass__ = type

################################################################################
# Documentation
################################################################################

ANSIBLE_METADATA = {'metadata_version': '1.1',
                    'status': ["preview"],
                    'supported_by': 'community'}

DOCUMENTATION = '''
---
module: gcp_compute_route
description:
    - Represents a Route resource.
    - A route is a rule that specifies how certain packets should be handled by the virtual
      network. Routes are associated with virtual machines by tag, and the set of routes
      for a particular virtual machine is called its routing table. For each packet leaving
      a virtual machine, the system searches that virtual machine's routing table for
      a single best matching route.
    - Routes match packets by destination IP address, preferring smaller or more specific
      ranges over larger ones. If there is a tie, the system selects the route with the
      smallest priority value. If there is still a tie, it uses the layer three and four
      packet headers to select just one of the remaining matching routes. The packet is
      then forwarded as specified by the next_hop field of the winning route -- either
      to another virtual machine destination, a virtual machine gateway or a Compute Engine-operated
      gateway. Packets that do not match any route in the sending virtual machine's routing
      table will be dropped.
    - A Routes resources must have exactly one specification of either nextHopGateway,
      nextHopInstance, nextHopIp, or nextHopVpnTunnel.
short_description: Creates a GCP Route
version_added: 2.6
author: Google Inc. (@googlecloudplatform)
requirements:
    - python >= 2.6
    - requests >= 2.18.4
    - google-auth >= 1.3.0
options:
    state:
        description:
            - Whether the given object should exist in GCP
        choices: ['present', 'absent']
        default: 'present'
    dest_range:
        description:
            - The destination range of outgoing packets that this route applies to.
            - Only IPv4 is supported.
        required: false
    name:
        description:
            - Name of the resource. Provided by the client when the resource is created. The name
              must be 1-63 characters long, and comply with RFC1035.  Specifically, the name must
              be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`
              which means the first character must be a lowercase letter, and all following characters
              must be a dash, lowercase letter, or digit, except the last character, which cannot
              be a dash.
        required: false
    network:
        description:
            - A reference to Network resource.
        required: false
    priority:
        description:
            - The priority of this route. Priority is used to break ties in cases where there
              is more than one matching route of equal prefix length.
            - In the case of two routes with equal prefix length, the one with the lowest-numbered
              priority value wins.
            - Default value is 1000. Valid range is 0 through 65535.
        required: false
    tags:
        description:
            - A list of instance tags to which this route applies.
        required: false
    next_hop_gateway:
        description:
            - URL to a gateway that should handle matching packets.
            - 'Currently, you can only specify the internet gateway, using a full or partial valid
              URL:  * U(https://www.googleapis.com/compute/v1/projects/project/global/gateways/default-internet-gateway)
              * projects/project/global/gateways/default-internet-gateway * global/gateways/default-internet-gateway
              .'
        required: false
    next_hop_instance:
        description:
            - URL to an instance that should handle matching packets.
            - 'You can specify this as a full or partial URL. For example: *
              U(https://www.googleapis.com/compute/v1/projects/project/zones/zone/)
              instances/instance *
              projects/project/zones/zone/instances/instance *
              zones/zone/instances/instance .'
        required: false
    next_hop_ip:
        description:
            - Network IP address of an instance that should handle matching packets.
        required: false
    next_hop_vpn_tunnel:
        description:
            - URL to a VpnTunnel that should handle matching packets.
        required: false
extends_documentation_fragment: gcp
'''

EXAMPLES = '''
- name: create a network
  gcp_compute_network:
      name: 'network-route'
      project: "{{ gcp_project }}"
      auth_kind: "{{ gcp_cred_kind }}"
      service_account_file: "{{ gcp_cred_file }}"
      scopes:
        - https://www.googleapis.com/auth/compute
      state: present
  register: network
- name: create a route
  gcp_compute_route:
      name: testObject
      dest_range: '192.168.6.0/24'
      next_hop_gateway: 'global/gateways/default-internet-gateway'
      network: "{{ network }}"
      tags:
        - backends
        - databases
      project: testProject
      auth_kind: service_account
      service_account_file: /tmp/auth.pem
      scopes:
        - https://www.googleapis.com/auth/compute
      state: present
'''

RETURN = '''
    dest_range:
        description:
            - The destination range of outgoing packets that this route applies to.
            - Only IPv4 is supported.
        returned: success
        type: str
    name:
        description:
            - Name of the resource. Provided by the client when the resource is created. The name
              must be 1-63 characters long, and comply with RFC1035.  Specifically, the name must
              be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`
              which means the first character must be a lowercase letter, and all following characters
              must be a dash, lowercase letter, or digit, except the last character, which cannot
              be a dash.
        returned: success
        type: str
    network:
        description:
            - A reference to Network resource.
        returned: success
        type: dict
    priority:
        description:
            - The priority of this route. Priority is used to break ties in cases where there
              is more than one matching route of equal prefix length.
            - In the case of two routes with equal prefix length, the one with the lowest-numbered
              priority value wins.
            - Default value is 1000. Valid range is 0 through 65535.
        returned: success
        type: int
    tags:
        description:
            - A list of instance tags to which this route applies.
        returned: success
        type: list
    next_hop_gateway:
        description:
            - URL to a gateway that should handle matching packets.
            - 'Currently, you can only specify the internet gateway, using a full or partial valid
              URL:  * U(https://www.googleapis.com/compute/v1/projects/project/global/gateways/default-internet-gateway)
              * projects/project/global/gateways/default-internet-gateway * global/gateways/default-internet-gateway
              .'
        returned: success
        type: str
    next_hop_instance:
        description:
            - URL to an instance that should handle matching packets.
            - 'You can specify this as a full or partial URL. For example: *
              U(https://www.googleapis.com/compute/v1/projects/project/zones/zone/)
              instances/instance *
              projects/project/zones/zone/instances/instance *
              zones/zone/instances/instance .'
        returned: success
        type: str
    next_hop_ip:
        description:
            - Network IP address of an instance that should handle matching packets.
        returned: success
        type: str
    next_hop_vpn_tunnel:
        description:
            - URL to a VpnTunnel that should handle matching packets.
        returned: success
        type: str
'''

################################################################################
# Imports
################################################################################

from ansible.module_utils.gcp_utils import navigate_hash, GcpSession, GcpModule, GcpRequest, replace_resource_dict
import json
import time

################################################################################
# Main
################################################################################


def main():
    """Main function"""

    module = GcpModule(
        argument_spec=dict(
            state=dict(default='present', choices=['present', 'absent'], type='str'),
            dest_range=dict(type='str'),
            name=dict(type='str'),
            network=dict(type='dict'),
            priority=dict(type='int'),
            tags=dict(type='list', elements='str'),
            next_hop_gateway=dict(type='str'),
            next_hop_instance=dict(type='str'),
            next_hop_ip=dict(type='str'),
            next_hop_vpn_tunnel=dict(type='str')
        )
    )

    state = module.params['state']
    kind = 'compute#route'

    fetch = fetch_resource(module, self_link(module), kind)
    changed = False

    if fetch:
        if state == 'present':
            if is_different(module, fetch):
                fetch = update(module, self_link(module), kind)
                changed = True
        else:
            delete(module, self_link(module), kind)
            fetch = {}
            changed = True
    else:
        if state == 'present':
            fetch = create(module, collection(module), kind)
            changed = True
        else:
            fetch = {}

    fetch.update({'changed': changed})

    module.exit_json(**fetch)


def create(module, link, kind):
    auth = GcpSession(module, 'compute')
    return wait_for_operation(module, auth.post(link, resource_to_request(module)))


def update(module, link, kind):
    auth = GcpSession(module, 'compute')
    return wait_for_operation(module, auth.put(link, resource_to_request(module)))


def delete(module, link, kind):
    auth = GcpSession(module, 'compute')
    return wait_for_operation(module, auth.delete(link))


def resource_to_request(module):
    request = {
        u'kind': 'compute#route',
        u'destRange': module.params.get('dest_range'),
        u'name': module.params.get('name'),
        u'network': replace_resource_dict(module.params.get(u'network', {}), 'selfLink'),
        u'priority': module.params.get('priority'),
        u'tags': module.params.get('tags'),
        u'nextHopGateway': module.params.get('next_hop_gateway'),
        u'nextHopInstance': module.params.get('next_hop_instance'),
        u'nextHopIp': module.params.get('next_hop_ip'),
        u'nextHopVpnTunnel': module.params.get('next_hop_vpn_tunnel')
    }
    return_vals = {}
    for k, v in request.items():
        if v:
            return_vals[k] = v

    return return_vals


def fetch_resource(module, link, kind):
    auth = GcpSession(module, 'compute')
    return return_if_object(module, auth.get(link), kind)


def self_link(module):
    return "https://www.googleapis.com/compute/v1/projects/{project}/global/routes/{name}".format(**module.params)


def collection(module):
    return "https://www.googleapis.com/compute/v1/projects/{project}/global/routes".format(**module.params)


def return_if_object(module, response, kind):
    # If not found, return nothing.
    if response.status_code == 404:
        return None

    # If no content, return nothing.
    if response.status_code == 204:
        return None

    try:
        module.raise_for_status(response)
        result = response.json()
    except getattr(json.decoder, 'JSONDecodeError', ValueError) as inst:
        module.fail_json(msg="Invalid JSON response with error: %s" % inst)

    if navigate_hash(result, ['error', 'errors']):
        module.fail_json(msg=navigate_hash(result, ['error', 'errors']))
    if result['kind'] != kind:
        module.fail_json(msg="Incorrect result: {kind}".format(**result))

    return result


def is_different(module, response):
    request = resource_to_request(module)
    response = response_to_hash(module, response)

    # Remove all output-only from response.
    response_vals = {}
    for k, v in response.items():
        if k in request:
            response_vals[k] = v

    request_vals = {}
    for k, v in request.items():
        if k in response:
            request_vals[k] = v

    return GcpRequest(request_vals) != GcpRequest(response_vals)


# Remove unnecessary properties from the response.
# This is for doing comparisons with Ansible's current parameters.
def response_to_hash(module, response):
    return {
        u'destRange': response.get(u'destRange'),
        u'name': response.get(u'name'),
        u'network': replace_resource_dict(module.params.get(u'network', {}), 'selfLink'),
        u'priority': module.params.get('priority'),
        u'tags': module.params.get('tags'),
        u'nextHopGateway': module.params.get('next_hop_gateway'),
        u'nextHopInstance': module.params.get('next_hop_instance'),
        u'nextHopIp': module.params.get('next_hop_ip'),
        u'nextHopVpnTunnel': module.params.get('next_hop_vpn_tunnel')
    }


def async_op_url(module, extra_data=None):
    if extra_data is None:
        extra_data = {}
    url = "https://www.googleapis.com/compute/v1/projects/{project}/global/operations/{op_id}"
    combined = extra_data.copy()
    combined.update(module.params)
    return url.format(**combined)


def wait_for_operation(module, response):
    op_result = return_if_object(module, response, 'compute#operation')
    if op_result is None:
        return None
    status = navigate_hash(op_result, ['status'])
    wait_done = wait_for_completion(status, op_result, module)
    return fetch_resource(module, navigate_hash(wait_done, ['targetLink']), 'compute#route')


def wait_for_completion(status, op_result, module):
    op_id = navigate_hash(op_result, ['name'])
    op_uri = async_op_url(module, {'op_id': op_id})
    while status != 'DONE':
        raise_if_errors(op_result, ['error', 'errors'], 'message')
        time.sleep(1.0)
        if status not in ['PENDING', 'RUNNING', 'DONE']:
            module.fail_json(msg="Invalid result %s" % status)
        op_result = fetch_resource(module, op_uri, 'compute#operation')
        status = navigate_hash(op_result, ['status'])
    return op_result


def raise_if_errors(response, err_path, module):
    errors = navigate_hash(response, err_path)
    if errors is not None:
        module.fail_json(msg=errors)

if __name__ == '__main__':
    main()
