/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.embed.EmbeddedSceneInterface;
import com.sun.javafx.embed.EmbeddedStageInterface;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.stage.EmbeddedWindow;
import com.sun.javafx.tk.Toolkit;
import java.awt.AlphaComposite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.embed.swing.SwingCursors;
import javafx.embed.swing.SwingDnD;
import javafx.embed.swing.SwingEvents;
import javafx.scene.Scene;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import sun.awt.CausedFocusEvent;

public class JFXPanel
extends JComponent {
    private static PlatformImpl.FinishListener finishListener;
    private static boolean firstPanelShown;
    private HostContainer hostContainer;
    private volatile EmbeddedWindow stage;
    private volatile Scene scene;
    private final SwingDnD dnd;
    private EmbeddedStageInterface stagePeer;
    private EmbeddedSceneInterface scenePeer;
    private int pWidth = -1;
    private int pHeight = -1;
    private volatile int pPreferredWidth = -1;
    private volatile int pPreferredHeight = -1;
    private volatile int screenX = 0;
    private volatile int screenY = 0;
    private BufferedImage pixelsIm;
    private volatile float opacity = 1.0f;
    private volatile int disableCount = 0;
    private boolean isCapturingMouse = false;

    private static void initFx() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.setProperty("javafx.macosx.embedded", "true");
                return null;
            }
        });
        if (finishListener != null) {
            return;
        }
        finishListener = new PlatformImpl.FinishListener(){

            @Override
            public void idle(boolean bl) {
                if (!firstPanelShown) {
                    return;
                }
                PlatformImpl.removeListener(finishListener);
                JFXPanel.finishListener = null;
                if (bl) {
                    Platform.exit();
                }
            }

            @Override
            public void exitCalled() {
            }
        };
        PlatformImpl.addListener(finishListener);
        PlatformImpl.startup(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public JFXPanel() {
        JFXPanel.initFx();
        this.hostContainer = new HostContainer();
        this.enableEvents(229437L);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.dnd = new SwingDnD(this, new SwingDnD.JFXPanelFacade(){

            @Override
            public EmbeddedSceneInterface getScene() {
                return JFXPanel.this.isFxEnabled() ? JFXPanel.this.scenePeer : null;
            }
        });
    }

    public Scene getScene() {
        return this.scene;
    }

    public void setScene(final Scene scene) {
        if (Toolkit.getToolkit().isFxUserThread()) {
            this.setSceneImpl(scene);
        } else {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            Platform.runLater(new Runnable(){

                @Override
                public void run() {
                    JFXPanel.this.setSceneImpl(scene);
                    countDownLatch.countDown();
                }
            });
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace(System.err);
            }
        }
    }

    private void setSceneImpl(Scene scene) {
        if (this.stage != null && scene == null) {
            this.stage.hide();
            this.stage = null;
        }
        this.scene = scene;
        if (this.stage == null && scene != null) {
            this.stage = new EmbeddedWindow(this.hostContainer);
        }
        if (this.stage != null) {
            this.stage.setScene(scene);
            if (!this.stage.isShowing()) {
                this.stage.show();
                firstPanelShown = true;
            }
        }
    }

    @Override
    public final void setOpaque(boolean bl) {
        if (!bl) {
            super.setOpaque(bl);
        }
    }

    @Override
    public final boolean isOpaque() {
        return false;
    }

    private void sendMouseEventToFX(MouseEvent mouseEvent) {
        boolean bl;
        if (this.scenePeer == null || !this.isFxEnabled()) {
            return;
        }
        int n = mouseEvent.getModifiersEx();
        boolean bl2 = (n & 0x400) != 0;
        boolean bl3 = (n & 0x800) != 0;
        boolean bl4 = bl = (n & 0x1000) != 0;
        if (mouseEvent.getID() == 506) {
            if (!this.isCapturingMouse) {
                return;
            }
        } else if (mouseEvent.getID() == 501) {
            this.isCapturingMouse = true;
        } else if (mouseEvent.getID() == 502) {
            if (!this.isCapturingMouse) {
                return;
            }
            this.isCapturingMouse = bl2 || bl3 || bl;
        }
        this.scenePeer.mouseEvent(SwingEvents.mouseIDToEmbedMouseType(mouseEvent.getID()), SwingEvents.mouseButtonToEmbedMouseButton(mouseEvent.getButton(), n), bl2, bl3, bl, mouseEvent.getClickCount(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), (n & 0x40) != 0, (n & 0x80) != 0, (n & 0x200) != 0, (n & 0x100) != 0, SwingEvents.getWheelRotation(mouseEvent), mouseEvent.isPopupTrigger());
        if (mouseEvent.isPopupTrigger()) {
            this.scenePeer.menuEvent(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), false);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501 && mouseEvent.getButton() == 1 && !this.hasFocus()) {
            this.requestFocus();
        }
        this.sendMouseEventToFX(mouseEvent);
        super.processMouseEvent(mouseEvent);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        this.sendMouseEventToFX(mouseEvent);
        super.processMouseMotionEvent(mouseEvent);
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        this.sendMouseEventToFX(mouseWheelEvent);
        super.processMouseWheelEvent(mouseWheelEvent);
    }

    private void sendKeyEventToFX(KeyEvent keyEvent) {
        char[] cArray;
        if (this.scenePeer == null || !this.isFxEnabled()) {
            return;
        }
        if (keyEvent.getKeyChar() == '\uffff') {
            cArray = new char[]{};
        } else {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = keyEvent.getKeyChar();
        }
        char[] cArray3 = cArray;
        this.scenePeer.keyEvent(SwingEvents.keyIDToEmbedKeyType(keyEvent.getID()), keyEvent.getKeyCode(), cArray3, SwingEvents.keyModifiersToEmbedKeyModifiers(keyEvent.getModifiersEx()));
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        this.sendKeyEventToFX(keyEvent);
        super.processKeyEvent(keyEvent);
    }

    private void sendResizeEventToFX() {
        if (this.stagePeer != null) {
            this.stagePeer.setSize(this.pWidth, this.pHeight);
        }
        if (this.scenePeer != null) {
            this.scenePeer.setSize(this.pWidth, this.pHeight);
        }
    }

    @Override
    protected void processComponentEvent(ComponentEvent componentEvent) {
        switch (componentEvent.getID()) {
            case 101: {
                this.pWidth = Math.max(0, this.getWidth());
                this.pHeight = Math.max(0, this.getHeight());
                this.resizePixels();
                this.sendResizeEventToFX();
                break;
            }
            case 100: {
                if (!this.updateScreenLocation()) break;
                this.sendMoveEventToFX();
            }
        }
        super.processComponentEvent(componentEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateScreenLocation() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.isShowing()) {
                Point point = this.getLocationOnScreen();
                this.screenX = point.x;
                this.screenY = point.y;
                return true;
            }
        }
        return false;
    }

    private void sendMoveEventToFX() {
        if (this.stagePeer == null) {
            return;
        }
        this.stagePeer.setLocation(this.screenX, this.screenY);
    }

    @Override
    protected void processHierarchyBoundsEvent(HierarchyEvent hierarchyEvent) {
        if (hierarchyEvent.getID() == 1401 && this.updateScreenLocation()) {
            this.sendMoveEventToFX();
        }
        super.processHierarchyBoundsEvent(hierarchyEvent);
    }

    @Override
    protected void processHierarchyEvent(HierarchyEvent hierarchyEvent) {
        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && this.updateScreenLocation()) {
            this.sendMoveEventToFX();
        }
        super.processHierarchyEvent(hierarchyEvent);
    }

    private void sendFocusEventToFX(final FocusEvent focusEvent) {
        if (this.stage == null || this.stagePeer == null || !this.isFxEnabled()) {
            return;
        }
        final boolean bl = focusEvent.getID() == 1004;
        int n = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                int n;
                int n2 = n = bl ? 0 : 3;
                if (bl && focusEvent instanceof CausedFocusEvent) {
                    CausedFocusEvent causedFocusEvent = (CausedFocusEvent)focusEvent;
                    if (causedFocusEvent.getCause() == CausedFocusEvent.Cause.TRAVERSAL_FORWARD) {
                        n = 1;
                    } else if (causedFocusEvent.getCause() == CausedFocusEvent.Cause.TRAVERSAL_BACKWARD) {
                        n = 2;
                    }
                }
                return n;
            }
        });
        this.stagePeer.setFocused(bl, n);
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        this.sendFocusEventToFX(focusEvent);
        super.processFocusEvent(focusEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizePixels() {
        if (this.pWidth <= 0 || this.pHeight <= 0) {
            this.pixelsIm = null;
        } else {
            BufferedImage bufferedImage = this.pixelsIm;
            this.pixelsIm = new BufferedImage(this.pWidth, this.pHeight, 2);
            if (bufferedImage != null) {
                Graphics graphics = this.pixelsIm.getGraphics();
                try {
                    graphics.drawImage(bufferedImage, 0, 0, null);
                }
                finally {
                    graphics.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.scenePeer == null || this.pixelsIm == null) {
            return;
        }
        DataBufferInt dataBufferInt = (DataBufferInt)this.pixelsIm.getRaster().getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        IntBuffer intBuffer = IntBuffer.wrap(nArray);
        if (!this.scenePeer.getPixels(intBuffer, this.pWidth, this.pHeight)) {
            // empty if block
        }
        Graphics graphics2 = null;
        try {
            graphics2 = graphics.create();
            if (this.opacity < 1.0f && graphics2 instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics2;
                AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.opacity);
                graphics2D.setComposite(alphaComposite);
            }
            graphics2.drawImage(this.pixelsIm, 0, 0, null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            if (graphics2 != null) {
                graphics2.dispose();
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet() || this.scenePeer == null) {
            return super.getPreferredSize();
        }
        return new Dimension(this.pPreferredWidth, this.pPreferredHeight);
    }

    private boolean isFxEnabled() {
        return this.disableCount == 0;
    }

    private void setFxEnabled(boolean bl) {
        if (!bl) {
            ++this.disableCount;
        } else {
            if (this.disableCount == 0) {
                return;
            }
            --this.disableCount;
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.dnd.addNotify();
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                JFXPanel.this.resizePixels();
                if (JFXPanel.this.stage != null && !JFXPanel.this.stage.isShowing()) {
                    JFXPanel.this.stage.show();
                    firstPanelShown = true;
                    JFXPanel.this.sendMoveEventToFX();
                }
            }
        });
    }

    @Override
    public void removeNotify() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                if (JFXPanel.this.stage != null && JFXPanel.this.stage.isShowing()) {
                    JFXPanel.this.stage.hide();
                }
                JFXPanel.this.pixelsIm = null;
            }
        });
        super.removeNotify();
        this.dnd.removeNotify();
        this.getInputContext().removeNotify(this);
    }

    static {
        firstPanelShown = false;
    }

    private class HostContainer
    implements HostInterface {
        private HostContainer() {
        }

        @Override
        public void setEmbeddedStage(EmbeddedStageInterface embeddedStageInterface) {
            JFXPanel.this.stagePeer = embeddedStageInterface;
            if (JFXPanel.this.stagePeer == null) {
                return;
            }
            if (JFXPanel.this.pWidth > 0 && JFXPanel.this.pHeight > 0) {
                JFXPanel.this.stagePeer.setSize(JFXPanel.this.pWidth, JFXPanel.this.pHeight);
            }
            if (JFXPanel.this.isFocusOwner()) {
                JFXPanel.this.stagePeer.setFocused(true, 0);
            }
            JFXPanel.this.sendMoveEventToFX();
        }

        @Override
        public void setEmbeddedScene(EmbeddedSceneInterface embeddedSceneInterface) {
            JFXPanel.this.scenePeer = embeddedSceneInterface;
            if (JFXPanel.this.scenePeer == null) {
                return;
            }
            if (JFXPanel.this.pWidth > 0 && JFXPanel.this.pHeight > 0) {
                JFXPanel.this.scenePeer.setSize(JFXPanel.this.pWidth, JFXPanel.this.pHeight);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JFXPanel.this.scenePeer.setDragStartListener(JFXPanel.this.dnd.getDragStartListener());
                }
            });
        }

        @Override
        public boolean requestFocus() {
            return JFXPanel.this.requestFocusInWindow();
        }

        @Override
        public boolean traverseFocusOut(boolean bl) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            if (bl) {
                keyboardFocusManager.focusNextComponent(JFXPanel.this);
            } else {
                keyboardFocusManager.focusPreviousComponent(JFXPanel.this);
            }
            return true;
        }

        @Override
        public void setPreferredSize(int n, int n2) {
            JFXPanel.this.pPreferredWidth = n;
            JFXPanel.this.pPreferredHeight = n2;
            JFXPanel.this.revalidate();
        }

        @Override
        public void repaint() {
            JFXPanel.this.repaint();
        }

        @Override
        public void setEnabled(boolean bl) {
            JFXPanel.this.setFxEnabled(bl);
        }

        @Override
        public void setCursor(CursorFrame cursorFrame) {
            final Cursor cursor = this.getPlatformCursor(cursorFrame);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JFXPanel.this.setCursor(cursor);
                }
            });
        }

        private Cursor getPlatformCursor(CursorFrame cursorFrame) {
            Cursor cursor = cursorFrame.getPlatformCursor(Cursor.class);
            if (cursor != null) {
                return cursor;
            }
            Cursor cursor2 = SwingCursors.embedCursorToCursor(cursorFrame);
            cursorFrame.setPlatforCursor(Cursor.class, cursor2);
            return cursor2;
        }
    }
}

