/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.values.CssValue;

public class CssRatio
extends CssValue {
    public static final int type = 13;
    float w;
    boolean isWInt;
    float h;
    boolean isHInt;

    @Override
    public final int getType() {
        return 13;
    }

    @Override
    public void set(String s, ApplContext ac) throws InvalidParamException {
        int slash = (s = s.toLowerCase()).indexOf(47);
        if (slash == -1) {
            throw new InvalidParamException("value", s, ac);
        }
        String sw = s.substring(0, slash).trim();
        String sh = s.substring(slash + 1).trim();
        try {
            this.w = Integer.parseInt(sw);
            this.isWInt = true;
        }
        catch (NumberFormatException nex) {
            try {
                this.w = Float.parseFloat(sw);
            }
            catch (NumberFormatException ne) {
                throw new InvalidParamException("value", s, ac);
            }
        }
        if (this.w <= 0.0f) {
            throw new InvalidParamException("strictly-positive", s, ac);
        }
        try {
            this.h = Integer.parseInt(sh);
            this.isHInt = true;
        }
        catch (NumberFormatException nex) {
            try {
                this.h = Float.parseFloat(sh);
            }
            catch (NumberFormatException ne) {
                throw new InvalidParamException("value", s, ac);
            }
        }
        if (this.h <= 0.0f) {
            throw new InvalidParamException("strictly-positive", s, ac);
        }
    }

    @Override
    public Object get() {
        return this.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isWInt ? Integer.toString((int)this.w) : Util.displayFloat(this.w));
        sb.append('/');
        sb.append(this.isHInt ? Integer.toString((int)this.h) : Util.displayFloat(this.h));
        return sb.toString();
    }

    @Override
    public boolean equals(Object value) {
        try {
            CssRatio other = (CssRatio)value;
            return Float.compare(this.w / this.h, other.w / other.h) == 0;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }
}

