/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.action;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.visual.widget.Widget;

public interface WidgetAction {
    public State mouseClicked(Widget var1, WidgetMouseEvent var2);

    public State mousePressed(Widget var1, WidgetMouseEvent var2);

    public State mouseReleased(Widget var1, WidgetMouseEvent var2);

    public State mouseEntered(Widget var1, WidgetMouseEvent var2);

    public State mouseExited(Widget var1, WidgetMouseEvent var2);

    public State mouseDragged(Widget var1, WidgetMouseEvent var2);

    public State mouseMoved(Widget var1, WidgetMouseEvent var2);

    public State mouseWheelMoved(Widget var1, WidgetMouseWheelEvent var2);

    public State keyTyped(Widget var1, WidgetKeyEvent var2);

    public State keyPressed(Widget var1, WidgetKeyEvent var2);

    public State keyReleased(Widget var1, WidgetKeyEvent var2);

    public State focusGained(Widget var1, WidgetFocusEvent var2);

    public State focusLost(Widget var1, WidgetFocusEvent var2);

    public State dragEnter(Widget var1, WidgetDropTargetDragEvent var2);

    public State dragOver(Widget var1, WidgetDropTargetDragEvent var2);

    public State dropActionChanged(Widget var1, WidgetDropTargetDragEvent var2);

    public State dragExit(Widget var1, WidgetDropTargetEvent var2);

    public State drop(Widget var1, WidgetDropTargetDropEvent var2);

    public static class Adapter
    implements WidgetAction {
        public State mouseClicked(Widget widget, WidgetMouseEvent widgetMouseEvent) {
            return State.REJECTED;
        }

        public State mousePressed(Widget widget, WidgetMouseEvent widgetMouseEvent) {
            return State.REJECTED;
        }

        public State mouseReleased(Widget widget, WidgetMouseEvent widgetMouseEvent) {
            return State.REJECTED;
        }

        public State mouseEntered(Widget widget, WidgetMouseEvent widgetMouseEvent) {
            return State.REJECTED;
        }

        public State mouseExited(Widget widget, WidgetMouseEvent widgetMouseEvent) {
            return State.REJECTED;
        }

        public State mouseDragged(Widget widget, WidgetMouseEvent widgetMouseEvent) {
            return State.REJECTED;
        }

        public State mouseMoved(Widget widget, WidgetMouseEvent widgetMouseEvent) {
            return State.REJECTED;
        }

        public State mouseWheelMoved(Widget widget, WidgetMouseWheelEvent widgetMouseWheelEvent) {
            return State.REJECTED;
        }

        public State keyTyped(Widget widget, WidgetKeyEvent widgetKeyEvent) {
            return State.REJECTED;
        }

        public State keyPressed(Widget widget, WidgetKeyEvent widgetKeyEvent) {
            return State.REJECTED;
        }

        public State keyReleased(Widget widget, WidgetKeyEvent widgetKeyEvent) {
            return State.REJECTED;
        }

        public State focusGained(Widget widget, WidgetFocusEvent widgetFocusEvent) {
            return State.REJECTED;
        }

        public State focusLost(Widget widget, WidgetFocusEvent widgetFocusEvent) {
            return State.REJECTED;
        }

        public State dragEnter(Widget widget, WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
            return State.REJECTED;
        }

        public State dragOver(Widget widget, WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
            return State.REJECTED;
        }

        public State dropActionChanged(Widget widget, WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
            return State.REJECTED;
        }

        public State dragExit(Widget widget, WidgetDropTargetEvent widgetDropTargetEvent) {
            return State.REJECTED;
        }

        public State drop(Widget widget, WidgetDropTargetDropEvent widgetDropTargetDropEvent) {
            return State.REJECTED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Chain
    implements WidgetAction {
        private List<WidgetAction> actions = new ArrayList<WidgetAction>();
        private List<WidgetAction> actionsUm = Collections.unmodifiableList(this.actions);

        public List<WidgetAction> getActions() {
            return this.actionsUm;
        }

        public void addAction(WidgetAction widgetAction) {
            assert (widgetAction != null);
            this.actions.add(widgetAction);
        }

        public void addAction(int n, WidgetAction widgetAction) {
            assert (widgetAction != null);
            this.actions.add(n, widgetAction);
        }

        public void removeAction(WidgetAction widgetAction) {
            this.actions.remove(widgetAction);
        }

        public void removeAction(int n) {
            this.actions.remove(n);
        }

        @Override
        public State mouseClicked(Widget widget, WidgetMouseEvent widgetMouseEvent) {
            WidgetAction[] widgetActionArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State state = State.REJECTED;
            for (WidgetAction widgetAction : widgetActionArray) {
                State state2 = widgetAction.mouseClicked(widget, widgetMouseEvent);
                if (state2.isConsumed()) {
                    return state2;
                }
                if (!state2.isLockedInChain()) continue;
                state = State.CONSUMED;
            }
            return state;
        }

        @Override
        public State mousePressed(Widget widget, WidgetMouseEvent widgetMouseEvent) {
            WidgetAction[] widgetActionArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State state = State.REJECTED;
            for (WidgetAction widgetAction : widgetActionArray) {
                State state2 = widgetAction.mousePressed(widget, widgetMouseEvent);
                if (state2.isConsumed()) {
                    return state2;
                }
                if (!state2.isLockedInChain()) continue;
                state = State.CONSUMED;
            }
            return state;
        }

        @Override
        public State mouseReleased(Widget widget, WidgetMouseEvent widgetMouseEvent) {
            WidgetAction[] widgetActionArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State state = State.REJECTED;
            for (WidgetAction widgetAction : widgetActionArray) {
                State state2 = widgetAction.mouseReleased(widget, widgetMouseEvent);
                if (state2.isConsumed()) {
                    return state2;
                }
                if (!state2.isLockedInChain()) continue;
                state = State.CONSUMED;
            }
            return state;
        }

        @Override
        public State mouseEntered(Widget widget, WidgetMouseEvent widgetMouseEvent) {
            WidgetAction[] widgetActionArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State state = State.REJECTED;
            for (WidgetAction widgetAction : widgetActionArray) {
                State state2 = widgetAction.mouseEntered(widget, widgetMouseEvent);
                if (state2.isConsumed()) {
                    return state2;
                }
                if (!state2.isLockedInChain()) continue;
                state = State.CONSUMED;
            }
            return state;
        }

        @Override
        public State mouseExited(Widget widget, WidgetMouseEvent widgetMouseEvent) {
            WidgetAction[] widgetActionArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State state = State.REJECTED;
            for (WidgetAction widgetAction : widgetActionArray) {
                State state2 = widgetAction.mouseExited(widget, widgetMouseEvent);
                if (state2.isConsumed()) {
                    return state2;
                }
                if (!state2.isLockedInChain()) continue;
                state = State.CONSUMED;
            }
            return state;
        }

        @Override
        public State mouseDragged(Widget widget, WidgetMouseEvent widgetMouseEvent) {
            WidgetAction[] widgetActionArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State state = State.REJECTED;
            for (WidgetAction widgetAction : widgetActionArray) {
                State state2 = widgetAction.mouseDragged(widget, widgetMouseEvent);
                if (state2.isConsumed()) {
                    return state2;
                }
                if (!state2.isLockedInChain()) continue;
                state = State.CONSUMED;
            }
            return state;
        }

        @Override
        public State mouseMoved(Widget widget, WidgetMouseEvent widgetMouseEvent) {
            WidgetAction[] widgetActionArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State state = State.REJECTED;
            for (WidgetAction widgetAction : widgetActionArray) {
                State state2 = widgetAction.mouseMoved(widget, widgetMouseEvent);
                if (state2.isConsumed()) {
                    return state2;
                }
                if (!state2.isLockedInChain()) continue;
                state = State.CONSUMED;
            }
            return state;
        }

        @Override
        public State mouseWheelMoved(Widget widget, WidgetMouseWheelEvent widgetMouseWheelEvent) {
            WidgetAction[] widgetActionArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State state = State.REJECTED;
            for (WidgetAction widgetAction : widgetActionArray) {
                State state2 = widgetAction.mouseWheelMoved(widget, widgetMouseWheelEvent);
                if (state2.isConsumed()) {
                    return state2;
                }
                if (!state2.isLockedInChain()) continue;
                state = State.CONSUMED;
            }
            return state;
        }

        @Override
        public State keyTyped(Widget widget, WidgetKeyEvent widgetKeyEvent) {
            WidgetAction[] widgetActionArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State state = State.REJECTED;
            for (WidgetAction widgetAction : widgetActionArray) {
                State state2 = widgetAction.keyTyped(widget, widgetKeyEvent);
                if (state2.isConsumed()) {
                    return state2;
                }
                if (!state2.isLockedInChain()) continue;
                state = State.CONSUMED;
            }
            return state;
        }

        @Override
        public State keyPressed(Widget widget, WidgetKeyEvent widgetKeyEvent) {
            WidgetAction[] widgetActionArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State state = State.REJECTED;
            for (WidgetAction widgetAction : widgetActionArray) {
                State state2 = widgetAction.keyPressed(widget, widgetKeyEvent);
                if (state2.isConsumed()) {
                    return state2;
                }
                if (!state2.isLockedInChain()) continue;
                state = State.CONSUMED;
            }
            return state;
        }

        @Override
        public State keyReleased(Widget widget, WidgetKeyEvent widgetKeyEvent) {
            WidgetAction[] widgetActionArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State state = State.REJECTED;
            for (WidgetAction widgetAction : widgetActionArray) {
                State state2 = widgetAction.keyReleased(widget, widgetKeyEvent);
                if (state2.isConsumed()) {
                    return state2;
                }
                if (!state2.isLockedInChain()) continue;
                state = State.CONSUMED;
            }
            return state;
        }

        @Override
        public State focusGained(Widget widget, WidgetFocusEvent widgetFocusEvent) {
            WidgetAction[] widgetActionArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State state = State.REJECTED;
            for (WidgetAction widgetAction : widgetActionArray) {
                State state2 = widgetAction.focusGained(widget, widgetFocusEvent);
                if (state2.isConsumed()) {
                    return state2;
                }
                if (!state2.isLockedInChain()) continue;
                state = State.CONSUMED;
            }
            return state;
        }

        @Override
        public State focusLost(Widget widget, WidgetFocusEvent widgetFocusEvent) {
            WidgetAction[] widgetActionArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State state = State.REJECTED;
            for (WidgetAction widgetAction : widgetActionArray) {
                State state2 = widgetAction.focusLost(widget, widgetFocusEvent);
                if (state2.isConsumed()) {
                    return state2;
                }
                if (!state2.isLockedInChain()) continue;
                state = State.CONSUMED;
            }
            return state;
        }

        @Override
        public State dragEnter(Widget widget, WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
            WidgetAction[] widgetActionArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State state = State.REJECTED;
            for (WidgetAction widgetAction : widgetActionArray) {
                State state2 = widgetAction.dragEnter(widget, widgetDropTargetDragEvent);
                if (state2.isConsumed()) {
                    return state2;
                }
                if (!state2.isLockedInChain()) continue;
                state = State.CONSUMED;
            }
            return state;
        }

        @Override
        public State dragOver(Widget widget, WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
            WidgetAction[] widgetActionArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State state = State.REJECTED;
            for (WidgetAction widgetAction : widgetActionArray) {
                State state2 = widgetAction.dragOver(widget, widgetDropTargetDragEvent);
                if (state2.isConsumed()) {
                    return state2;
                }
                if (!state2.isLockedInChain()) continue;
                state = State.CONSUMED;
            }
            return state;
        }

        @Override
        public State dropActionChanged(Widget widget, WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
            WidgetAction[] widgetActionArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State state = State.REJECTED;
            for (WidgetAction widgetAction : widgetActionArray) {
                State state2 = widgetAction.dropActionChanged(widget, widgetDropTargetDragEvent);
                if (state2.isConsumed()) {
                    return state2;
                }
                if (!state2.isLockedInChain()) continue;
                state = State.CONSUMED;
            }
            return state;
        }

        @Override
        public State dragExit(Widget widget, WidgetDropTargetEvent widgetDropTargetEvent) {
            WidgetAction[] widgetActionArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State state = State.REJECTED;
            for (WidgetAction widgetAction : widgetActionArray) {
                State state2 = widgetAction.dragExit(widget, widgetDropTargetEvent);
                if (state2.isConsumed()) {
                    return state2;
                }
                if (!state2.isLockedInChain()) continue;
                state = State.CONSUMED;
            }
            return state;
        }

        @Override
        public State drop(Widget widget, WidgetDropTargetDropEvent widgetDropTargetDropEvent) {
            WidgetAction[] widgetActionArray = this.actions.toArray(new WidgetAction[this.actions.size()]);
            State state = State.REJECTED;
            for (WidgetAction widgetAction : widgetActionArray) {
                State state2 = widgetAction.drop(widget, widgetDropTargetDropEvent);
                if (state2.isConsumed()) {
                    return state2;
                }
                if (!state2.isLockedInChain()) continue;
                state = State.CONSUMED;
            }
            return state;
        }
    }

    public static abstract class LockedAdapter
    implements WidgetAction {
        protected abstract boolean isLocked();

        public State mouseClicked(Widget widget, WidgetMouseEvent widgetMouseEvent) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        public State mousePressed(Widget widget, WidgetMouseEvent widgetMouseEvent) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        public State mouseReleased(Widget widget, WidgetMouseEvent widgetMouseEvent) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        public State mouseEntered(Widget widget, WidgetMouseEvent widgetMouseEvent) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        public State mouseExited(Widget widget, WidgetMouseEvent widgetMouseEvent) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        public State mouseDragged(Widget widget, WidgetMouseEvent widgetMouseEvent) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        public State mouseMoved(Widget widget, WidgetMouseEvent widgetMouseEvent) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        public State mouseWheelMoved(Widget widget, WidgetMouseWheelEvent widgetMouseWheelEvent) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        public State keyTyped(Widget widget, WidgetKeyEvent widgetKeyEvent) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        public State keyPressed(Widget widget, WidgetKeyEvent widgetKeyEvent) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        public State keyReleased(Widget widget, WidgetKeyEvent widgetKeyEvent) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        public State focusGained(Widget widget, WidgetFocusEvent widgetFocusEvent) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        public State focusLost(Widget widget, WidgetFocusEvent widgetFocusEvent) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        public State dragEnter(Widget widget, WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        public State dragOver(Widget widget, WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        public State dropActionChanged(Widget widget, WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        public State dragExit(Widget widget, WidgetDropTargetEvent widgetDropTargetEvent) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }

        public State drop(Widget widget, WidgetDropTargetDropEvent widgetDropTargetDropEvent) {
            return this.isLocked() ? State.createLocked(widget, this) : State.REJECTED;
        }
    }

    public static abstract class State {
        public static final State REJECTED = new State(){

            public boolean isLockedInChain() {
                return false;
            }

            public boolean isConsumed() {
                return false;
            }

            public Widget getLockedWidget() {
                return null;
            }

            public WidgetAction getLockedAction() {
                return null;
            }
        };
        public static final State CONSUMED = new State(){

            public boolean isLockedInChain() {
                return false;
            }

            public boolean isConsumed() {
                return true;
            }

            public Widget getLockedWidget() {
                return null;
            }

            public WidgetAction getLockedAction() {
                return null;
            }
        };
        public static final State CHAIN_ONLY = new State(){

            public boolean isLockedInChain() {
                return true;
            }

            public boolean isConsumed() {
                return false;
            }

            public Widget getLockedWidget() {
                return null;
            }

            public WidgetAction getLockedAction() {
                return null;
            }
        };

        public static State createLocked(final Widget widget, final WidgetAction widgetAction) {
            assert (widget != null);
            assert (widgetAction != null);
            return new State(){

                public boolean isLockedInChain() {
                    return false;
                }

                public boolean isConsumed() {
                    return true;
                }

                public Widget getLockedWidget() {
                    return widget;
                }

                public WidgetAction getLockedAction() {
                    return widgetAction;
                }
            };
        }

        private State() {
        }

        public abstract boolean isLockedInChain();

        public abstract boolean isConsumed();

        public abstract Widget getLockedWidget();

        public abstract WidgetAction getLockedAction();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class WidgetDropTargetDragEvent
    implements WidgetLocationEvent {
        private long id;
        private DropTargetDragEvent event;
        private int x;
        private int y;

        public WidgetDropTargetDragEvent(long l, DropTargetDragEvent dropTargetDragEvent) {
            this.id = l;
            this.event = dropTargetDragEvent;
            Point point = dropTargetDragEvent.getLocation();
            this.x = point.x;
            this.y = point.y;
        }

        @Override
        public long getEventID() {
            return this.id;
        }

        @Override
        public Point getPoint() {
            return new Point(this.x, this.y);
        }

        @Override
        public void setPoint(Point point) {
            this.x = point.x;
            this.y = point.y;
        }

        @Override
        public void translatePoint(int n, int n2) {
            this.x += n;
            this.y += n2;
        }

        public DataFlavor[] getCurrentDataFlavors() {
            return this.event.getCurrentDataFlavors();
        }

        public List<DataFlavor> getCurrentDataFlavorsAsList() {
            return this.event.getCurrentDataFlavorsAsList();
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return this.event.isDataFlavorSupported(dataFlavor);
        }

        public int getSourceActions() {
            return this.event.getSourceActions();
        }

        public int getDropAction() {
            return this.event.getDropAction();
        }

        public Transferable getTransferable() {
            return this.event.getTransferable();
        }

        public DropTargetContext getDropTargetContext() {
            return this.event.getDropTargetContext();
        }

        public void acceptDrag(int n) {
            this.event.acceptDrag(n);
        }

        public void rejectDrag() {
            this.event.rejectDrag();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class WidgetDropTargetDropEvent
    implements WidgetLocationEvent {
        private long id;
        private DropTargetDropEvent event;
        private int x;
        private int y;

        public WidgetDropTargetDropEvent(long l, DropTargetDropEvent dropTargetDropEvent) {
            this.id = l;
            this.event = dropTargetDropEvent;
            Point point = dropTargetDropEvent.getLocation();
            this.x = point.x;
            this.y = point.y;
        }

        @Override
        public long getEventID() {
            return this.id;
        }

        @Override
        public Point getPoint() {
            return new Point(this.x, this.y);
        }

        @Override
        public void setPoint(Point point) {
            this.x = point.x;
            this.y = point.y;
        }

        @Override
        public void translatePoint(int n, int n2) {
            this.x += n;
            this.y += n2;
        }

        public DataFlavor[] getCurrentDataFlavors() {
            return this.event.getCurrentDataFlavors();
        }

        public List<DataFlavor> getCurrentDataFlavorsAsList() {
            return this.event.getCurrentDataFlavorsAsList();
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return this.event.isDataFlavorSupported(dataFlavor);
        }

        public int getSourceActions() {
            return this.event.getSourceActions();
        }

        public int getDropAction() {
            return this.event.getDropAction();
        }

        public Transferable getTransferable() {
            return this.event.getTransferable();
        }

        public boolean isLocalTransfer() {
            return this.event.isLocalTransfer();
        }

        public DropTargetContext getDropTargetContext() {
            return this.event.getDropTargetContext();
        }

        public void acceptDrop(int n) {
            this.event.acceptDrop(n);
        }

        public void rejectDrop() {
            this.event.rejectDrop();
        }
    }

    public static final class WidgetDropTargetEvent
    implements WidgetEvent {
        private long id;
        private DropTargetEvent event;

        public WidgetDropTargetEvent(long l, DropTargetEvent dropTargetEvent) {
            this.id = l;
            this.event = dropTargetEvent;
        }

        public long getEventID() {
            return this.id;
        }

        public DropTargetContext getDropTargetContext() {
            return this.event.getDropTargetContext();
        }
    }

    public static interface WidgetEvent {
        public long getEventID();
    }

    public static final class WidgetFocusEvent
    implements WidgetEvent {
        private long id;
        private FocusEvent event;

        public WidgetFocusEvent(long l, FocusEvent focusEvent) {
            this.id = l;
            this.event = focusEvent;
        }

        public long getEventID() {
            return this.id;
        }

        public Object getOppositeComponent() {
            return this.event.getOppositeComponent();
        }

        public String paramString() {
            return this.event.paramString();
        }

        public boolean isTemporary() {
            return this.event.isTemporary();
        }
    }

    public static final class WidgetKeyEvent
    implements WidgetEvent {
        private long id;
        private KeyEvent event;

        public WidgetKeyEvent(long l, KeyEvent keyEvent) {
            this.id = l;
            this.event = keyEvent;
        }

        public long getEventID() {
            return this.id;
        }

        public int getKeyCode() {
            return this.event.getKeyCode();
        }

        public char getKeyChar() {
            return this.event.getKeyChar();
        }

        public int getKeyLocation() {
            return this.event.getKeyLocation();
        }

        public boolean isActionKey() {
            return this.event.isActionKey();
        }

        public boolean isShiftDown() {
            return this.event.isShiftDown();
        }

        public boolean isControlDown() {
            return this.event.isControlDown();
        }

        public boolean isMetaDown() {
            return this.event.isMetaDown();
        }

        public boolean isAltDown() {
            return this.event.isAltDown();
        }

        public boolean isAltGraphDown() {
            return this.event.isAltGraphDown();
        }

        public long getWhen() {
            return this.event.getWhen();
        }

        public int getModifiers() {
            return this.event.getModifiers();
        }

        public int getModifiersEx() {
            return this.event.getModifiersEx();
        }
    }

    public static interface WidgetLocationEvent
    extends WidgetEvent {
        public Point getPoint();

        public void setPoint(Point var1);

        public void translatePoint(int var1, int var2);
    }

    public static final class WidgetMouseEvent
    implements WidgetLocationEvent {
        private long id;
        private MouseEvent event;
        private int x;
        private int y;

        public WidgetMouseEvent(long l, MouseEvent mouseEvent) {
            this.id = l;
            this.event = mouseEvent;
            this.x = mouseEvent.getX();
            this.y = mouseEvent.getY();
        }

        public long getEventID() {
            return this.id;
        }

        public Point getPoint() {
            return new Point(this.x, this.y);
        }

        public void setPoint(Point point) {
            this.x = point.x;
            this.y = point.y;
        }

        public void translatePoint(int n, int n2) {
            this.x += n;
            this.y += n2;
        }

        public int getClickCount() {
            return this.event.getClickCount();
        }

        public int getButton() {
            return this.event.getButton();
        }

        public boolean isPopupTrigger() {
            return this.event.isPopupTrigger();
        }

        public boolean isShiftDown() {
            return this.event.isShiftDown();
        }

        public boolean isControlDown() {
            return this.event.isControlDown();
        }

        public boolean isMetaDown() {
            return this.event.isMetaDown();
        }

        public boolean isAltDown() {
            return this.event.isAltDown();
        }

        public boolean isAltGraphDown() {
            return this.event.isAltGraphDown();
        }

        public long getWhen() {
            return this.event.getWhen();
        }

        public int getModifiers() {
            return this.event.getModifiers();
        }

        public int getModifiersEx() {
            return this.event.getModifiersEx();
        }
    }

    public static final class WidgetMouseWheelEvent
    implements WidgetLocationEvent {
        private long id;
        private MouseWheelEvent event;
        private int x;
        private int y;

        public WidgetMouseWheelEvent(long l, MouseWheelEvent mouseWheelEvent) {
            this.id = l;
            this.event = mouseWheelEvent;
            this.x = mouseWheelEvent.getX();
            this.y = mouseWheelEvent.getY();
        }

        public long getEventID() {
            return this.id;
        }

        public Point getPoint() {
            return new Point(this.x, this.y);
        }

        public void setPoint(Point point) {
            this.x = point.x;
            this.y = point.y;
        }

        public void translatePoint(int n, int n2) {
            this.x += n;
            this.y += n2;
        }

        public int getClickCount() {
            return this.event.getClickCount();
        }

        public int getButton() {
            return this.event.getButton();
        }

        public boolean isPopupTrigger() {
            return this.event.isPopupTrigger();
        }

        public boolean isShiftDown() {
            return this.event.isShiftDown();
        }

        public boolean isControlDown() {
            return this.event.isControlDown();
        }

        public boolean isMetaDown() {
            return this.event.isMetaDown();
        }

        public boolean isAltDown() {
            return this.event.isAltDown();
        }

        public boolean isAltGraphDown() {
            return this.event.isAltGraphDown();
        }

        public long getWhen() {
            return this.event.getWhen();
        }

        public int getModifiers() {
            return this.event.getModifiers();
        }

        public int getModifiersEx() {
            return this.event.getModifiersEx();
        }

        public int getScrollType() {
            return this.event.getScrollType();
        }

        public int getScrollAmount() {
            return this.event.getScrollAmount();
        }

        public int getWheelRotation() {
            return this.event.getWheelRotation();
        }

        public int getUnitsToScroll() {
            return this.event.getUnitsToScroll();
        }
    }
}

