/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.RrdDef;

abstract class DataImporter {
    DataImporter() {
    }

    abstract String getVersion() throws IOException;

    abstract long getLastUpdateTime() throws IOException;

    abstract long getStep() throws IOException;

    abstract int getDsCount() throws IOException;

    abstract int getArcCount() throws IOException;

    abstract String getDsName(int var1) throws IOException;

    abstract String getDsType(int var1) throws IOException;

    abstract long getHeartbeat(int var1) throws IOException;

    abstract double getMinValue(int var1) throws IOException;

    abstract double getMaxValue(int var1) throws IOException;

    abstract double getLastValue(int var1) throws IOException;

    abstract double getAccumValue(int var1) throws IOException;

    abstract long getNanSeconds(int var1) throws IOException;

    abstract ConsolFun getConsolFun(int var1) throws IOException;

    abstract double getXff(int var1) throws IOException;

    abstract int getSteps(int var1) throws IOException;

    abstract int getRows(int var1) throws IOException;

    abstract double getStateAccumValue(int var1, int var2) throws IOException;

    abstract int getStateNanSteps(int var1, int var2) throws IOException;

    abstract double[] getValues(int var1, int var2) throws IOException;

    long getEstimatedSize() throws IOException {
        int dsCount = this.getDsCount();
        int arcCount = this.getArcCount();
        int rowCount = 0;
        for (int i = 0; i < arcCount; ++i) {
            rowCount += this.getRows(i);
        }
        String[] dsNames = new String[this.getDsCount()];
        for (int i = 0; i < dsNames.length; ++i) {
            dsNames[i] = this.getDsName(i);
        }
        return RrdDef.calculateSize(dsCount, arcCount, rowCount, dsNames);
    }

    void release() throws IOException {
    }
}

