/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.ide.actions.ToggleDistractionFreeModeAction;
import com.intellij.ide.actions.ToggleToolbarAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.impl.InternalDecorator;

class TerminalToolWindowPanel
extends SimpleToolWindowPanel
implements UISettingsListener {
    private final PropertiesComponent myPropertiesComponent;
    private final ToolWindow myWindow;

    public TerminalToolWindowPanel(PropertiesComponent propertiesComponent, ToolWindow window) {
        super(false, true);
        this.myPropertiesComponent = propertiesComponent;
        this.myWindow = window;
    }

    public void uiSettingsChanged(UISettings uiSettings) {
        this.updateDFState();
    }

    private void updateDFState() {
        if (TerminalToolWindowPanel.isDfmSupportEnabled()) {
            this.setDistractionFree(this.shouldMakeDistractionFree());
        }
    }

    private void setDistractionFree(boolean isDistractionFree) {
        boolean isVisible = !isDistractionFree;
        this.setToolbarVisible(isVisible);
        this.setToolWindowHeaderVisible(isVisible);
    }

    private void setToolbarVisible(boolean isVisible) {
        ToggleToolbarAction.setToolbarVisible((ToolWindow)this.myWindow, (PropertiesComponent)this.myPropertiesComponent, (Boolean)isVisible);
    }

    private void setToolWindowHeaderVisible(boolean isVisible) {
        InternalDecorator decorator = ((ToolWindowEx)this.myWindow).getDecorator();
        decorator.setHeaderVisible(isVisible);
    }

    private boolean shouldMakeDistractionFree() {
        return !this.myWindow.getAnchor().isHorizontal() && ToggleDistractionFreeModeAction.isDistractionFreeModeEnabled();
    }

    public void addNotify() {
        super.addNotify();
        this.updateDFState();
    }

    private static boolean isDfmSupportEnabled() {
        return Registry.get((String)"terminal.distraction.free").asBoolean();
    }
}

