/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.javafx;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.NettyKt;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SafeOpener {
    private static final Logger LOG = Logger.getInstance(SafeOpener.class);
    private static final Set<String> SCHEMES = ContainerUtil.newTroveSet((Object[])new String[]{"http", "https"});
    private static final Set<String> SAFE_LOCAL_EXTENSIONS = ContainerUtil.newTroveSet((Object[])new String[]{"md", "png", "gif", "jpg", "jpeg", "bmp", "svg", "html"});

    private SafeOpener() {
    }

    static void openLink(@NotNull String link) {
        URI uri;
        if (link == null) {
            SafeOpener.$$$reportNull$$$0(0);
        }
        try {
            uri = !BrowserUtil.isAbsoluteURL((String)link) ? new URI("http://" + link) : new URI(link);
        }
        catch (URISyntaxException e) {
            LOG.info((Throwable)e);
            return;
        }
        if (SafeOpener.tryOpenInEditor(uri)) {
            return;
        }
        if (!SafeOpener.isHttpScheme(uri.getScheme()) || SafeOpener.isLocalHost(uri.getHost()) && !SafeOpener.isSafeExtension(uri.getPath())) {
            LOG.warn("Bad URL", (Throwable)new InaccessibleURLOpenedException(link));
            return;
        }
        BrowserUtil.browse((URI)uri);
    }

    private static boolean tryOpenInEditor(@NotNull URI uri) {
        if (uri == null) {
            SafeOpener.$$$reportNull$$$0(1);
        }
        if (!"file".equals(uri.getScheme())) {
            return false;
        }
        Pair result = (Pair)ReadAction.compute(() -> {
            VirtualFile virtualFile;
            if (uri == null) {
                SafeOpener.$$$reportNull$$$0(2);
            }
            if ((virtualFile = VirtualFileManager.getInstance().findFileByUrl(uri.toString())) == null) {
                return null;
            }
            Project project = ProjectUtil.guessProjectForContentFile((VirtualFile)virtualFile);
            if (project != null) {
                return Pair.create((Object)project, (Object)virtualFile);
            }
            return null;
        });
        if (result != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                new OpenFileDescriptor((Project)result.first, (VirtualFile)result.second).navigate(true);
                com.intellij.ide.impl.ProjectUtil.focusProjectWindow((Project)((Project)result.first), (boolean)true);
            });
        }
        return result != null;
    }

    private static boolean isHttpScheme(@Nullable String scheme) {
        return scheme != null && SCHEMES.contains(scheme.toLowerCase(Locale.US));
    }

    private static boolean isLocalHost(@Nullable String hostName) {
        return hostName == null || hostName.startsWith("127.") || hostName.endsWith(":1") || NettyKt.isLocalHost((String)hostName, (boolean)false, (boolean)false);
    }

    private static boolean isSafeExtension(@Nullable String path) {
        if (path == null) {
            return false;
        }
        int i = path.lastIndexOf(46);
        return i != -1 && SAFE_LOCAL_EXTENSIONS.contains(path.substring(i + 1).toLowerCase(Locale.US));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/javafx/SafeOpener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "openLink";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "tryOpenInEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$tryOpenInEditor$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class InaccessibleURLOpenedException
    extends IllegalArgumentException {
        public InaccessibleURLOpenedException(String link) {
            super(link);
        }
    }
}

