/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import javax.swing.UIManager;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.settings.MarkdownCssSettings;
import org.jetbrains.annotations.Nullable;

class MarkdownLAFListener
implements LafManagerListener {
    private boolean isLastLAFWasDarcula = UIUtil.isUnderDarcula();

    MarkdownLAFListener() {
    }

    public void lookAndFeelChanged(LafManager source) {
        UIManager.LookAndFeelInfo newLookAndFeel = source.getCurrentLookAndFeel();
        boolean isNewLookAndFeelDarcula = MarkdownLAFListener.isDarcula(newLookAndFeel);
        if (isNewLookAndFeelDarcula == this.isLastLAFWasDarcula) {
            return;
        }
        this.updateCssSettingsForced(isNewLookAndFeelDarcula);
    }

    public void updateCssSettingsForced(boolean isDarcula) {
        MarkdownCssSettings currentCssSettings = MarkdownApplicationSettings.getInstance().getMarkdownCssSettings();
        String stylesheetUri = StringUtil.isEmpty((String)currentCssSettings.getStylesheetUri()) ? MarkdownCssSettings.getDefaultCssSettings(isDarcula).getStylesheetUri() : currentCssSettings.getStylesheetUri();
        MarkdownApplicationSettings.getInstance().setMarkdownCssSettings(new MarkdownCssSettings(currentCssSettings.isUriEnabled(), stylesheetUri, currentCssSettings.isTextEnabled(), currentCssSettings.getStylesheetText()));
        this.isLastLAFWasDarcula = isDarcula;
    }

    public static boolean isDarcula(@Nullable UIManager.LookAndFeelInfo laf) {
        if (laf == null) {
            return false;
        }
        return laf.getName().contains("Darcula");
    }
}

