/*
 * Decompiled with CFR 0.152.
 */
package smetana.core.amiga;

import h.WithParent;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import smetana.core.Bucket;
import smetana.core.CFunction;
import smetana.core.CFunctionImpl;
import smetana.core.CString;
import smetana.core.HardcodedStruct;
import smetana.core.JUtils;
import smetana.core.MutableDoublePtr;
import smetana.core.OFFSET;
import smetana.core.StructureDefinition;
import smetana.core.UnsupportedC;
import smetana.core.__array_of_cstring__;
import smetana.core.__array_of_integer__;
import smetana.core.__array_of_ptr__;
import smetana.core.__array_of_struct__;
import smetana.core.__ptr__;
import smetana.core.__struct__;
import smetana.core.__struct_impl__;
import smetana.core.amiga.Area;
import smetana.core.amiga.AreaDouble;
import smetana.core.amiga.AreaInt;
import smetana.core.amiga.BucketToAreaFactory;
import smetana.core.amiga.InternalData;
import smetana.core.amiga.StarArrayOfCString;
import smetana.core.amiga.StarArrayOfInteger;
import smetana.core.amiga.StarArrayOfPtr;
import smetana.core.amiga.StarArrayOfStruct;
import smetana.core.amiga.StarStar;
import smetana.core.amiga.StarStruct;

public class StarStructImpl
extends UnsupportedC
implements StarStruct {
    public static int CPT = 0;
    private final int UID = CPT++;
    private final Map<String, Area> fields;
    private final Set<String> inlineFields = new HashSet<String>();
    private final StarStruct parent;
    private final Class theClass;

    @Override
    public boolean isSameThan(StarStruct other) {
        return this.UID == ((StarStructImpl)other).UID;
    }

    public String toString() {
        return "StarStruct " + this.getUID36() + " " + this.theClass + " " + this.fields.keySet() + " {parent=" + this.parent + "}";
    }

    @Override
    public Class getRealClass() {
        return this.theClass;
    }

    private int getIndexOf(Area searched) {
        int i = 0;
        for (Area a : this.fields.values()) {
            if (a == searched) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    private Area getAreaByIndex(int idx) {
        int i = 0;
        for (Area a : this.fields.values()) {
            if (i == idx) {
                return a;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public __struct__ getStruct() {
        return new __struct_impl__(this);
    }

    public StarStructImpl(Class theClass, StarStruct parent) {
        this.parent = parent;
        this.theClass = theClass;
        this.fields = new LinkedHashMap<String, Area>();
        JUtils.LOG("Creation Struct " + this.getUID36());
        if (this.getUID36().equals("1tq")) {
            JUtils.LOG("It's me");
        }
        StructureDefinition structureDefinition = StructureDefinition.from(theClass);
        Map<String, Bucket> bucketsMap = structureDefinition.getBucketsMap();
        JUtils.LOG("FIELDS = " + theClass + " " + bucketsMap.keySet());
        for (Map.Entry<String, Bucket> ent : bucketsMap.entrySet()) {
            Bucket bucket = ent.getValue();
            this.fields.put(bucket.name, BucketToAreaFactory.createArea(bucket, this));
            if (!bucket.inlineStruct() || bucket.functionPointer()) continue;
            this.inlineFields.add(bucket.name);
        }
    }

    @Override
    public Area getArea(String name) {
        if (!this.fields.containsKey(name)) {
            System.err.println("fields=" + this.fields.keySet());
            throw new IllegalArgumentException("No such field " + name);
        }
        Area result = this.fields.get(name);
        return result;
    }

    @Override
    public String getUID36() {
        return Integer.toString(this.UID, 36);
    }

    @Override
    public String getDebug(String fieldName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInt(String fieldName, int data) {
        AreaInt area = (AreaInt)this.getArea(fieldName);
        area.setInternal(data);
    }

    @Override
    public void setBoolean(String fieldName, boolean data) {
        AreaInt area = (AreaInt)this.getArea(fieldName);
        area.setInternal(data ? 1 : 0);
    }

    @Override
    public void setDouble(String fieldName, double data) {
        AreaDouble area = (AreaDouble)this.getArea(fieldName);
        area.setInternal(data);
    }

    @Override
    public int getInt(String fieldName) {
        AreaInt area = (AreaInt)this.getArea(fieldName);
        return area.getInternal();
    }

    @Override
    public double getDouble(String fieldName) {
        AreaDouble area = (AreaDouble)this.getArea(fieldName);
        return area.getInternal();
    }

    @Override
    public boolean getBoolean(String fieldName) {
        AreaInt area = (AreaInt)this.getArea(fieldName);
        if (area == null) {
            return false;
        }
        return area.getInternal() != 0;
    }

    @Override
    public __ptr__ plus(int pointerMove) {
        JUtils.LOG("******************* plus =" + pointerMove);
        JUtils.LOG("me=" + this);
        if (this.parent != null) {
            int idx = ((StarStructImpl)this.parent).getIndexOf(this);
            JUtils.LOG("idx=" + idx);
            Area result = ((StarStructImpl)this.parent).getAreaByIndex(idx += pointerMove);
            JUtils.LOG("result=" + result);
            return (__ptr__)((Object)result);
        }
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    @Override
    public CString getCString(String fieldName) {
        return (CString)this.getArea(fieldName);
    }

    @Override
    public __array_of_struct__ getArrayOfStruct(String fieldName) {
        Area area = this.getArea(fieldName);
        if (area instanceof StarArrayOfStruct) {
            return ((StarArrayOfStruct)area).getInternalArray();
        }
        return (__array_of_struct__)area;
    }

    @Override
    public __array_of_ptr__ getArrayOfPtr(String fieldName) {
        Area area = this.getArea(fieldName);
        if (area instanceof StarStar) {
            return (__array_of_ptr__)((StarStar)area).getArea();
        }
        if (area instanceof StarArrayOfPtr) {
            return ((StarArrayOfPtr)area).getInternalArray();
        }
        return (__array_of_ptr__)area;
    }

    @Override
    public __array_of_cstring__ getArrayOfCString(String fieldName) {
        Area area = this.getArea(fieldName);
        if (area instanceof StarArrayOfCString) {
            return ((StarArrayOfCString)area).getInternalArray();
        }
        return (__array_of_cstring__)area;
    }

    @Override
    public __array_of_integer__ getArrayOfInteger(String fieldName) {
        Area area = this.getArea(fieldName);
        if (area instanceof StarArrayOfInteger) {
            return ((StarArrayOfInteger)area).getInternalArray();
        }
        return (__array_of_integer__)area;
    }

    @Override
    public __struct__ getStruct(String fieldName) {
        if (this.getArea(fieldName) != null && !(this.getArea(fieldName) instanceof __ptr__)) {
            throw new IllegalArgumentException("Issue in getStruct with " + fieldName + " " + this.getArea(fieldName).getClass());
        }
        __ptr__ area = (__ptr__)((Object)this.getArea(fieldName));
        if (area instanceof HardcodedStruct) {
            return (__struct__)((Object)area);
        }
        if (!(area instanceof StarStructImpl)) {
            throw new IllegalStateException(fieldName + " " + area.getClass().toString());
        }
        if (area instanceof StarStructImpl && !this.inlineFields.contains(fieldName)) {
            throw new IllegalArgumentException(fieldName + " is NOT inline!");
        }
        return new __struct_impl__((StarStructImpl)area);
    }

    @Override
    public __ptr__ getPtr(String fieldName) {
        if (this.getArea(fieldName) != null && !(this.getArea(fieldName) instanceof __ptr__)) {
            throw new IllegalArgumentException("Issue in getStruct with " + fieldName + " " + this.getArea(fieldName).getClass());
        }
        __ptr__ area = (__ptr__)((Object)this.getArea(fieldName));
        if (area == null) {
            return null;
        }
        if (!(area instanceof StarStruct || area instanceof CFunctionImpl || area instanceof CString || area instanceof StarStar || area instanceof StarArrayOfPtr || area instanceof StarArrayOfStruct || area instanceof StarArrayOfInteger || area instanceof MutableDoublePtr)) {
            throw new IllegalStateException(area.getClass().toString());
        }
        if (area instanceof StarStructImpl && this.inlineFields.contains(fieldName)) {
            throw new IllegalArgumentException(fieldName + " is inline!");
        }
        return area;
    }

    @Override
    public void setStruct(String fieldName, __struct__ newData) {
        if (newData == null) {
            throw new IllegalArgumentException();
        }
        if (!this.inlineFields.contains(fieldName)) {
            throw new UnsupportedOperationException("IMPOSSIBLE2 " + fieldName);
        }
        Area area = this.fields.get(fieldName);
        if (area == null) {
            throw new UnsupportedOperationException("IMPOSSIBLE3 " + fieldName);
        }
        if (area instanceof HardcodedStruct) {
            ((HardcodedStruct)((Object)area)).copyDataFrom(newData);
        } else {
            StarStructImpl existing = (StarStructImpl)area;
            existing.copyDataFrom(newData);
        }
    }

    @Override
    public void setCString(String fieldName, CString newData) {
        if (newData == null) {
            this.fields.put(fieldName, null);
        } else {
            this.fields.put(fieldName, newData);
            newData.setMyFather(this);
        }
    }

    @Override
    public __ptr__ setPtr(String fieldName, __ptr__ newData) {
        if (newData instanceof CFunction) {
            this.fields.put(fieldName, (Area)((Object)newData));
            return newData;
        }
        if (this.inlineFields.contains(fieldName)) {
            throw new UnsupportedOperationException("IMPOSSIBLE5 " + fieldName);
        }
        if (newData == null) {
            this.fields.put(fieldName, null);
            return null;
        }
        if (newData instanceof StarStruct) {
            if (this.inlineFields.contains(fieldName)) {
                throw new UnsupportedOperationException("IMPOSSIBLE1");
            }
            this.fields.put(fieldName, (Area)((Object)newData));
            return newData;
        }
        if (newData instanceof CString) {
            this.fields.put(fieldName, (Area)((Object)newData));
            ((CString)newData).setMyFather(this);
            return newData;
        }
        if (newData instanceof StarArrayOfPtr) {
            this.fields.put(fieldName, (Area)((Object)newData));
            return newData;
        }
        if (newData instanceof StarArrayOfStruct) {
            this.fields.put(fieldName, (Area)((Object)newData));
            return newData;
        }
        if (newData instanceof StarStar) {
            this.fields.put(fieldName, (Area)((Object)newData));
            return newData;
        }
        if (newData instanceof StarArrayOfCString) {
            this.fields.put(fieldName, (Area)((Object)newData));
            return newData;
        }
        if (newData instanceof MutableDoublePtr) {
            this.fields.put(fieldName, (Area)((Object)newData));
            return newData;
        }
        if (newData instanceof StarArrayOfInteger) {
            this.fields.put(fieldName, (Area)((Object)newData));
            return newData;
        }
        throw new UnsupportedOperationException("en cours1 ! " + newData.getClass());
    }

    @Override
    public void memcopyFrom(Area source) {
        if (source instanceof StarArrayOfPtr) {
            __array_of_ptr__ array = ((StarArrayOfPtr)source).getInternalArray();
            this.copyDataFrom((StarStructImpl)array.getInternal(0));
        } else if (source instanceof __struct__) {
            this.copyDataFrom((__struct__)source);
        } else {
            this.copyDataFrom((StarStructImpl)source);
        }
    }

    @Override
    public void copyDataFrom(__struct__ other) {
        this.copyDataFrom(other.getInternalData());
    }

    @Override
    public void setStruct(__struct__ value) {
        this.copyDataFrom(value);
    }

    @Override
    public void copyDataFrom(__ptr__ arg) {
        JUtils.LOG("copyDataFrom I AM " + this);
        JUtils.LOG("other=" + arg);
        JUtils.LOG("FIELDS=" + this.fields.keySet());
        if (arg instanceof InternalData) {
            this.copyDataFromInternal((InternalData)((Object)arg));
            return;
        }
        if (this.getClass() != arg.getClass()) {
            throw new UnsupportedOperationException(this.getClass().toString());
        }
        StarStructImpl other = (StarStructImpl)arg;
        if (!this.fields.keySet().equals(other.fields.keySet())) {
            throw new IllegalStateException();
        }
        this.copyDataFromInternal(other);
    }

    private void copyDataFromInternal(InternalData other) {
        for (String fieldName : new TreeSet<String>(this.fields.keySet())) {
            Area field = this.fields.get(fieldName);
            Area otherField = other.getArea(fieldName);
            if (field == null && otherField == null) continue;
            if (field == null) {
                if (otherField instanceof StarStructImpl && !this.inlineFields.contains(fieldName)) {
                    this.fields.put(fieldName, otherField);
                    continue;
                }
                if (otherField instanceof CString) {
                    this.fields.put(fieldName, otherField);
                    continue;
                }
                if (otherField instanceof StarStar) {
                    this.fields.put(fieldName, otherField);
                    continue;
                }
                if (otherField instanceof StarArrayOfPtr) {
                    this.fields.put(fieldName, otherField);
                    continue;
                }
                if (otherField instanceof CFunction) {
                    this.fields.put(fieldName, otherField);
                    continue;
                }
                if (otherField instanceof StarArrayOfStruct) {
                    this.fields.put(fieldName, otherField);
                    continue;
                }
                System.err.println("XX otherField = " + otherField);
                throw new UnsupportedOperationException(otherField.getClass().toString());
            }
            if (field instanceof AreaInt) {
                field.memcopyFrom(otherField);
                continue;
            }
            if (field instanceof AreaDouble) {
                field.memcopyFrom(otherField);
                continue;
            }
            if (field instanceof CString) {
                field.memcopyFrom(otherField);
                continue;
            }
            if (field instanceof StarStar) {
                if (otherField == null) {
                    this.fields.put(fieldName, null);
                    continue;
                }
                field.memcopyFrom(otherField);
                continue;
            }
            if (field instanceof StarStructImpl && this.inlineFields.contains(fieldName)) {
                field.memcopyFrom(otherField);
                continue;
            }
            if (field instanceof StarStructImpl && !this.inlineFields.contains(fieldName)) {
                this.fields.put(fieldName, otherField);
                continue;
            }
            if (field instanceof StarArrayOfPtr) {
                field.memcopyFrom(otherField);
                continue;
            }
            if (field instanceof HardcodedStruct) {
                field.memcopyFrom(otherField);
                continue;
            }
            System.err.println("fieldName=" + fieldName + " " + field);
            System.err.println("otherField = " + otherField);
            throw new UnsupportedOperationException(field.getClass().toString());
        }
    }

    @Override
    public Object call(String fieldName, Object ... args) {
        CFunction area = (CFunction)((Object)this.getArea(fieldName));
        return area.exe(args);
    }

    @Override
    public __ptr__ castTo(Class dest) {
        Object first2;
        JUtils.LOG("******************* castTo =" + dest);
        JUtils.LOG("me=" + this);
        if (this.theClass == dest) {
            return this;
        }
        if (this.parent != null && ((StarStructImpl)this.parent).theClass == dest) {
            JUtils.LOG("IT's my father!");
            return this.parent;
        }
        Area first = this.fields.values().iterator().next();
        JUtils.LOG("first=" + first);
        if (first instanceof StarStructImpl) {
            first2 = (StarStructImpl)first;
            JUtils.LOG("first.parent=" + ((StarStructImpl)first2).parent);
            if (((StarStructImpl)first2).parent != this) {
                throw new IllegalStateException();
            }
            if (dest == ((StarStructImpl)first2).theClass) {
                return first2;
            }
        }
        if (first instanceof WithParent) {
            first2 = (WithParent)((Object)first);
            JUtils.LOG("first.parent=" + first2.getParent());
            if (first2.getParent() != this) {
                throw new IllegalStateException();
            }
            return (__ptr__)first2;
        }
        throw new UnsupportedOperationException("first=" + first.getClass());
    }

    @Override
    public Object addVirtualBytes(int virtualBytes) {
        JUtils.LOG("#### addVirtualBytes " + virtualBytes);
        if (virtualBytes == 0) {
            return this;
        }
        JUtils.LOG("this=" + this.toString());
        if (virtualBytes < 0) {
            OFFSET offset = OFFSET.fromInt(-virtualBytes);
            JUtils.LOG("OFFSET1=" + offset);
            if (this.parent == null) {
                throw new UnsupportedOperationException("No father! How to go back?");
            }
            JUtils.LOG("father=" + this.parent);
            if (((StarStructImpl)this.parent).theClass != offset.getTheClass()) {
                throw new UnsupportedOperationException("Bad class matching1!");
            }
            Object checking = this.parent.addVirtualBytes(-virtualBytes);
            JUtils.LOG("checking=" + checking);
            if (checking != this) {
                throw new UnsupportedOperationException("Cheking fail!");
            }
            return this.parent;
        }
        OFFSET offset = OFFSET.fromInt(virtualBytes);
        JUtils.LOG("OFFSET2=" + offset);
        String field = offset.getField();
        JUtils.LOG("field=" + field);
        JUtils.LOG("fields=" + this.fields.keySet());
        Area result = this.fields.get(field);
        if (result == null && this.parent != null) {
            return this.parent.addVirtualBytes(virtualBytes);
        }
        if (result == null) {
            throw new UnsupportedOperationException();
        }
        return result;
    }
}

