/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.graphic.HtmlColorSimple;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPattern;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.g2d.DriverLineG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;

public class DriverRectangleG2d
extends DriverShadowedG2d
implements UDriver<Graphics2D> {
    private final double dpiFactor;
    private final EnsureVisible visible;

    public DriverRectangleG2d(double dpiFactor, EnsureVisible visible) {
        this.dpiFactor = dpiFactor;
        this.visible = visible;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        HtmlColor back;
        g2d.setStroke(new BasicStroke((float)param.getStroke().getThickness()));
        URectangle shape = (URectangle)ushape;
        double rx = shape.getRx();
        double ry = shape.getRy();
        RectangularShape rect = rx == 0.0 && ry == 0.0 ? new Rectangle2D.Double(x, y, shape.getWidth(), shape.getHeight()) : new RoundRectangle2D.Double(x, y, shape.getWidth(), shape.getHeight(), rx, ry);
        this.visible.ensureVisible(x, y);
        this.visible.ensureVisible(x + shape.getWidth(), y + shape.getHeight());
        if (shape.getDeltaShadow() != 0.0) {
            this.drawShadow(g2d, rect, shape.getDeltaShadow(), this.dpiFactor);
        }
        if ((back = param.getBackcolor()) instanceof HtmlColorGradient) {
            GradientPaint paint = this.getPaintGradient(x, y, mapper, shape, back);
            g2d.setPaint(paint);
            g2d.fill(rect);
            if (param.getColor() != null && !(param.getColor() instanceof HtmlColorGradient)) {
                g2d.setColor(mapper.getMappedColor(param.getColor()));
                DriverLineG2d.manageStroke(param, g2d);
                g2d.draw(rect);
            }
        } else {
            if (param.getBackcolor() != null) {
                g2d.setColor(mapper.getMappedColor(param.getBackcolor()));
                DriverLineG2d.manageStroke(param, g2d);
                DriverRectangleG2d.managePattern(param, g2d);
                g2d.fill(rect);
            }
            if (param.getColor() != null && !param.getColor().equals(param.getBackcolor())) {
                g2d.setColor(mapper.getMappedColor(param.getColor()));
                DriverLineG2d.manageStroke(param, g2d);
                g2d.draw(rect);
            }
        }
    }

    private GradientPaint getPaintGradient(double x, double y, ColorMapper mapper, URectangle shape, HtmlColor back) {
        double width = shape.getWidth();
        double height = shape.getHeight();
        return DriverRectangleG2d.getPaintGradient(x, y, mapper, width, height, back);
    }

    public static GradientPaint getPaintGradient(double x, double y, ColorMapper mapper, double width, double height, HtmlColor back) {
        HtmlColorGradient gr = (HtmlColorGradient)back;
        char policy = gr.getPolicy();
        GradientPaint paint = policy == '|' ? new GradientPaint((float)x, (float)(y + height) / 2.0f, mapper.getMappedColor(gr.getColor1()), (float)(x + width), (float)(y + height) / 2.0f, mapper.getMappedColor(gr.getColor2())) : (policy == '\\' ? new GradientPaint((float)x, (float)(y + height), mapper.getMappedColor(gr.getColor1()), (float)(x + width), (float)y, mapper.getMappedColor(gr.getColor2())) : (policy == '-' ? new GradientPaint((float)(x + width) / 2.0f, (float)y, mapper.getMappedColor(gr.getColor1()), (float)(x + width) / 2.0f, (float)(y + height), mapper.getMappedColor(gr.getColor2())) : new GradientPaint((float)x, (float)y, mapper.getMappedColor(gr.getColor1()), (float)(x + width), (float)(y + height), mapper.getMappedColor(gr.getColor2()))));
        return paint;
    }

    public static void managePattern(UParam param, Graphics2D g2d) {
        UPattern pattern = param.getPattern();
        if (pattern == UPattern.VERTICAL_STRIPE) {
            BufferedImage bi = new BufferedImage(4, 4, 2);
            Rectangle r = new Rectangle(0, 0, 4, 4);
            int rgb = ((HtmlColorSimple)param.getBackcolor()).getColor999().getRGB();
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (i != 0 && i != 1) continue;
                    bi.setRGB(i, j, rgb);
                }
            }
            g2d.setPaint(new TexturePaint(bi, r));
        } else if (pattern == UPattern.HORIZONTAL_STRIPE) {
            BufferedImage bi = new BufferedImage(4, 4, 2);
            Rectangle r = new Rectangle(0, 0, 4, 4);
            int rgb = ((HtmlColorSimple)param.getBackcolor()).getColor999().getRGB();
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (j != 0 && j != 1) continue;
                    bi.setRGB(i, j, rgb);
                }
            }
            g2d.setPaint(new TexturePaint(bi, r));
        } else if (pattern == UPattern.SMALL_CIRCLE) {
            BufferedImage bi = new BufferedImage(4, 4, 2);
            Rectangle r = new Rectangle(0, 0, 4, 4);
            int rgb = ((HtmlColorSimple)param.getBackcolor()).getColor999().getRGB();
            bi.setRGB(0, 1, rgb);
            bi.setRGB(1, 0, rgb);
            bi.setRGB(1, 1, rgb);
            bi.setRGB(1, 2, rgb);
            bi.setRGB(2, 1, rgb);
            g2d.setPaint(new TexturePaint(bi, r));
        }
    }
}

