/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public class CommandUrl
extends SingleLineCommand<SequenceDiagram> {
    public CommandUrl() {
        super("(?i)^url[%s]*(?:of|for)?[%s]+([\\p{L}0-9_.@]+|[%g][^%g]+[%g])[%s]+(?:is)?[%s]*(" + UrlBuilder.getRegexp() + ")$");
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram diagram, List<String> arg) {
        String code = arg.get(0);
        String urlString = arg.get(1);
        Participant p = diagram.getOrCreateParticipant(code);
        UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
        Url url = urlBuilder.getUrl(urlString);
        p.setUrl(url);
        return CommandExecutionResult.ok();
    }
}

