/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.project.BasicInstantArithmetic;
import net.sourceforge.plantuml.project.Constant;
import net.sourceforge.plantuml.project.Day;
import net.sourceforge.plantuml.project.DayClose;
import net.sourceforge.plantuml.project.DayCloseOr;
import net.sourceforge.plantuml.project.DayCloseWeekDay;
import net.sourceforge.plantuml.project.Duration;
import net.sourceforge.plantuml.project.Expression;
import net.sourceforge.plantuml.project.FormalAddition;
import net.sourceforge.plantuml.project.FormalAdditionInstantDuration;
import net.sourceforge.plantuml.project.FreeVariable;
import net.sourceforge.plantuml.project.IncompleteItem;
import net.sourceforge.plantuml.project.Instant;
import net.sourceforge.plantuml.project.Item;
import net.sourceforge.plantuml.project.ItemCaract;
import net.sourceforge.plantuml.project.ItemComparator;
import net.sourceforge.plantuml.project.Jalon;
import net.sourceforge.plantuml.project.Load;
import net.sourceforge.plantuml.project.NumericNumber;
import net.sourceforge.plantuml.project.NumericType;
import net.sourceforge.plantuml.project.ParentItem;
import net.sourceforge.plantuml.project.Ressource;
import net.sourceforge.plantuml.project.WeekDay;

public class Project {
    private final Map<String, FreeVariable> variables = new TreeMap<String, FreeVariable>();
    private final Map<String, Item> items = new TreeMap<String, Item>();
    private final Map<String, Ressource> ressources = new TreeMap<String, Ressource>();
    private final DayCloseOr dayClose = new DayCloseOr();

    public final Instant getStart() {
        Instant result = null;
        for (Item it : this.getValidItems()) {
            if (result != null && result.compareTo(it.getBegin()) <= 0) continue;
            result = it.getBegin();
        }
        return result;
    }

    public final Instant getEnd() {
        Instant result = null;
        for (Item it : this.getValidItems()) {
            if (result != null && result.compareTo(it.getCompleted()) >= 0) continue;
            result = it.getCompleted();
        }
        return result;
    }

    public FreeVariable createVariable(String name, NumericType type) {
        if (this.variables.containsKey(name)) {
            throw new IllegalArgumentException("Already exist: " + name);
        }
        FreeVariable variable = new FreeVariable(name, type);
        this.variables.put(name, variable);
        return variable;
    }

    public Expression getExpression(String desc) {
        int plus = (desc = StringUtils.trin(desc)).indexOf(43);
        if (plus != -1) {
            Expression exp1 = this.getExpression(desc.substring(0, plus));
            Expression exp2 = this.getExpression(desc.substring(plus + 1));
            if (exp1.getNumericType() == NumericType.INSTANT && (exp2.getNumericType() == NumericType.DURATION || exp2.getNumericType() == NumericType.NUMBER)) {
                return new FormalAdditionInstantDuration(exp1, exp2, new BasicInstantArithmetic(this.dayClose));
            }
            if (exp2.getNumericType() == NumericType.INSTANT && (exp1.getNumericType() == NumericType.DURATION || exp1.getNumericType() == NumericType.NUMBER)) {
                return new FormalAdditionInstantDuration(exp2, exp1, new BasicInstantArithmetic(this.dayClose));
            }
            return new FormalAddition(exp1, exp2);
        }
        if (desc.matches("^\\d+$")) {
            return new Constant(new NumericNumber(Integer.parseInt(desc)));
        }
        if (desc.matches("^\\$\\w+$")) {
            String varName = desc.substring(1);
            FreeVariable v = this.variables.get(varName);
            if (v != null) {
                return v;
            }
            throw new IllegalArgumentException("No such variable: " + desc);
        }
        if (Day.isValidDesc(desc)) {
            Day d = new Day(desc);
            return new Constant(new Instant(d));
        }
        if (desc.matches("^[\\w/]+\\$(begin|completed|work|load|duration)$")) {
            int idx = desc.indexOf(36);
            String varName = desc.substring(0, idx);
            Item item2 = this.items.get(varName);
            if (item2 == null) {
                throw new IllegalArgumentException("No such variable: " + desc);
            }
            return new Constant(ItemCaract.valueOf(StringUtils.goUpperCase(desc.substring(idx + 1))).getData(item2));
        }
        if (desc.startsWith("^")) {
            Item item3 = this.items.get(desc.substring(1));
            if (item3 == null) {
                throw new IllegalArgumentException("No such variable: " + desc);
            }
            return new Constant(item3.getBegin());
        }
        throw new IllegalArgumentException("cannot parse");
    }

    public boolean affectation(String destination, Expression expression) {
        if (destination.startsWith("^")) {
            return this.affectationJalon(destination, expression);
        }
        if (destination.startsWith("~")) {
            return this.affectationRessource(destination, expression);
        }
        int idx = destination.indexOf(36);
        if (idx == -1) {
            return this.affectationVariable(destination, expression);
        }
        String itemName = destination.substring(0, idx);
        Item item2 = this.getItem(itemName);
        if (!(item2 instanceof IncompleteItem)) {
            return false;
        }
        IncompleteItem incompleteItem = (IncompleteItem)item2;
        String suf = destination.substring(idx + 1);
        if (suf.equalsIgnoreCase("begin")) {
            incompleteItem.setData(ItemCaract.BEGIN, expression.getValue());
        } else if (suf.equalsIgnoreCase("completed")) {
            incompleteItem.setData(ItemCaract.COMPLETED, expression.getValue());
        } else if (suf.equalsIgnoreCase("work")) {
            incompleteItem.setData(ItemCaract.WORK, expression.getValue());
        } else if (suf.equalsIgnoreCase("duration")) {
            if (expression.getNumericType() == NumericType.NUMBER) {
                expression = new Constant(new Duration((NumericNumber)expression.getValue()));
            }
            incompleteItem.setData(ItemCaract.DURATION, expression.getValue());
        } else if (suf.equalsIgnoreCase("LOAD")) {
            if (expression.getNumericType() == NumericType.NUMBER) {
                expression = new Constant(new Load((NumericNumber)expression.getValue()));
            }
            incompleteItem.setData(ItemCaract.LOAD, expression.getValue());
        } else {
            return false;
        }
        return true;
    }

    private boolean affectationRessource(String res, Expression expression) {
        int idx;
        String suf = (res = res.substring(1)).substring((idx = res.indexOf(36)) + 1);
        if (suf.equals("capacity")) {
            Ressource ressource = this.getRessource(res.substring(0, idx));
            ressource.setCapacity(((NumericNumber)expression.getValue()).getIntValue());
            return true;
        }
        return false;
    }

    private Ressource getRessource(String code) {
        Ressource result = this.ressources.get(code);
        if (result == null) {
            result = new Ressource(code);
            this.ressources.put(code, result);
        }
        return result;
    }

    private boolean affectationJalon(String jalon, Expression expression) {
        Jalon it = this.getItemJalon(jalon.substring(1));
        it.setInstant(expression.getValue());
        return true;
    }

    private Jalon getItemJalon(String jalon) {
        Jalon result = (Jalon)this.items.get(jalon);
        if (result == null) {
            result = new Jalon(jalon, null);
            this.items.put(jalon, result);
        }
        return result;
    }

    private Item getItem(String code) {
        Item result = this.items.get(code);
        if (result == null) {
            int idx = code.indexOf(47);
            if (idx == -1) {
                result = new IncompleteItem(code, null, new BasicInstantArithmetic(this.dayClose));
            } else {
                ParentItem parent = this.getItemParent(code.substring(0, idx));
                result = new IncompleteItem(code, parent, new BasicInstantArithmetic(this.dayClose));
                parent.addChild(result);
            }
            this.items.put(code, result);
        }
        return result;
    }

    private ParentItem getItemParent(String code) {
        Item result = this.items.get(code);
        if (result == null) {
            int idx = code.indexOf(47);
            if (idx == -1) {
                result = new ParentItem(code, null);
                this.items.put(code, result);
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return (ParentItem)result;
    }

    private boolean affectationVariable(String destination, Expression expression) {
        if (!this.variables.containsKey(destination)) {
            return false;
        }
        this.variables.get(destination).setValue(expression);
        return true;
    }

    public List<Item> getValidItems() {
        ArrayList<Item> result = new ArrayList<Item>();
        for (Item item2 : this.items.values()) {
            if (!item2.isValid()) continue;
            result.add(item2);
        }
        Collections.sort(result, new ItemComparator());
        return Collections.unmodifiableList(result);
    }

    public final DayClose getDayClose() {
        return this.dayClose;
    }

    public void closeWeekDay(WeekDay weekDay) {
        this.dayClose.add(new DayCloseWeekDay(weekDay));
    }
}

