/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineList;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.ReadLineSimple;
import net.sourceforge.plantuml.preproc.StartDiagramExtractReader;
import net.sourceforge.plantuml.utils.StartUtils;

public class PreprocessorInclude
implements ReadLine {
    private static final Pattern2 includeDefPattern = MyPattern.cmpile("^[%s]*!includedef[%s]+[%g]?([^%g]+)[%g]?$");
    private static final Pattern2 includePattern = MyPattern.cmpile("^[%s]*!include[%s]+[%g]?([^%g]+)[%g]?$");
    private static final Pattern2 includeManyPattern = MyPattern.cmpile("^[%s]*!include_many[%s]+[%g]?([^%g]+)[%g]?$");
    private static final Pattern2 includeURLPattern = MyPattern.cmpile("^[%s]*!includeurl[%s]+[%g]?([^%g]+)[%g]?$");
    private final ReadLine reader2;
    private final String charset;
    private final Defines defines;
    private final DefinitionsContainer definitionsContainer;
    private int numLine = 0;
    private PreprocessorInclude included = null;
    private final File oldCurrentDir;
    private final Set<FileWithSuffix> filesUsedCurrent;
    private final Set<FileWithSuffix> filesUsedGlobal;

    public PreprocessorInclude(ReadLine reader, Defines defines, String charset, File newCurrentDir, DefinitionsContainer definitionsContainer) {
        this(reader, defines, charset, newCurrentDir, new HashSet<FileWithSuffix>(), new HashSet<FileWithSuffix>(), definitionsContainer);
    }

    public Set<FileWithSuffix> getFilesUsedGlobal() {
        return Collections.unmodifiableSet(this.filesUsedGlobal);
    }

    private PreprocessorInclude(ReadLine reader, Defines defines, String charset, File newCurrentDir, Set<FileWithSuffix> filesUsedCurrent, Set<FileWithSuffix> filesUsedGlobal, DefinitionsContainer definitionsContainer) {
        this.defines = defines;
        this.charset = charset;
        this.reader2 = reader;
        this.definitionsContainer = definitionsContainer;
        this.filesUsedCurrent = filesUsedCurrent;
        this.filesUsedGlobal = filesUsedGlobal;
        if (newCurrentDir == null) {
            this.oldCurrentDir = null;
        } else {
            this.oldCurrentDir = FileSystem.getInstance().getCurrentDir();
            FileSystem.getInstance().setCurrentDir(newCurrentDir);
        }
    }

    private void restoreCurrentDir() {
        if (this.oldCurrentDir != null) {
            FileSystem.getInstance().setCurrentDir(this.oldCurrentDir);
        }
    }

    @Override
    public CharSequence2 readLine() throws IOException {
        CharSequence2 result = this.readLineInternal();
        if (result != null && (StartUtils.isArobaseEndDiagram(result) || StartUtils.isArobaseStartDiagram(result))) {
            this.filesUsedCurrent.clear();
        }
        return result;
    }

    private CharSequence2 readLineInternal() throws IOException {
        CharSequence2 s;
        if (this.included != null) {
            s = this.included.readLine();
            if (s != null) {
                return s;
            }
            this.included.close();
            this.included = null;
        }
        s = this.reader2.readLine();
        ++this.numLine;
        if (s == null) {
            return null;
        }
        if (OptionFlags.ALLOW_INCLUDE) {
            assert (this.included == null);
            Matcher2 m1 = includePattern.matcher(s);
            if (m1.find()) {
                return this.manageFileInclude(s, m1, false);
            }
            Matcher2 m2 = includeManyPattern.matcher(s);
            if (m2.find()) {
                return this.manageFileInclude(s, m2, true);
            }
            Matcher2 m3 = includeDefPattern.matcher(s);
            if (m3.find()) {
                return this.manageDefinitionInclude(s, m3);
            }
        }
        Matcher2 mUrl = includeURLPattern.matcher(s);
        if (s.getPreprocessorError() == null && mUrl.find()) {
            return this.manageUrlInclude(s, mUrl);
        }
        return s;
    }

    private CharSequence2 manageUrlInclude(CharSequence2 s, Matcher2 m) throws IOException {
        String urlString = m.group(1);
        urlString = this.defines.applyDefines(urlString).get(0);
        int idx = urlString.lastIndexOf(33);
        String suf = null;
        if (idx != -1) {
            suf = urlString.substring(idx + 1);
            urlString = urlString.substring(0, idx);
        }
        try {
            URL url = new URL(urlString);
            this.included = new PreprocessorInclude(this.getReaderInclude(s, url, suf), this.defines, this.charset, null, this.filesUsedCurrent, this.filesUsedGlobal, this.definitionsContainer);
        }
        catch (MalformedURLException e) {
            return s.withErrorPreprocessor("Cannot include url " + urlString);
        }
        return this.readLine();
    }

    private CharSequence2 manageDefinitionInclude(CharSequence2 s, Matcher2 matcher) throws IOException {
        String definitionName = matcher.group(1);
        List<? extends CharSequence> definition = this.definitionsContainer.getDefinition(definitionName);
        this.included = new PreprocessorInclude(new ReadLineList(definition, s.getLocation()), this.defines, this.charset, null, this.filesUsedCurrent, this.filesUsedGlobal, this.definitionsContainer);
        return this.readLine();
    }

    private CharSequence2 manageFileInclude(CharSequence2 s, Matcher2 matcher, boolean allowMany) throws IOException {
        String fileName = matcher.group(1);
        if ((fileName = this.defines.applyDefines(fileName).get(0)).startsWith("<") && fileName.endsWith(">")) {
            ReadLine strlibReader = this.getReaderStdlibInclude(s, fileName.substring(1, fileName.length() - 1));
            if (strlibReader == null) {
                return s.withErrorPreprocessor("Cannot include " + fileName);
            }
            this.included = new PreprocessorInclude(strlibReader, this.defines, this.charset, null, this.filesUsedCurrent, this.filesUsedGlobal, this.definitionsContainer);
            return this.readLine();
        }
        int idx = fileName.lastIndexOf(33);
        String suf = null;
        if (idx != -1) {
            suf = fileName.substring(idx + 1);
            fileName = fileName.substring(0, idx);
        }
        File f = FileSystem.getInstance().getFile(PreprocessorInclude.withEnvironmentVariable(fileName));
        FileWithSuffix f2 = new FileWithSuffix(f, suf);
        if (!f.exists() || f.isDirectory()) {
            return s.withErrorPreprocessor("Cannot include " + f.getAbsolutePath());
        }
        if (!allowMany && this.filesUsedCurrent.contains(f2)) {
            return this.readLine();
        }
        this.filesUsedCurrent.add(f2);
        this.filesUsedGlobal.add(f2);
        this.included = new PreprocessorInclude(this.getReaderInclude(s, f, suf), this.defines, this.charset, f.getParentFile(), this.filesUsedCurrent, this.filesUsedGlobal, this.definitionsContainer);
        return this.readLine();
    }

    static String withEnvironmentVariable(String s) {
        Pattern p = Pattern.compile("%(\\w+)%");
        Matcher m = p.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String var = m.group(1);
            String value = PreprocessorInclude.getenv(var);
            if (value == null) continue;
            m.appendReplacement(sb, Matcher.quoteReplacement(value));
        }
        m.appendTail(sb);
        s = sb.toString();
        return s;
    }

    public static String getenv(String var) {
        String env = System.getProperty(var);
        if (StringUtils.isNotEmpty(env)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(env);
        }
        String getenv = System.getenv(var);
        if (StringUtils.isNotEmpty(getenv)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(getenv);
        }
        return null;
    }

    private InputStream getStdlibInputStream(String filename) {
        InputStream is;
        if (!filename.endsWith(".puml")) {
            filename = filename + ".puml";
        }
        if ((is = PreprocessorInclude.class.getResourceAsStream("/stdlib/" + filename)) == null) {
            is = PreprocessorInclude.class.getResourceAsStream("/stdlib/" + filename.toLowerCase());
        }
        return is;
    }

    private ReadLine getReaderStdlibInclude(CharSequence2 s, String filename) {
        InputStream is = this.getStdlibInputStream(filename);
        if (is == null) {
            return null;
        }
        try {
            if (StartDiagramExtractReader.containsStartDiagram(s, is)) {
                is = this.getStdlibInputStream(filename);
                return new StartDiagramExtractReader(s, is);
            }
            is = this.getStdlibInputStream(filename);
            if (is == null) {
                return null;
            }
            return new ReadLineReader(new InputStreamReader(is), filename);
        }
        catch (IOException e) {
            return new ReadLineSimple(s, e.toString());
        }
    }

    private ReadLine getReaderInclude(CharSequence2 s, File f, String suf) {
        try {
            if (StartDiagramExtractReader.containsStartDiagram(s, f, this.charset)) {
                return new StartDiagramExtractReader(s, f, suf, this.charset);
            }
            if (this.charset == null) {
                Log.info("Using default charset");
                return new ReadLineReader(new FileReader(f), f.getAbsolutePath(), s.getLocation());
            }
            Log.info("Using charset " + this.charset);
            return new ReadLineReader(new InputStreamReader((InputStream)new FileInputStream(f), this.charset), f.getAbsolutePath(), s.getLocation());
        }
        catch (IOException e) {
            return new ReadLineSimple(s, e.toString());
        }
    }

    private ReadLine getReaderInclude(CharSequence2 s, URL url, String suf) {
        try {
            if (StartDiagramExtractReader.containsStartDiagram(s, url, this.charset)) {
                return new StartDiagramExtractReader(s, url, suf, this.charset);
            }
            InputStream is = url.openStream();
            if (this.charset == null) {
                Log.info("Using default charset");
                return new ReadLineReader(new InputStreamReader(is), url.toString(), s.getLocation());
            }
            Log.info("Using charset " + this.charset);
            return new ReadLineReader(new InputStreamReader(is, this.charset), url.toString(), s.getLocation());
        }
        catch (IOException e) {
            return new ReadLineSimple(s, e.toString());
        }
    }

    public int getLineNumber() {
        return this.numLine;
    }

    @Override
    public void close() throws IOException {
        this.restoreCurrentDir();
        this.reader2.close();
    }
}

