/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.hector.Box2D;
import net.sourceforge.plantuml.hector.Pin;
import net.sourceforge.plantuml.hector.PinFactory;
import net.sourceforge.plantuml.hector.PinLink;
import net.sourceforge.plantuml.hector.Skeleton;
import net.sourceforge.plantuml.hector.SkeletonBuilder;
import net.sourceforge.plantuml.hector.SkeletonConfiguration;
import net.sourceforge.plantuml.hector.SkeletonConfigurationUtils;
import net.sourceforge.plantuml.hector.SmartConnection;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.DotDataImageBuilder;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CucaDiagramFileMakerHectorB1
implements CucaDiagramFileMaker {
    private final CucaDiagram diagram;
    private SkeletonConfiguration configuration;
    private double nodeMargin = 40.0;
    private final Map<Link, PinLink> links = new LinkedHashMap<Link, PinLink>();

    public CucaDiagramFileMakerHectorB1(CucaDiagram diagram) {
        this.diagram = diagram;
    }

    private double getX(Pin pin) {
        return this.nodeMargin * (double)this.configuration.getCol(pin);
    }

    private double getY(Pin pin) {
        return this.nodeMargin * (double)pin.getRow();
    }

    @Override
    public ImageData createFile(OutputStream os, List<String> dotStrings, FileFormatOption fileFormatOption) throws IOException {
        PinFactory pinFactory = new PinFactory();
        SkeletonBuilder skeletonBuilder = new SkeletonBuilder();
        this.links.clear();
        for (Link link : this.diagram.getLinks()) {
            PinLink pinLink = pinFactory.createPinLink(link);
            this.links.put(link, pinLink);
            skeletonBuilder.add(pinLink);
        }
        Skeleton skeleton = skeletonBuilder.createSkeletons().get(0);
        this.configuration = SkeletonConfigurationUtils.getBest(skeleton);
        MinMax minMax = MinMax.getEmpty(false);
        for (Pin pin : skeleton.getPins()) {
            minMax = minMax.addPoint(this.getX(pin), this.getY(pin));
        }
        double borderMargin = 10.0;
        Dimension2DDouble dimTotal = new Dimension2DDouble(20.0 + minMax.getMaxX(), 20.0 + minMax.getMaxY());
        UGraphic ug = null;
        ug = (UGraphic2)ug.apply(new UTranslate(10.0, 10.0));
        for (PinLink pinLink : skeleton.getPinLinks()) {
            this.drawPinLink(ug, pinLink);
        }
        for (Pin pin : skeleton.getPins()) {
            this.drawPin(ug, pin);
        }
        throw new UnsupportedOperationException();
    }

    private void drawPin(UGraphic ug, Pin pin) {
        double x = this.getX(pin);
        double y = this.getY(pin);
        UEllipse circle = new UEllipse(6.0, 6.0);
        ug.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(new UChangeBackColor(HtmlColorUtils.BLACK)).apply(new UTranslate(x - 3.0, y - 3.0)).draw(circle);
    }

    private void drawPinLink(UGraphic ug, PinLink pinLink) {
        double x1 = this.getX(pinLink.getPin1());
        double y1 = this.getY(pinLink.getPin1());
        double x2 = this.getX(pinLink.getPin2());
        double y2 = this.getY(pinLink.getPin2());
        Rose rose = new Rose();
        HtmlColor color = rose.getHtmlColor(this.diagram.getSkinParam(), ColorParam.arrow);
        ArrayList<Box2D> b = new ArrayList<Box2D>();
        SmartConnection connection = new SmartConnection(x1, y1, x2, y2, b);
        connection.draw(ug, color);
    }

    private IEntityImage computeImage(ILeaf leaf) {
        IEntityImage image = DotDataImageBuilder.createEntityImageBlock(leaf, this.diagram.getSkinParam(), false, this.diagram, null, null, null, this.diagram.getLinks());
        return image;
    }
}

