/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorAndStyle;

public class Rainbow {
    private final List<HtmlColorAndStyle> colors = new ArrayList<HtmlColorAndStyle>();
    private final int colorArrowSeparationSpace;

    private Rainbow(int colorArrowSeparationSpace) {
        this.colorArrowSeparationSpace = colorArrowSeparationSpace;
    }

    public String toString() {
        return this.colors.toString();
    }

    public static Rainbow none() {
        return new Rainbow(0);
    }

    public Rainbow withDefault(Rainbow defaultColor) {
        if (this.size() == 0) {
            return defaultColor;
        }
        return this;
    }

    public static Rainbow build(HtmlColorAndStyle color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        Rainbow result = new Rainbow(0);
        result.colors.add(color);
        return result;
    }

    public static Rainbow build(ISkinParam skinParam, String colorString, int colorArrowSeparationSpace) {
        if (colorString == null) {
            return Rainbow.none();
        }
        Rainbow result = new Rainbow(colorArrowSeparationSpace);
        for (String s : colorString.split(";")) {
            result.colors.add(HtmlColorAndStyle.build(skinParam, s));
        }
        return result;
    }

    public List<HtmlColorAndStyle> getColors() {
        return Collections.unmodifiableList(this.colors);
    }

    public HtmlColor getColor() {
        return this.colors.get(0).getColor();
    }

    public int getColorArrowSeparationSpace() {
        return this.colorArrowSeparationSpace;
    }

    public int size() {
        return this.colors.size();
    }
}

