/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom.kinetic;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.geom.kinetic.Frame;
import net.sourceforge.plantuml.geom.kinetic.MoveObserver;
import net.sourceforge.plantuml.geom.kinetic.Path;
import net.sourceforge.plantuml.geom.kinetic.Point2DCharge;
import net.sourceforge.plantuml.geom.kinetic.Quadrant;
import net.sourceforge.plantuml.geom.kinetic.QuadrantMapper;
import net.sourceforge.plantuml.geom.kinetic.VectorForce;

public class World
implements MoveObserver {
    private final List<Path> paths = new ArrayList<Path>();
    private final Map<Point2DCharge, Path> pathOfPoints = new HashMap<Point2DCharge, Path>();
    private final List<Frame> frames = new ArrayList<Frame>();
    private QuadrantMapper quadrantMapper;

    public void addFrame(Frame frame) {
        this.frames.add(frame);
    }

    public void addPath(Path path2) {
        this.paths.add(path2);
    }

    public VectorForce getElectricForce(Point2DCharge point2) {
        VectorForce result = new VectorForce(0.0, 0.0);
        Quadrant quadrant = new Quadrant(point2);
        for (Quadrant q : quadrant.neighbourhood()) {
            for (Point2DCharge pc2 : this.quadrantMapper.getAllPoints(q)) {
                Path path2 = this.pathOfPoints.get(pc2);
                if (path2.containsPoint2DCharge(point2)) continue;
                result = result.plus(World.getElectricForce(point2, pc2));
            }
        }
        return result;
    }

    private VectorForce getElectricForceSlow(Point2DCharge point2) {
        VectorForce result = new VectorForce(0.0, 0.0);
        for (Path path2 : this.paths) {
            if (path2.containsPoint2DCharge(point2)) continue;
            for (Point2DCharge pc2 : path2.getPoints()) {
                result = result.plus(World.getElectricForce(point2, pc2));
            }
        }
        return result;
    }

    private static VectorForce getElectricForce(Point2DCharge onThis, Point2DCharge byThis) {
        double dist = onThis.distance(byThis);
        if (dist == 0.0) {
            return new VectorForce(0.0, 0.0);
        }
        VectorForce result = new VectorForce(byThis.getX() - onThis.getX(), byThis.getY() - onThis.getY());
        double v = 100.0 * onThis.getCharge() * byThis.getCharge() / dist / dist;
        return result.normaliseTo(v);
    }

    private static VectorForce getAtomicForce(Point2DCharge onThis, Point2DCharge byThis) {
        double dist = onThis.distance(byThis);
        if (dist == 0.0) {
            return new VectorForce(0.0, 0.0);
        }
        VectorForce result = new VectorForce(byThis.getX() - onThis.getX(), byThis.getY() - onThis.getY());
        double v = 1000.0 / dist / dist / dist;
        if (v > 5.0) {
            v = 5.0;
        }
        return result.normaliseTo(v);
    }

    Map<Point2DCharge, VectorForce> getForces() {
        LinkedHashMap<Point2DCharge, VectorForce> result = new LinkedHashMap<Point2DCharge, VectorForce>();
        for (Path path2 : this.paths) {
            for (Point2DCharge pt : path2.getPoints()) {
                VectorForce elastic = path2.getElasticForce(pt);
                VectorForce elect = this.getElectricForce(pt);
                VectorForce force = elastic.plus(elect);
                for (Frame f : this.frames) {
                    Point2D inter = f.getFrontierPointViewBy(pt);
                    if (inter == null) continue;
                    Point2DCharge pchar = new Point2DCharge(inter, 1.0);
                    force = force.plus(World.getAtomicForce(pt, pchar));
                }
                result.put(pt, force);
            }
        }
        return result;
    }

    public double onePass() {
        double result = 0.0;
        Map<Point2DCharge, VectorForce> forces = this.getForces();
        for (Map.Entry<Point2DCharge, VectorForce> ent : forces.entrySet()) {
            VectorForce force = ent.getValue();
            result += force.getLength();
            ent.getKey().apply(force);
        }
        return result;
    }

    public final Collection<Path> getPaths() {
        return Collections.unmodifiableCollection(this.paths);
    }

    public void renderContinue() {
        this.quadrantMapper = new QuadrantMapper();
        this.pathOfPoints.clear();
        for (Path path2 : this.paths) {
            path2.renderContinue();
        }
        for (Path path2 : this.paths) {
            for (Point2DCharge pt : path2.getPoints()) {
                pt.setMoveObserver(this);
                this.quadrantMapper.addPoint(pt);
                this.pathOfPoints.put(pt, path2);
            }
        }
    }

    @Override
    public void pointMoved(Point2DCharge point2) {
        this.quadrantMapper.updatePoint(point2);
    }
}

