/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.creole.AtomText;
import net.sourceforge.plantuml.creole.Stripe;
import net.sourceforge.plantuml.graphic.StringBounder;

public class Fission {
    private final Stripe stripe;
    private final LineBreakStrategy maxWidth;

    public Fission(Stripe stripe, LineBreakStrategy maxWidth) {
        this.stripe = stripe;
        this.maxWidth = maxWidth;
        if (maxWidth == null) {
            throw new IllegalArgumentException();
        }
    }

    public List<Stripe> getSplitted(StringBounder stringBounder) {
        double valueMaxWidth = this.maxWidth.getMathWidth();
        if (valueMaxWidth == 0.0) {
            return Arrays.asList(this.stripe);
        }
        ArrayList<StripeSimple> result = new ArrayList<StripeSimple>();
        StripeSimple current = new StripeSimple();
        for (Atom atom : this.stripe.getAtoms()) {
            for (Atom atom2 : this.getSplitted(stringBounder, atom)) {
                double width = atom2.calculateDimension(stringBounder).getWidth();
                if (current.totalWidth + width > valueMaxWidth) {
                    result.add(current);
                    current = new StripeSimple();
                }
                current.addAtom(atom2, width);
            }
        }
        if (current.totalWidth > 0.0) {
            result.add(current);
        }
        return Collections.unmodifiableList(result);
    }

    private Collection<? extends Atom> getSplitted(StringBounder stringBounder, Atom atom) {
        if (atom instanceof AtomText) {
            return ((AtomText)atom).getSplitted(stringBounder, this.maxWidth);
        }
        return Collections.singleton(atom);
    }

    private List<Stripe> getSplittedSimple() {
        StripeSimple result = new StripeSimple();
        for (Atom atom : this.stripe.getAtoms()) {
            result.addAtom(atom, 0.0);
        }
        return Arrays.asList(result);
    }

    static class StripeSimple
    implements Stripe {
        private final List<Atom> atoms = new ArrayList<Atom>();
        private double totalWidth;

        StripeSimple() {
        }

        @Override
        public List<Atom> getAtoms() {
            return Collections.unmodifiableList(this.atoms);
        }

        private void addAtom(Atom atom, double width) {
            this.atoms.add(atom);
            this.totalWidth += width;
        }
    }
}

