/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.PanelGridBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.NumberFormatter;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiTaskExecutor;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountInformationProvider;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;
import org.jetbrains.plugins.github.authentication.ui.GithubAccountsPanel;
import org.jetbrains.plugins.github.ui.GithubSettingsConfigurable;
import org.jetbrains.plugins.github.ui.GithubSettingsPanel$sam$java_util_function_BiConsumer$0;
import org.jetbrains.plugins.github.util.GithubSettings;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u00012\u00020\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0002R\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0014\u0010\u0018\u001a\u00020\u00192\n\u0010\u0014\u001a\u00060\u0002R\u00020\u0003H\u0016J\u0014\u0010\u001a\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0002R\u00020\u0003H\u0016J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001dH\u0002J\u0014\u0010\u001e\u001a\u00020\u0013*\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001cH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/github/ui/GithubSettingsPanel;", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lorg/jetbrains/plugins/github/ui/GithubSettingsConfigurable$GithubSettingsHolder;", "Lorg/jetbrains/plugins/github/ui/GithubSettingsConfigurable;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "apiTaskExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiTaskExecutor;", "accountInformationProvider", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountInformationProvider;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GithubApiTaskExecutor;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountInformationProvider;)V", "accountsPanel", "Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel;", "cloneUsingSshCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "timeoutField", "Ljavax/swing/JFormattedTextField;", "apply", "", "settings", "dispose", "getComponent", "Ljavax/swing/JComponent;", "isModified", "", "reset", "getConnectionTimeoutSeconds", "", "Lorg/jetbrains/plugins/github/util/GithubSettings;", "setConnectionTimeoutSeconds", "timeout", "intellij.vcs.github"})
public final class GithubSettingsPanel
implements ConfigurableUi<GithubSettingsConfigurable.GithubSettingsHolder>,
Disposable {
    private final GithubAccountsPanel accountsPanel;
    private final JFormattedTextField timeoutField;
    private final JBCheckBox cloneUsingSshCheckBox;

    public void reset(@NotNull GithubSettingsConfigurable.GithubSettingsHolder settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        this.accountsPanel.setAccounts(settings.getApplicationAccounts().getAccounts(), settings.getProjectAccount().getAccount());
        this.accountsPanel.clearNewTokens();
        this.accountsPanel.loadExistingAccountsDetails();
        this.timeoutField.setValue(this.getConnectionTimeoutSeconds(settings.getApplication()));
        this.cloneUsingSshCheckBox.setSelected(settings.getApplication().isCloneGitUsingSsh());
    }

    public boolean isModified(@NotNull GithubSettingsConfigurable.GithubSettingsHolder settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        return Intrinsics.areEqual((Object)this.timeoutField.getValue(), (Object)this.getConnectionTimeoutSeconds(settings.getApplication())) ^ true || this.cloneUsingSshCheckBox.isSelected() != settings.getApplication().isCloneGitUsingSsh() || this.accountsPanel.isModified(settings.getApplicationAccounts().getAccounts(), settings.getProjectAccount().getAccount());
    }

    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull GithubSettingsConfigurable.GithubSettingsHolder settings) {
        void accountsTokenMap;
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Function2 function2 = this.accountsPanel.getAccounts();
        Map map = (Map)function2.component1();
        GithubAccount defaultAccount = (GithubAccount)function2.component2();
        settings.getApplicationAccounts().setAccounts(accountsTokenMap.keySet());
        void $receiver$iv = accountsTokenMap;
        LinkedHashMap result$iv = new LinkedHashMap();
        void var6_6 = $receiver$iv;
        for (Map.Entry entry$iv : var6_6.entrySet()) {
            String it = (String)entry$iv.getValue();
            if (!(it != null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        function2 = (Function2)new Function2<GithubAccount, String, Unit>(settings.getApplicationAccounts()){

            public final void invoke(@NotNull GithubAccount p1, @Nullable String p2) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                ((GithubAccountManager)this.receiver).updateAccountToken(p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(GithubAccountManager.class);
            }

            public final String getName() {
                return "updateAccountToken";
            }

            public final String getSignature() {
                return "updateAccountToken(Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;Ljava/lang/String;)V";
            }
        };
        ((Map)result$iv).forEach(new GithubSettingsPanel$sam$java_util_function_BiConsumer$0(function2));
        settings.getProjectAccount().setAccount(defaultAccount);
        this.accountsPanel.clearNewTokens();
        Object object = this.timeoutField.getValue();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.setConnectionTimeoutSeconds(settings.getApplication(), (Integer)object);
        settings.getApplication().setCloneGitUsingSsh(this.cloneUsingSshCheckBox.isSelected());
    }

    private final int getConnectionTimeoutSeconds(@NotNull GithubSettings $receiver) {
        return $receiver.getConnectionTimeout() / 1000;
    }

    private final void setConnectionTimeoutSeconds(@NotNull GithubSettings $receiver, int timeout) {
        $receiver.setConnectionTimeout(timeout * 1000);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel;
        JPanel $receiver = jPanel = new JPanel();
        $receiver.setLayout(new BoxLayout($receiver, 0));
        $receiver.add(new JLabel("Connection timeout:"));
        $receiver.add(Box.createRigidArea((Dimension)new JBDimension(10, 0)));
        $receiver.add(this.timeoutField);
        $receiver.add(Box.createRigidArea((Dimension)new JBDimension(10, 0)));
        $receiver.add(new JLabel("seconds"));
        $receiver.setAlignmentX(0.0f);
        JPanel timeoutPanel = jPanel;
        Object object = this.cloneUsingSshCheckBox;
        PanelGridBuilder panelGridBuilder = UI.PanelFactory.grid();
        JBCheckBox $receiver2 = object;
        $receiver2.setAlignmentX(0.0f);
        JBCheckBox jBCheckBox = object;
        $receiver2 = object = panelGridBuilder.add((PanelBuilder)UI.PanelFactory.panel((JComponent)((JComponent)jBCheckBox))).add((PanelBuilder)UI.PanelFactory.panel((JComponent)timeoutPanel).resizeX(false)).createPanel();
        $receiver2.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        Object object2 = object;
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"grid()\n      .add(panel(\u2026til.DEFAULT_HGAP)\n      }");
        Object settingsPanel = object2;
        $receiver2 = object = new JPanel();
        $receiver2.setLayout(new GridLayout(2, 1));
        $receiver2.add((Component)((Object)this.accountsPanel));
        $receiver2.add((Component)settingsPanel);
        return (JComponent)object;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.accountsPanel);
    }

    public GithubSettingsPanel(@NotNull Project project, @NotNull GithubApiTaskExecutor apiTaskExecutor, @NotNull GithubAccountInformationProvider accountInformationProvider) {
        JFormattedTextField jFormattedTextField;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)apiTaskExecutor, (String)"apiTaskExecutor");
        Intrinsics.checkParameterIsNotNull((Object)accountInformationProvider, (String)"accountInformationProvider");
        this.accountsPanel = new GithubAccountsPanel(project, apiTaskExecutor, accountInformationProvider);
        Serializable serializable = new NumberFormatter(NumberFormat.getIntegerInstance());
        JFormattedTextField jFormattedTextField2 = jFormattedTextField;
        Serializable serializable2 = jFormattedTextField;
        GithubSettingsPanel githubSettingsPanel = this;
        NumberFormatter $receiver = serializable;
        $receiver.setMinimum(Integer.valueOf(0));
        $receiver.setMaximum(Integer.valueOf(60));
        NumberFormatter numberFormatter = serializable;
        jFormattedTextField2(numberFormatter);
        $receiver = serializable = serializable2;
        ((JTextField)((Object)$receiver)).setColumns(2);
        UIUtil.fixFormattedField((JFormattedTextField)((Object)$receiver));
        githubSettingsPanel.timeoutField = serializable2 = serializable;
        this.cloneUsingSshCheckBox = new JBCheckBox("Clone git repositories using ssh");
    }
}

