/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.DialogManager;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubCreatePullRequestWorker;
import org.jetbrains.plugins.github.LegacySingleAccountActionGroup;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.ui.GithubCreatePullRequestDialog;

public class GithubCreatePullRequestAction
extends LegacySingleAccountActionGroup {
    public GithubCreatePullRequestAction() {
        super("Create Pull Request", "Create pull request from current branch", AllIcons.Vcs.Vendors.Github);
    }

    @Override
    public void actionPerformed(@NotNull Project project, @Nullable VirtualFile file, @NotNull GitRepository gitRepository, @NotNull GithubAccount account) {
        if (project == null) {
            GithubCreatePullRequestAction.$$$reportNull$$$0(0);
        }
        if (gitRepository == null) {
            GithubCreatePullRequestAction.$$$reportNull$$$0(1);
        }
        if (account == null) {
            GithubCreatePullRequestAction.$$$reportNull$$$0(2);
        }
        GithubCreatePullRequestAction.createPullRequest(project, gitRepository, account);
    }

    @Override
    @Nullable
    protected Pair<GitRemote, String> getRemote(@NotNull GithubServerPath server, @NotNull GitRepository repository) {
        if (server == null) {
            GithubCreatePullRequestAction.$$$reportNull$$$0(3);
        }
        if (repository == null) {
            GithubCreatePullRequestAction.$$$reportNull$$$0(4);
        }
        return GithubCreatePullRequestWorker.findGithubRemote(server, repository);
    }

    static void createPullRequest(@NotNull Project project, @NotNull GitRepository gitRepository, @NotNull GithubAccount account) {
        GithubCreatePullRequestWorker worker;
        if (project == null) {
            GithubCreatePullRequestAction.$$$reportNull$$$0(5);
        }
        if (gitRepository == null) {
            GithubCreatePullRequestAction.$$$reportNull$$$0(6);
        }
        if (account == null) {
            GithubCreatePullRequestAction.$$$reportNull$$$0(7);
        }
        if ((worker = GithubCreatePullRequestWorker.create(project, gitRepository, account)) == null) {
            return;
        }
        GithubCreatePullRequestDialog dialog2 = new GithubCreatePullRequestDialog(project, worker);
        DialogManager.show((DialogWrapper)dialog2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRepository";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "account";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/github/GithubCreatePullRequestAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getRemote";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createPullRequest";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

