/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.psi;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.console.parsing.PyConsoleParsingContext;
import com.jetbrains.python.console.parsing.PythonConsoleData;
import com.jetbrains.python.parsing.ExpressionParsing;
import com.jetbrains.python.parsing.FunctionParsing;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.parsing.StatementParsing;
import com.jetbrains.python.psi.LanguageLevel;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ipnb.psi.IpnbPyTokenTypes;

public class IpnbPyParsingContext
extends PyConsoleParsingContext {
    private final StatementParsing myStatementParser;
    private final ExpressionParsing myExpressionParser;
    private final FunctionParsing myFunctionParser;

    public IpnbPyParsingContext(PsiBuilder builder, LanguageLevel languageLevel, StatementParsing.FUTURE futureFlag, boolean startSymbol, PythonConsoleData data) {
        super(builder, languageLevel, futureFlag, data, startSymbol);
        this.myStatementParser = new IpnbPyStatementParsing((ParsingContext)this, futureFlag);
        this.myExpressionParser = new IpnbPyExpressionParsing((ParsingContext)this);
        this.myFunctionParser = new IpnbPyFunctionParsing((ParsingContext)this);
    }

    public ExpressionParsing getExpressionParser() {
        return this.myExpressionParser;
    }

    public StatementParsing getStatementParser() {
        return this.myStatementParser;
    }

    public FunctionParsing getFunctionParser() {
        return this.myFunctionParser;
    }

    private static class IpnbPyFunctionParsing
    extends FunctionParsing {
        public IpnbPyFunctionParsing(ParsingContext context) {
            super(context);
        }

        protected IElementType getFunctionType() {
            return IpnbPyTokenTypes.IPNB_FUNCTION;
        }
    }

    private static class IpnbPyStatementParsing
    extends StatementParsing {
        protected IpnbPyStatementParsing(ParsingContext context, @Nullable StatementParsing.FUTURE futureFlag) {
            super(context, futureFlag);
        }

        protected IElementType getReferenceType() {
            return IpnbPyTokenTypes.IPNB_REFERENCE;
        }

        public void parseStatement() {
            if (this.myBuilder.getTokenType() == PyTokenTypes.PERC) {
                PsiBuilder.Marker ipythonCommand = this.myBuilder.mark();
                while (this.myBuilder.getTokenType() != PyTokenTypes.STATEMENT_BREAK) {
                    this.myBuilder.advanceLexer();
                }
                ipythonCommand.done((IElementType)PyElementTypes.EMPTY_EXPRESSION);
            }
            super.parseStatement();
        }
    }

    private static class IpnbPyExpressionParsing
    extends PyConsoleParsingContext.ConsoleExpressionParsing {
        public IpnbPyExpressionParsing(ParsingContext context) {
            super(context);
        }

        protected IElementType getReferenceType() {
            return IpnbPyTokenTypes.IPNB_REFERENCE;
        }

        public boolean parsePrimaryExpression(boolean isTargetExpression) {
            IElementType firstToken = this.myBuilder.getTokenType();
            if (firstToken == PyTokenTypes.IDENTIFIER) {
                if (isTargetExpression) {
                    IpnbPyExpressionParsing.buildTokenElement(IpnbPyTokenTypes.IPNB_TARGET, (PsiBuilder)this.myBuilder);
                } else {
                    IpnbPyExpressionParsing.buildTokenElement((IElementType)this.getReferenceType(), (PsiBuilder)this.myBuilder);
                }
                return true;
            }
            return super.parsePrimaryExpression(isTargetExpression);
        }
    }
}

