/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.TimeoutUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ipnb.IpnbJfxUtils;
import org.jetbrains.plugins.ipnb.configuration.IpnbSettings;
import org.jetbrains.plugins.ipnb.editor.IpnbEditorUtil;

public class IpnbUtils {
    private static final Logger LOG = Logger.getInstance(IpnbUtils.class);

    public static JComponent createLatexPane(@NotNull String source, Project project, int width) {
        if (source == null) {
            IpnbUtils.$$$reportNull$$$0(0);
        }
        final JComponent panel = IpnbUtils.createHtmlPanel(source, project, width);
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Container parent = panel.getParent();
                MouseEvent parentEvent = SwingUtilities.convertMouseEvent(panel, e, parent);
                parent.dispatchEvent(parentEvent);
            }
        });
        return panel;
    }

    public static JComponent createHtmlPanel(@NotNull String source, Project project, int width) {
        if (source == null) {
            IpnbUtils.$$$reportNull$$$0(1);
        }
        if (IpnbSettings.getInstance(project).hasFx()) {
            return IpnbJfxUtils.createHtmlPanel(source, width);
        }
        return IpnbUtils.createNonJfxPanel(source);
    }

    public static JComponent createNonJfxPanel(@NotNull String source) {
        if (source == null) {
            IpnbUtils.$$$reportNull$$$0(2);
        }
        JTextArea textArea = new JTextArea(source);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        textArea.setBorder(BorderFactory.createLineBorder((Color)JBColor.lightGray));
        textArea.setBackground(IpnbEditorUtil.getBackground());
        return textArea;
    }

    @Nullable
    public static <T> T execCancelable(@NotNull Callable<T> callable) {
        if (callable == null) {
            IpnbUtils.$$$reportNull$$$0(3);
        }
        Future future = ApplicationManager.getApplication().executeOnPooledThread(callable);
        while (!future.isCancelled() && !future.isDone()) {
            ProgressManager.checkCanceled();
            TimeoutUtil.sleep((long)500L);
        }
        T result = null;
        try {
            result = (T)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn(e.getMessage());
        }
        return result;
    }

    @Nullable
    public static <T> T runCancellableProcessUnderProgress(@NotNull Project project, @NotNull Callable<T> callable, @NotNull String title) {
        if (project == null) {
            IpnbUtils.$$$reportNull$$$0(4);
        }
        if (callable == null) {
            IpnbUtils.$$$reportNull$$$0(5);
        }
        if (title == null) {
            IpnbUtils.$$$reportNull$$$0(6);
        }
        return (T)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (callable == null) {
                IpnbUtils.$$$reportNull$$$0(7);
            }
            ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
            return IpnbUtils.execCancelable(callable);
        }, title, true, project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ipnb/IpnbUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createLatexPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createHtmlPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createNonJfxPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "execCancelable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "runCancellableProcessUnderProgress";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runCancellableProcessUnderProgress$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

