/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.python.codeInsight.fstrings.FStringParser;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.validation.PyAnnotator;
import org.jetbrains.annotations.NotNull;

public class FStringsAnnotator
extends PyAnnotator {
    @Override
    public void visitPyStringLiteralExpression(PyStringLiteralExpression pyString) {
        for (ASTNode node : pyString.getStringNodes()) {
            PyUtil.StringNodeInfo nodeInfo = new PyUtil.StringNodeInfo(node);
            String nodeText = node.getText();
            if (!nodeInfo.isFormatted()) continue;
            int nodeContentEnd = nodeInfo.getContentRange().getEndOffset();
            FStringParser.ParseResult result2 = FStringParser.parse(nodeText);
            TextRange unclosedBraceRange = null;
            for (FStringParser.Fragment fragment : result2.getFragments()) {
                TextRange range2;
                int fragLeftBrace = fragment.getLeftBraceOffset();
                int fragContentEnd = fragment.getContentEndOffset();
                int fragRightBrace = fragment.getRightBraceOffset();
                TextRange wholeFragmentRange = TextRange.create((int)fragLeftBrace, (int)(fragRightBrace == -1 ? nodeContentEnd : fragRightBrace + 1));
                if (fragment.getDepth() > 2) {
                    if (fragment.getDepth() != 3) continue;
                    this.report("Expression fragment inside f-string is nested too deeply", wholeFragmentRange, node);
                    continue;
                }
                if (CharArrayUtil.isEmptyOrSpaces((CharSequence)nodeText, (int)(fragLeftBrace + 1), (int)fragContentEnd) && fragContentEnd < nodeContentEnd) {
                    range2 = TextRange.create((int)fragLeftBrace, (int)(fragContentEnd + 1));
                    this.report("Empty expression fragments are not allowed inside f-strings", range2, node);
                }
                if (fragRightBrace == -1 && unclosedBraceRange == null) {
                    unclosedBraceRange = wholeFragmentRange;
                }
                if (fragment.getFirstHashOffset() != -1) {
                    range2 = TextRange.create((int)fragment.getFirstHashOffset(), (int)fragment.getContentEndOffset());
                    this.report("Expression fragments inside f-strings cannot include line comments", range2, node);
                }
                for (int i = fragLeftBrace + 1; i < fragment.getContentEndOffset(); ++i) {
                    if (nodeText.charAt(i) != '\\') continue;
                    this.reportCharacter("Expression fragments inside f-strings cannot include backslashes", i, node);
                }
                if (fragContentEnd >= nodeContentEnd || nodeText.charAt(fragContentEnd) != '!' || fragContentEnd + 1 >= nodeContentEnd) continue;
                char conversionChar = nodeText.charAt(fragContentEnd + 1);
                if (fragContentEnd + 1 == fragRightBrace || conversionChar == ':') {
                    this.reportCharacter("Conversion character is expected: should be one of 's', 'r', 'a'", fragContentEnd, node);
                    continue;
                }
                if ("sra".indexOf(conversionChar) >= 0) continue;
                TextRange range3 = TextRange.from((int)fragContentEnd, (int)2);
                this.report("Illegal conversion character '" + conversionChar + "': should be one of 's', 'r', 'a'", range3, node);
            }
            for (Integer offset : result2.getSingleRightBraces()) {
                this.reportCharacter("Single '}' is not allowed inside f-strings", offset, node);
            }
            if (unclosedBraceRange == null) continue;
            this.report("'}' is expected", unclosedBraceRange, node);
        }
    }

    private void report(@NotNull String message, @NotNull TextRange range2, @NotNull ASTNode node) {
        if (message == null) {
            FStringsAnnotator.$$$reportNull$$$0(0);
        }
        if (range2 == null) {
            FStringsAnnotator.$$$reportNull$$$0(1);
        }
        if (node == null) {
            FStringsAnnotator.$$$reportNull$$$0(2);
        }
        this.getHolder().createErrorAnnotation(range2.shiftRight(node.getTextRange().getStartOffset()), message);
    }

    private void reportCharacter(@NotNull String message, int offset, @NotNull ASTNode node) {
        if (message == null) {
            FStringsAnnotator.$$$reportNull$$$0(3);
        }
        if (node == null) {
            FStringsAnnotator.$$$reportNull$$$0(4);
        }
        this.report(message, TextRange.from((int)offset, (int)1), node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/FStringsAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "report";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "reportCharacter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

