/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.codeInsight.daemon.impl.HighlightRangeExtension;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.validation.PyAnnotator;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumbAwareHighlightingAnnotator
extends PyAnnotator
implements HighlightRangeExtension {
    @Override
    public void visitPyFunction(PyFunction node) {
        if (node.isAsyncAllowed()) {
            this.highlightKeyword(node, PyTokenTypes.ASYNC_KEYWORD);
        } else {
            Optional.ofNullable(node.getNode()).map(astNode -> astNode.findChildByType((IElementType)PyTokenTypes.ASYNC_KEYWORD)).ifPresent(asyncNode -> this.getHolder().createErrorAnnotation(asyncNode, "function \"" + node.getName() + "\" cannot be async"));
        }
    }

    @Override
    public void visitPyForStatement(PyForStatement node) {
        this.highlightKeyword(node, PyTokenTypes.ASYNC_KEYWORD);
    }

    @Override
    public void visitPyWithStatement(PyWithStatement node) {
        this.highlightKeyword(node, PyTokenTypes.ASYNC_KEYWORD);
    }

    @Override
    public void visitPyPrefixExpression(PyPrefixExpression node) {
        this.highlightKeyword((PsiElement)node, PyTokenTypes.AWAIT_KEYWORD);
    }

    @Override
    public void visitPyComprehensionElement(PyComprehensionElement node) {
        this.highlightKeywords(node, PyTokenTypes.ASYNC_KEYWORD);
    }

    @Override
    public boolean isForceHighlightParents(@NotNull PsiFile file2) {
        if (file2 == null) {
            DumbAwareHighlightingAnnotator.$$$reportNull$$$0(0);
        }
        return file2 instanceof PyFile;
    }

    private void highlightKeyword(@NotNull PsiElement node, @NotNull PyElementType elementType) {
        if (node == null) {
            DumbAwareHighlightingAnnotator.$$$reportNull$$$0(1);
        }
        if (elementType == null) {
            DumbAwareHighlightingAnnotator.$$$reportNull$$$0(2);
        }
        this.highlightAsKeyword(node.getNode().findChildByType((IElementType)elementType));
    }

    private void highlightKeywords(@NotNull PsiElement node, @NotNull PyElementType elementType) {
        if (node == null) {
            DumbAwareHighlightingAnnotator.$$$reportNull$$$0(3);
        }
        if (elementType == null) {
            DumbAwareHighlightingAnnotator.$$$reportNull$$$0(4);
        }
        for (ASTNode astNode : node.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{elementType}))) {
            this.highlightAsKeyword(astNode);
        }
    }

    private void highlightAsKeyword(@Nullable ASTNode astNode) {
        if (astNode != null) {
            Annotation annotation = this.getHolder().createInfoAnnotation(astNode, null);
            annotation.setTextAttributes(PyHighlighter.PY_KEYWORD);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/DumbAwareHighlightingAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isForceHighlightParents";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightKeyword";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightKeywords";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

