/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.ide.DataManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.reference.SoftReference;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.ExceptionFix;
import com.intellij.remote.RemoteSdkCredentialsHolder;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.VagrantNotStartedException;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.LanguageCaseCollector;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.facet.PythonFacetSettings;
import com.jetbrains.python.packaging.PyCondaPackageManagerImpl;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.search.PyProjectScopeBuilder;
import com.jetbrains.python.remote.PyCredentialsContribution;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.PyVirtualEnvReader;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkDetailsStep;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.pipenv.PyPipEnvSdkAdditionalData;
import icons.PythonIcons;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonSdkType
extends SdkType {
    public static final String REMOTE_SOURCES_DIR_NAME = "remote_sources";
    private static final Logger LOG = Logger.getInstance(PythonSdkType.class);
    private static final String[] WINDOWS_EXECUTABLE_SUFFIXES = new String[]{"cmd", "exe", "bat", "com"};
    private static final int MINUTE = 60000;
    @NonNls
    private static final String SKELETONS_TOPIC = "Skeletons";
    private static final String[] DIRS_WITH_BINARY = new String[]{"", "bin", "Scripts"};
    private static final String[] UNIX_BINARY_NAMES = new String[]{"jython", "pypy", "python", "python3"};
    private static final String[] WIN_BINARY_NAMES = new String[]{"jython.bat", "ipy.exe", "pypy.exe", "python.exe", "python3.exe"};
    private static final Key<WeakReference<Component>> SDK_CREATOR_COMPONENT_KEY = Key.create((String)"#com.jetbrains.python.sdk.creatorComponent");
    private static final Predicate<Sdk> REMOTE_SDK_PREDICATE = PythonSdkType::isRemote;
    public static final Key<Map<String, String>> ENVIRONMENT_KEY = Key.create((String)"ENVIRONMENT_KEY");
    public static final String SKELETON_DIR_NAME = "python_stubs";
    public static final OrderRootType BUILTIN_ROOT_TYPE = OrderRootType.CLASSES;

    public static PythonSdkType getInstance() {
        return (PythonSdkType)SdkType.findInstance(PythonSdkType.class);
    }

    private PythonSdkType() {
        super("Python SDK");
    }

    public Icon getIcon() {
        return PythonIcons.Python.Python;
    }

    @NotNull
    public String getHelpTopic() {
        if ("reference.project.structure.sdk.python" == null) {
            PythonSdkType.$$$reportNull$$$0(0);
        }
        return "reference.project.structure.sdk.python";
    }

    @NotNull
    public Icon getIconForAddAction() {
        Icon icon = PythonFileType.INSTANCE.getIcon();
        if (icon == null) {
            PythonSdkType.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    @NonNls
    public static String getBuiltinsFileName(@NotNull Sdk sdk) {
        LanguageLevel level;
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(2);
        }
        String string = (level = PythonSdkType.getLanguageLevelForSdk(sdk)).isPython2() ? "__builtin__.py" : "builtins.py";
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NonNls
    @Nullable
    public String suggestHomePath() {
        String pythonFromPath = PythonSdkType.findPythonInPath();
        if (pythonFromPath != null) {
            return pythonFromPath;
        }
        for (PythonSdkFlavor flavor : PythonSdkFlavor.getApplicableFlavors()) {
            TreeSet<String> candidates = PythonSdkType.createVersionSet();
            candidates.addAll(flavor.suggestHomePaths());
            if (candidates.isEmpty()) continue;
            String[] candidateArray = ArrayUtil.toStringArray(candidates);
            return candidateArray[candidateArray.length - 1];
        }
        return null;
    }

    @Nullable
    private static String findPythonInPath() {
        String defaultCommand = SystemInfo.isWindows ? "python.exe" : "python";
        String path = System.getenv("PATH");
        for (String root : path.split(File.pathSeparator)) {
            File file2 = new File(root, defaultCommand);
            if (!file2.exists()) continue;
            try {
                return file2.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    public Collection<String> suggestHomePaths() {
        ArrayList<String> candidates = new ArrayList<String>();
        for (PythonSdkFlavor flavor : PythonSdkFlavor.getApplicableFlavors()) {
            candidates.addAll(flavor.suggestHomePaths());
        }
        ArrayList<String> arrayList = candidates;
        if (arrayList == null) {
            PythonSdkType.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static TreeSet<String> createVersionSet() {
        return new TreeSet<String>(Comparator.comparing(PythonSdkType::findDigits));
    }

    private static String findDigits(String s) {
        int pos = StringUtil.findFirst((CharSequence)s, Character::isDigit);
        if (pos >= 0) {
            return s.substring(pos);
        }
        return s;
    }

    public static boolean hasValidSdk() {
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!(sdk.getSdkType() instanceof PythonSdkType)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidSdkHome(@Nullable String path) {
        return PythonSdkFlavor.getFlavor(path) != null;
    }

    public static boolean isInvalid(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(5);
        }
        if (PythonSdkType.isRemote(sdk)) {
            return false;
        }
        VirtualFile interpreter = sdk.getHomeDirectory();
        return interpreter == null || !interpreter.exists();
    }

    public static boolean isRemote(@Nullable Sdk sdk) {
        return PySdkUtil.isRemote(sdk);
    }

    public static boolean isVagrant(@Nullable Sdk sdk) {
        if (sdk != null && sdk.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataBase) {
            PyRemoteSdkAdditionalDataBase data = (PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData();
            return data.connectionCredentials().getRemoteConnectionType() == CredentialsType.VAGRANT;
        }
        return false;
    }

    public static boolean isRemote(@Nullable String sdkPath) {
        return PythonSdkType.isRemote(PythonSdkType.findSdkByPath(sdkPath));
    }

    @NotNull
    public FileChooserDescriptor getHomeChooserDescriptor() {
        final boolean isWindows = SystemInfo.isWindows;
        FileChooserDescriptor fileChooserDescriptor2 = new FileChooserDescriptor(true, false, false, false, false, false){

            public void validateSelectedFiles(VirtualFile[] files2) throws Exception {
                if (files2.length != 0 && !PythonSdkType.this.isValidSdkHome(files2[0].getPath())) {
                    throw new Exception(PyBundle.message("sdk.error.invalid.interpreter.name.$0", files2[0].getName()));
                }
            }

            public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
                if (!file2.isDirectory() && isWindows) {
                    String path = file2.getPath();
                    boolean looksExecutable = false;
                    for (String ext : WINDOWS_EXECUTABLE_SUFFIXES) {
                        if (!path.endsWith(ext)) continue;
                        looksExecutable = true;
                        break;
                    }
                    return looksExecutable && super.isFileVisible(file2, showHiddenFiles);
                }
                return super.isFileVisible(file2, showHiddenFiles);
            }
        }.withTitle(PyBundle.message("sdk.select.path", new Object[0])).withShowHiddenFiles(SystemInfo.isUnix);
        if (fileChooserDescriptor2 == null) {
            PythonSdkType.$$$reportNull$$$0(6);
        }
        return fileChooserDescriptor2;
    }

    public boolean supportsCustomCreateUI() {
        return true;
    }

    public void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @NotNull Consumer<Sdk> sdkCreatedCallback) {
        if (sdkModel == null) {
            PythonSdkType.$$$reportNull$$$0(7);
        }
        if (parentComponent == null) {
            PythonSdkType.$$$reportNull$$$0(8);
        }
        if (sdkCreatedCallback == null) {
            PythonSdkType.$$$reportNull$$$0(9);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)parentComponent));
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo == null) {
            return;
        }
        Point point = pointerInfo.getLocation();
        PythonSdkDetailsStep.show(project, null, sdkModel.getSdks(), null, parentComponent, point, null, (NullableConsumer<Sdk>)((NullableConsumer)sdk -> {
            if (parentComponent == null) {
                PythonSdkType.$$$reportNull$$$0(52);
            }
            if (sdkCreatedCallback == null) {
                PythonSdkType.$$$reportNull$$$0(53);
            }
            if (sdk != null) {
                sdk.putUserData(SDK_CREATOR_COMPONENT_KEY, new WeakReference<JComponent>(parentComponent));
                sdkCreatedCallback.consume(sdk);
            }
        }));
    }

    public static boolean isVirtualEnv(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(10);
        }
        String path = sdk.getHomePath();
        return PythonSdkType.isVirtualEnv(path);
    }

    public static boolean isVirtualEnv(String path) {
        return path != null && PythonSdkType.getVirtualEnvRoot(path) != null;
    }

    public static boolean isConda(@NotNull Sdk sdk) {
        String path;
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(11);
        }
        return (path = sdk.getHomePath()) != null && PyCondaPackageManagerImpl.isConda(sdk);
    }

    public static boolean isCondaVirtualEnv(@NotNull Sdk sdk) {
        String path;
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(12);
        }
        return (path = sdk.getHomePath()) != null && PyCondaPackageManagerImpl.isCondaVEnv(sdk);
    }

    @Nullable
    public Sdk getVirtualEnvBaseSdk(Sdk sdk) {
        if (PythonSdkType.isVirtualEnv(sdk)) {
            PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(sdk);
            String version = this.getVersionString(sdk);
            if (flavor != null && version != null) {
                for (Sdk baseSdk : PythonSdkType.getAllSdks()) {
                    if (PythonSdkType.isRemote(baseSdk)) continue;
                    PythonSdkFlavor baseFlavor = PythonSdkFlavor.getFlavor(baseSdk);
                    if (PythonSdkType.isVirtualEnv(baseSdk) || !flavor.equals(baseFlavor) || !version.equals(this.getVersionString(baseSdk))) continue;
                    return baseSdk;
                }
            }
        }
        return null;
    }

    @Nullable
    public static File getVirtualEnvRoot(@NotNull String binaryPath) {
        String rootPath;
        File bin;
        if (binaryPath == null) {
            PythonSdkType.$$$reportNull$$$0(13);
        }
        if ((bin = new File(binaryPath).getParentFile()) != null && (rootPath = bin.getParent()) != null) {
            File activate;
            File root = new File(rootPath);
            File activateThis = new File(bin, "activate_this.py");
            if (activateThis.exists() && (activate = PythonSdkType.findExecutableFile(bin, "activate")) != null) {
                return root;
            }
            if (new File(root, "pyvenv.cfg").exists()) {
                return root;
            }
        }
        return null;
    }

    @Nullable
    public static File findExecutableFile(File parent, String name) {
        File file2;
        if (SystemInfo.isWindows) {
            for (String suffix : WINDOWS_EXECUTABLE_SUFFIXES) {
                File file3 = new File(parent, name + "." + suffix);
                if (!file3.exists()) continue;
                return file3;
            }
        } else if (SystemInfo.isUnix && (file2 = new File(parent, name)).exists()) {
            return file2;
        }
        return null;
    }

    public static void patchCommandLineForVirtualenv(GeneralCommandLine commandLine, String sdkHome, boolean passParentEnvironment) {
        File virtualEnvRoot = PythonSdkType.getVirtualEnvRoot(sdkHome);
        if (virtualEnvRoot != null) {
            String PATH = "PATH";
            File bin = new File(virtualEnvRoot, "bin");
            if (!bin.exists()) {
                bin = new File(virtualEnvRoot, "Scripts");
            }
            String virtualenvBin = bin.getPath();
            Map env = commandLine.getEnvironment();
            String pathValue = env.containsKey("PATH") ? PythonEnvUtil.appendToPathEnvVar((String)env.get("PATH"), virtualenvBin) : (passParentEnvironment ? PythonEnvUtil.appendToPathEnvVar(System.getenv("PATH"), virtualenvBin) : virtualenvBin);
            env.put("PATH", pathValue);
        }
    }

    public String suggestSdkName(String currentSdkName, String sdkHome) {
        String name = StringUtil.notNullize((String)PythonSdkType.suggestBaseSdkName(sdkHome), (String)"Unknown");
        File virtualEnvRoot = PythonSdkType.getVirtualEnvRoot(sdkHome);
        if (virtualEnvRoot != null) {
            String path = FileUtil.getLocationRelativeToUserHome((String)virtualEnvRoot.getAbsolutePath());
            return name + " virtualenv at " + path;
        }
        return name;
    }

    @Nullable
    public static String suggestBaseSdkName(@NotNull String sdkHome) {
        PythonSdkFlavor flavor;
        if (sdkHome == null) {
            PythonSdkType.$$$reportNull$$$0(14);
        }
        if ((flavor = PythonSdkFlavor.getFlavor(sdkHome)) == null) {
            return null;
        }
        return flavor.getName() + " " + (Object)((Object)flavor.getLanguageLevel(sdkHome));
    }

    @Nullable
    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            PythonSdkType.$$$reportNull$$$0(15);
        }
        if (sdkModificator == null) {
            PythonSdkType.$$$reportNull$$$0(16);
        }
        return null;
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            PythonSdkType.$$$reportNull$$$0(17);
        }
        if (additional == null) {
            PythonSdkType.$$$reportNull$$$0(18);
        }
        if (additionalData instanceof PythonSdkAdditionalData) {
            ((PythonSdkAdditionalData)additionalData).save(additional);
        }
    }

    public SdkAdditionalData loadAdditionalData(@NotNull Sdk currentSdk, @Nullable Element additional) {
        PyPipEnvSdkAdditionalData pipEnvData;
        PythonRemoteInterpreterManager manager;
        if (currentSdk == null) {
            PythonSdkType.$$$reportNull$$$0(19);
        }
        if (RemoteSdkCredentialsHolder.isRemoteSdk(currentSdk.getHomePath()) && (manager = PythonRemoteInterpreterManager.getInstance()) != null) {
            return manager.loadRemoteSdkData(currentSdk, additional);
        }
        if (additional != null && (pipEnvData = PyPipEnvSdkAdditionalData.load(additional)) != null) {
            return pipEnvData;
        }
        return PythonSdkAdditionalData.load(currentSdk, additional);
    }

    public static boolean isSkeletonsPath(String path) {
        return path.contains(SKELETON_DIR_NAME);
    }

    @NotNull
    @NonNls
    public String getPresentableName() {
        if ("Python SDK" == null) {
            PythonSdkType.$$$reportNull$$$0(20);
        }
        return "Python SDK";
    }

    public String sdkPath(@NotNull VirtualFile homePath) {
        VirtualFile sdkPath;
        String path;
        PythonSdkFlavor flavor;
        if (homePath == null) {
            PythonSdkType.$$$reportNull$$$0(21);
        }
        if ((flavor = PythonSdkFlavor.getFlavor(path = super.sdkPath(homePath))) != null && (sdkPath = flavor.getSdkPath(homePath)) != null) {
            return FileUtil.toSystemDependentName((String)sdkPath.getPath());
        }
        return FileUtil.toSystemDependentName((String)path);
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        WeakReference ownerComponentRef;
        Component ownerComponent;
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(22);
        }
        Project project = (ownerComponent = (Component)SoftReference.dereference((Reference)(ownerComponentRef = (WeakReference)sdk.getUserData(SDK_CREATOR_COMPONENT_KEY)))) != null ? (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(ownerComponent)) : (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        PythonSdkUpdater.updateOrShowError(sdk, null, project, ownerComponent);
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk, @NotNull SdkModel sdkModel) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(23);
        }
        if (sdkModel == null) {
            PythonSdkType.$$$reportNull$$$0(24);
        }
        return true;
    }

    public static void notifyRemoteSdkSkeletonsFail(InvalidSdkException e, @Nullable Runnable restartAction) {
        String notificationMessage;
        NotificationListener notificationListener;
        if (e.getCause() instanceof VagrantNotStartedException) {
            notificationListener = (notification2, event) -> {
                PythonRemoteInterpreterManager manager = PythonRemoteInterpreterManager.getInstance();
                if (manager != null) {
                    try {
                        VagrantNotStartedException cause = (VagrantNotStartedException)e.getCause();
                        manager.runVagrant(cause.getVagrantFolder(), cause.getMachineName());
                    }
                    catch (ExecutionException e1) {
                        throw new RuntimeException(e1);
                    }
                }
                if (restartAction != null) {
                    restartAction.run();
                }
            };
            notificationMessage = e.getMessage() + "\n<a href=\"#\">Launch vagrant and refresh skeletons</a>";
        } else if (ExceptionUtil.causedBy((Throwable)e, ExceptionFix.class)) {
            ExceptionFix fix = (ExceptionFix)ExceptionUtil.findCause((Throwable)e, ExceptionFix.class);
            notificationListener = (notification2, event) -> {
                fix.apply();
                if (restartAction != null) {
                    restartAction.run();
                }
            };
            notificationMessage = fix.getNotificationMessage(e.getMessage());
        } else {
            notificationListener = null;
            notificationMessage = e.getMessage();
        }
        Notifications.Bus.notify((Notification)new Notification(SKELETONS_TOPIC, "Couldn't refresh skeletons for remote interpreter", notificationMessage, NotificationType.WARNING, notificationListener));
    }

    @NotNull
    public static VirtualFile getSdkRootVirtualFile(@NotNull VirtualFile path) {
        VirtualFile jar;
        String suffix;
        if (path == null) {
            PythonSdkType.$$$reportNull$$$0(25);
        }
        if ((suffix = path.getExtension()) != null) {
            suffix = suffix.toLowerCase();
        }
        if (!path.isDirectory() && ("zip".equals(suffix) || "egg".equals(suffix)) && (jar = JarFileSystem.getInstance().getJarRootForLocalFile(path)) != null) {
            VirtualFile virtualFile = jar;
            if (virtualFile == null) {
                PythonSdkType.$$$reportNull$$$0(26);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = path;
        if (virtualFile == null) {
            PythonSdkType.$$$reportNull$$$0(27);
        }
        return virtualFile;
    }

    public static String getSkeletonsPath(String basePath, String sdkHome) {
        String sep = File.separator;
        return PythonSdkType.getSkeletonsRootPath(basePath) + sep + FileUtil.toSystemIndependentName((String)sdkHome).hashCode() + sep;
    }

    public static String getSkeletonsRootPath(String basePath) {
        return basePath + File.separator + SKELETON_DIR_NAME;
    }

    @NotNull
    public static List<String> getSysPath(String bin_path) throws InvalidSdkException {
        String working_dir = new File(bin_path).getParent();
        Application application = ApplicationManager.getApplication();
        if (application != null && (!application.isUnitTestMode() || ApplicationInfoImpl.isInStressTest())) {
            List<String> list2 = PythonSdkType.getSysPathsFromScript(bin_path);
            if (list2 == null) {
                PythonSdkType.$$$reportNull$$$0(28);
            }
            return list2;
        }
        ArrayList<String> ret = new ArrayList<String>(1);
        ret.add(working_dir);
        ArrayList<String> arrayList = ret;
        if (arrayList == null) {
            PythonSdkType.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getSysPathsFromScript(@NotNull String binaryPath) throws InvalidSdkException {
        GeneralCommandLine cmd;
        ProcessOutput runResult;
        if (binaryPath == null) {
            PythonSdkType.$$$reportNull$$$0(30);
        }
        if (!(runResult = PySdkUtil.getProcessOutput(cmd = PythonHelper.SYSPATH.newCommandLine(binaryPath, (List<String>)Lists.newArrayList()), new File(binaryPath).getParent(), PythonSdkType.getVirtualEnvExtraEnv(binaryPath), 60000)).checkSuccess(LOG)) {
            throw new InvalidSdkException(String.format("Failed to determine Python's sys.path value:\nSTDOUT: %s\nSTDERR: %s", runResult.getStdout(), runResult.getStderr()));
        }
        List list2 = runResult.getStdoutLines();
        if (list2 == null) {
            PythonSdkType.$$$reportNull$$$0(31);
        }
        return list2;
    }

    @Nullable
    public static Map<String, String> getVirtualEnvExtraEnv(@NotNull String binaryPath) {
        File root;
        if (binaryPath == null) {
            PythonSdkType.$$$reportNull$$$0(32);
        }
        if ((root = PythonSdkType.getVirtualEnvRoot(binaryPath)) != null) {
            return ImmutableMap.of((Object)"PATH", (Object)root.toString());
        }
        return null;
    }

    @Nullable
    public String getVersionString(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(33);
        }
        if (PythonSdkType.isRemote(sdk)) {
            PyRemoteSdkAdditionalDataBase data = (PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData();
            assert (data != null);
            String versionString = data.getVersionString();
            if (StringUtil.isEmpty((String)versionString)) {
                PythonRemoteInterpreterManager remoteInterpreterManager = PythonRemoteInterpreterManager.getInstance();
                if (remoteInterpreterManager != null) {
                    try {
                        versionString = remoteInterpreterManager.getInterpreterVersion(null, data);
                    }
                    catch (Exception e) {
                        LOG.warn("Couldn't get interpreter version:" + e.getMessage(), (Throwable)e);
                        versionString = "undefined";
                    }
                }
                data.setVersionString(versionString);
            }
            return versionString;
        }
        return this.getVersionString(sdk.getHomePath());
    }

    @Nullable
    public String getVersionString(@Nullable String sdkHome) {
        PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(sdkHome);
        return flavor != null ? flavor.getVersionString(sdkHome) : null;
    }

    public static List<Sdk> getAllSdks() {
        return ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)PythonSdkType.getInstance());
    }

    @Nullable
    public static Sdk findPythonSdk(@Nullable Module module2) {
        Facet[] facets;
        if (module2 == null) {
            return null;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
        if (sdk != null && sdk.getSdkType() instanceof PythonSdkType) {
            return sdk;
        }
        for (Facet facet : facets = FacetManager.getInstance((Module)module2).getAllFacets()) {
            FacetConfiguration configuration = facet.getConfiguration();
            if (!(configuration instanceof PythonFacetSettings)) continue;
            return ((PythonFacetSettings)configuration).getSdk();
        }
        return null;
    }

    @Nullable
    public static Sdk findPythonSdk(@NotNull PsiElement element) {
        if (element == null) {
            PythonSdkType.$$$reportNull$$$0(34);
        }
        return PythonSdkType.findPythonSdk(ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
    }

    @Nullable
    public static Sdk findSdkByPath(@Nullable String path) {
        if (path != null) {
            return PythonSdkType.findSdkByPath(PythonSdkType.getAllSdks(), path);
        }
        return null;
    }

    @Nullable
    public static Sdk findSdkByPath(List<Sdk> sdkList, @Nullable String path) {
        if (path != null) {
            for (Sdk sdk : sdkList) {
                if (sdk == null || !FileUtil.pathsEqual((String)path, (String)sdk.getHomePath())) continue;
                return sdk;
            }
        }
        return null;
    }

    @NotNull
    public static LanguageLevel getLanguageLevelForSdk(@Nullable Sdk sdk) {
        PythonSdkFlavor flavor;
        if (sdk != null && sdk.getSdkType() instanceof PythonSdkType && (flavor = PythonSdkFlavor.getFlavor(sdk)) != null) {
            LanguageLevel languageLevel = flavor.getLanguageLevel(sdk);
            if (languageLevel == null) {
                PythonSdkType.$$$reportNull$$$0(35);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (languageLevel == null) {
            PythonSdkType.$$$reportNull$$$0(36);
        }
        return languageLevel;
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type) {
        if (type == null) {
            PythonSdkType.$$$reportNull$$$0(37);
        }
        return type == OrderRootType.CLASSES;
    }

    public boolean sdkHasValidPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(38);
        }
        if (PySdkUtil.isRemote(sdk)) {
            return true;
        }
        VirtualFile homeDir = sdk.getHomeDirectory();
        return homeDir != null && homeDir.isValid();
    }

    public static boolean isStdLib(@NotNull VirtualFile vFile, @Nullable Sdk pythonSdk2) {
        if (vFile == null) {
            PythonSdkType.$$$reportNull$$$0(39);
        }
        VirtualFile resolved = (VirtualFile)ObjectUtils.notNull((Object)vFile.getCanonicalFile(), (Object)vFile);
        if (pythonSdk2 != null) {
            VirtualFile libDir = PyProjectScopeBuilder.findLibDir(pythonSdk2);
            if (libDir != null && VfsUtilCore.isAncestor((VirtualFile)libDir, (VirtualFile)resolved, (boolean)false)) {
                return PythonSdkType.isNotSitePackages(resolved, libDir);
            }
            VirtualFile venvLibDir = PyProjectScopeBuilder.findVirtualEnvLibDir(pythonSdk2);
            if (venvLibDir != null && VfsUtilCore.isAncestor((VirtualFile)venvLibDir, (VirtualFile)resolved, (boolean)false)) {
                return PythonSdkType.isNotSitePackages(resolved, venvLibDir);
            }
            VirtualFile skeletonsDir = PySdkUtil.findSkeletonsDir(pythonSdk2);
            if (skeletonsDir != null && Comparing.equal((Object)vFile.getParent(), (Object)skeletonsDir)) {
                return true;
            }
            if (PyUserSkeletonsUtil.isStandardLibrarySkeleton(vFile)) {
                return true;
            }
            if (PyTypeShed.INSTANCE.isInStandardLibrary(vFile) && PyTypeShed.INSTANCE.isInside(vFile)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isNotSitePackages(VirtualFile vFile, VirtualFile libDir) {
        VirtualFile sitePackages = libDir.findChild("site-packages");
        return sitePackages == null || !VfsUtilCore.isAncestor((VirtualFile)sitePackages, (VirtualFile)vFile, (boolean)false);
    }

    @Nullable
    public static VirtualFile getSitePackagesDirectory(@NotNull Sdk pythonSdk2) {
        if (pythonSdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(40);
        }
        VirtualFile libDir = PythonSdkType.isVirtualEnv(pythonSdk2) ? PyProjectScopeBuilder.findVirtualEnvLibDir(pythonSdk2) : PyProjectScopeBuilder.findLibDir(pythonSdk2);
        return libDir != null ? libDir.findChild("site-packages") : null;
    }

    @Nullable
    public static Sdk findPython2Sdk(@Nullable Module module2) {
        Sdk moduleSDK = PythonSdkType.findPythonSdk(module2);
        if (moduleSDK != null && PythonSdkType.getLanguageLevelForSdk(moduleSDK).isPython2()) {
            return moduleSDK;
        }
        return PythonSdkType.findPython2Sdk(PythonSdkType.getAllSdks());
    }

    @Nullable
    public static Sdk findPython2Sdk(@NotNull List<Sdk> sdks) {
        if (sdks == null) {
            PythonSdkType.$$$reportNull$$$0(41);
        }
        for (Sdk sdk : ContainerUtil.sorted(sdks, (Comparator)PreferredSdkComparator.INSTANCE)) {
            if (!PythonSdkType.getLanguageLevelForSdk(sdk).isPython2()) continue;
            return sdk;
        }
        return null;
    }

    @Nullable
    public static Sdk findLocalCPython(@Nullable Module module2) {
        Sdk moduleSDK = PythonSdkType.findPythonSdk(module2);
        if (moduleSDK != null && !PythonSdkType.isRemote(moduleSDK) && PythonSdkFlavor.getFlavor(moduleSDK) instanceof CPythonSdkFlavor) {
            return moduleSDK;
        }
        for (Sdk sdk : ContainerUtil.sorted(PythonSdkType.getAllSdks(), (Comparator)PreferredSdkComparator.INSTANCE)) {
            if (PythonSdkType.isRemote(sdk)) continue;
            return sdk;
        }
        return null;
    }

    public static List<Sdk> getAllLocalCPythons() {
        return PythonSdkType.getAllSdks().stream().filter(REMOTE_SDK_PREDICATE.negate()).collect(Collectors.toList());
    }

    @Nullable
    public static String getPythonExecutable(@NotNull String rootPath) {
        File rootFile;
        if (rootPath == null) {
            PythonSdkType.$$$reportNull$$$0(42);
        }
        if ((rootFile = new File(rootPath)).isFile()) {
            return rootFile.getAbsolutePath();
        }
        for (String dir : DIRS_WITH_BINARY) {
            File subDir = StringUtil.isEmpty((String)dir) ? rootFile : new File(rootFile, dir);
            if (!subDir.isDirectory()) continue;
            for (String binaryName : PythonSdkType.getBinaryNames()) {
                File executable = new File(subDir, binaryName);
                if (!executable.isFile()) continue;
                return executable.getAbsolutePath();
            }
        }
        return null;
    }

    @Nullable
    public static String getExecutablePath(@NotNull String homeDirectory, @NotNull String name) {
        String resolvedPath;
        File binPath;
        File binDir;
        if (homeDirectory == null) {
            PythonSdkType.$$$reportNull$$$0(43);
        }
        if (name == null) {
            PythonSdkType.$$$reportNull$$$0(44);
        }
        if ((binDir = (binPath = new File(homeDirectory)).getParentFile()) == null) {
            return null;
        }
        File runner = new File(binDir, name);
        if (runner.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(runner.getPath());
        }
        runner = new File(new File(binDir, "Scripts"), name);
        if (runner.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(runner.getPath());
        }
        runner = new File(new File(binDir.getParentFile(), "Scripts"), name);
        if (runner.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(runner.getPath());
        }
        runner = new File(new File(binDir.getParentFile(), "local"), name);
        if (runner.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(runner.getPath());
        }
        runner = new File(new File(new File(binDir.getParentFile(), "local"), "bin"), name);
        if (runner.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(runner.getPath());
        }
        if (FileSystemUtil.isSymLink((String)homeDirectory) && (resolvedPath = FileSystemUtil.resolveSymLink((String)homeDirectory)) != null) {
            return PythonSdkType.getExecutablePath(resolvedPath, name);
        }
        runner = new File(new File("/usr", "bin"), name);
        if (runner.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(runner.getPath());
        }
        runner = new File(new File(new File("/usr", "local"), "bin"), name);
        if (runner.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(runner.getPath());
        }
        return null;
    }

    private static String[] getBinaryNames() {
        if (SystemInfo.isUnix) {
            return UNIX_BINARY_NAMES;
        }
        return WIN_BINARY_NAMES;
    }

    public static boolean isIncompleteRemote(Sdk sdk) {
        return PySdkUtil.isRemote(sdk) && !((PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData()).isValid();
    }

    public static boolean hasInvalidRemoteCredentials(Sdk sdk) {
        if (PySdkUtil.isRemote(sdk)) {
            final Ref result2 = Ref.create((Object)false);
            ((PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData()).switchOnConnectionType(new LanguageCaseCollector<PyCredentialsContribution>(){

                @Override
                protected void processLanguageContribution(PyCredentialsContribution languageContribution, Object credentials) {
                    result2.set((Object)(!languageContribution.isValid(credentials) ? 1 : 0));
                }
            }.collectCases(PyCredentialsContribution.class, new CredentialsCase.Vagrant(){

                @Override
                public void process(VagrantBasedCredentialsHolder cred) {
                    result2.set((Object)StringUtil.isEmpty((String)cred.getVagrantFolder()));
                }
            }));
            return (Boolean)result2.get();
        }
        return false;
    }

    @Deprecated
    @Nullable
    public static Sdk getSdk(@NotNull PsiElement element) {
        if (element == null) {
            PythonSdkType.$$$reportNull$$$0(45);
        }
        return PythonSdkType.findPythonSdk(element);
    }

    @NotNull
    public static String getSdkKey(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(46);
        }
        String string = sdk.getName();
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(47);
        }
        return string;
    }

    @Nullable
    public static Sdk findSdkByKey(@NotNull String key) {
        if (key == null) {
            PythonSdkType.$$$reportNull$$$0(48);
        }
        return ProjectJdkTable.getInstance().findJdk(key);
    }

    public boolean isLocalSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(49);
        }
        return !PythonSdkType.isRemote(sdk);
    }

    @NotNull
    public static Map<String, String> activateVirtualEnv(@NotNull String sdkHome) {
        if (sdkHome == null) {
            PythonSdkType.$$$reportNull$$$0(50);
        }
        HashMap env = Maps.newHashMap();
        PyVirtualEnvReader reader = new PyVirtualEnvReader(sdkHome);
        if (reader.getActivate() != null) {
            try {
                env.putAll(reader.readPythonEnv().entrySet().stream().filter(entry -> PyVirtualEnvReader.Companion.getVirtualEnvVars().contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            }
            catch (Exception e) {
                LOG.error("Couldn't read virtualenv variables", (Throwable)e);
            }
        }
        ImmutableMap immutableMap = ImmutableMap.copyOf((Map)env);
        if (immutableMap == null) {
            PythonSdkType.$$$reportNull$$$0(51);
        }
        return immutableMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkType";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 22: 
            case 23: 
            case 33: 
            case 38: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: 
            case 15: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 8: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 9: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkCreatedCallback";
                break;
            }
            case 13: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryPath";
                break;
            }
            case 14: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSdk";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 34: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonSdk";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homeDirectory";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconForAddAction";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltinsFileName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeChooserDescriptor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkRootVirtualFile";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSysPath";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getSysPathsFromScript";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelForSdk";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkKey";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "activateVirtualEnv";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinsFileName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInvalid";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showCustomCreateUI";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isVirtualEnv";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isConda";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isCondaVirtualEnv";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualEnvRoot";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "suggestBaseSdkName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalData";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "sdkPath";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setupSdkPaths";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSdkRootVirtualFile";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSysPathsFromScript";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualEnvExtraEnv";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getVersionString";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findPythonSdk";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isRootTypeApplicable";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "sdkHasValidPath";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isStdLib";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getSitePackagesDirectory";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findPython2Sdk";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getPythonExecutable";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getExecutablePath";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getSdk";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getSdkKey";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findSdkByKey";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isLocalSdk";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "activateVirtualEnv";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showCustomCreateUI$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

