/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ui.JBUI;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.pipenv.PipenvKt;
import java.awt.Component;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u001b\u0012\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J:\u0010\u000b\u001a\u00020\t2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0014J<\u0010\u0014\u001a\u00020\u00152\u0010\u0010\f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/python/sdk/PySdkListCellRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "", "sdkModifiers", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "Lcom/intellij/openapi/projectRoots/SdkModificator;", "(Ljava/util/Map;)V", "appendName", "", "sdk", "customizeCellRenderer", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "getListCellRendererComponent", "Ljava/awt/Component;", "Companion", "intellij.python.community.impl"})
public class PySdkListCellRenderer
extends ColoredListCellRenderer<Object> {
    private final Map<Sdk, SdkModificator> sdkModifiers;
    @NotNull
    public static final String SEPARATOR = "separator";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Component getListCellRendererComponent(@Nullable JList<? extends Object> list2, @Nullable Object value, int index, boolean selected, boolean hasFocus) {
        Component component;
        Object object = value;
        if (Intrinsics.areEqual((Object)object, (Object)SEPARATOR)) {
            TitledSeparator titledSeparator;
            TitledSeparator $receiver = titledSeparator = new TitledSeparator(null);
            $receiver.setBorder((Border)JBUI.Borders.empty());
            component = (Component)titledSeparator;
        } else {
            Component component2 = super.getListCellRendererComponent(list2, value, index, selected, hasFocus);
            component = component2;
            Intrinsics.checkExpressionValueIsNotNull((Object)component2, (String)"super.getListCellRendere\u2026ndex, selected, hasFocus)");
        }
        return component;
    }

    protected void customizeCellRenderer(@NotNull JList<? extends Object> list2, @Nullable Object value, int index, boolean selected, boolean hasFocus) {
        Intrinsics.checkParameterIsNotNull(list2, (String)"list");
        Object object = value;
        if (object instanceof Sdk) {
            this.appendName((Sdk)value);
            this.setIcon(PySdkListCellRenderer.Companion.customizeIcon((Sdk)value));
        } else if (object instanceof String) {
            Intrinsics.checkExpressionValueIsNotNull((Object)this.append((String)value), (String)"append(value)");
        } else if (object == null) {
            Intrinsics.checkExpressionValueIsNotNull((Object)this.append("<No interpreter>"), (String)"append(\"<No interpreter>\")");
        }
    }

    private final void appendName(Sdk sdk) {
        String relHomePath;
        String string;
        String homePath;
        Object object = this.sdkModifiers;
        if (object == null || (object = object.get(sdk)) == null || (object = object.getName()) == null) {
            String string2 = sdk.getName();
            object = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sdk.name");
        }
        Object name = object;
        if (PythonSdkType.isInvalid(sdk) || PythonSdkType.hasInvalidRemoteCredentials(sdk)) {
            this.append("[invalid] " + (String)name, SimpleTextAttributes.ERROR_ATTRIBUTES);
        } else if (PythonSdkType.isIncompleteRemote(sdk)) {
            this.append("[incomplete] " + (String)name, SimpleTextAttributes.ERROR_ATTRIBUTES);
        } else if (!LanguageLevel.SUPPORTED_LEVELS.contains((Object)PythonSdkType.getLanguageLevelForSdk(sdk))) {
            this.append("[unsupported] " + (String)name, SimpleTextAttributes.ERROR_ATTRIBUTES);
        } else {
            Intrinsics.checkExpressionValueIsNotNull((Object)this.append((String)name), (String)"append(name)");
        }
        if (PipenvKt.isPipEnv(sdk)) {
            String string3 = sdk.getVersionString();
            if (string3 != null) {
                String string4;
                String it = string4 = string3;
                this.append(' ' + it, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
            }
        }
        String string5 = homePath = sdk.getHomePath();
        if (string5 != null) {
            String string6;
            String it = string6 = string5;
            string = FileUtil.getLocationRelativeToUserHome((String)it);
        } else {
            string = relHomePath = null;
        }
        if (relHomePath != null && !StringsKt.contains$default((CharSequence)((CharSequence)name), (CharSequence)homePath, (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)((CharSequence)name), (CharSequence)relHomePath, (boolean)false, (int)2, null)) {
            this.append(' ' + relHomePath, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        }
    }

    public PySdkListCellRenderer(@Nullable Map<Sdk, ? extends SdkModificator> sdkModifiers) {
        this.sdkModifiers = sdkModifiers;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/sdk/PySdkListCellRenderer$Companion;", "", "()V", "SEPARATOR", "", "customizeIcon", "Ljavax/swing/Icon;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "wrapIconWithWarningDecorator", "Lcom/intellij/ui/LayeredIcon;", "icon", "intellij.python.community.impl"})
    public static final class Companion {
        private final Icon customizeIcon(Sdk sdk) {
            Icon icon;
            Icon icon2;
            PythonSdkFlavor flavor = PythonSdkFlavor.getPlatformIndependentFlavor(sdk.getHomePath());
            if (flavor != null) {
                icon2 = flavor.getIcon();
            } else {
                SdkTypeId sdkTypeId = sdk.getSdkType();
                if (!(sdkTypeId instanceof SdkType)) {
                    sdkTypeId = null;
                }
                if ((icon2 = (SdkType)sdkTypeId) == null || (icon2 = icon2.getIcon()) == null) {
                    return null;
                }
            }
            Icon icon3 = icon2;
            if (PythonSdkType.isInvalid(sdk) || PythonSdkType.isIncompleteRemote(sdk) || PythonSdkType.hasInvalidRemoteCredentials(sdk) || !LanguageLevel.SUPPORTED_LEVELS.contains((Object)PythonSdkType.getLanguageLevelForSdk(sdk))) {
                Icon icon4 = icon3;
                Intrinsics.checkExpressionValueIsNotNull((Object)icon4, (String)"icon");
                icon = (Icon)this.wrapIconWithWarningDecorator(icon4);
            } else {
                icon = sdk instanceof PyDetectedSdk ? IconLoader.getTransparentIcon((Icon)icon3) : (PipenvKt.isPipEnv(sdk) ? PipenvKt.getPIPENV_ICON() : icon3);
            }
            return icon;
        }

        private final LayeredIcon wrapIconWithWarningDecorator(Icon icon) {
            LayeredIcon layeredIcon;
            LayeredIcon $receiver = layeredIcon = new LayeredIcon(2);
            $receiver.setIcon(icon, 0);
            $receiver.setIcon(AllIcons.Actions.Cancel, 1);
            return layeredIcon;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

