/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.changeSignature;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialogBase;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.VisibilityPanelBase;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.EditorTextFieldJBTableRowRenderer;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.refactoring.changeSignature.PyChangeSignatureProcessor;
import com.jetbrains.python.refactoring.changeSignature.PyMethodDescriptor;
import com.jetbrains.python.refactoring.changeSignature.PyParameterInfo;
import com.jetbrains.python.refactoring.changeSignature.PyParameterTableModel;
import com.jetbrains.python.refactoring.changeSignature.PyParameterTableModelItem;
import com.jetbrains.python.refactoring.introduce.IntroduceValidator;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyChangeSignatureDialog
extends ChangeSignatureDialogBase<PyParameterInfo, PyFunction, String, PyMethodDescriptor, PyParameterTableModelItem, PyParameterTableModel> {
    public PyChangeSignatureDialog(Project project, PyMethodDescriptor method) {
        super(project, method, false, method.getMethod().getContext());
    }

    @Override
    protected LanguageFileType getFileType() {
        return PythonFileType.INSTANCE;
    }

    @Override
    @NotNull
    protected PyParameterTableModel createParametersInfoModel(@NotNull PyMethodDescriptor method) {
        if (method == null) {
            PyChangeSignatureDialog.$$$reportNull$$$0(0);
        }
        PyParameterList parameterList = (PyParameterList)PsiTreeUtil.getChildOfType((PsiElement)method.getMethod(), PyParameterList.class);
        PyParameterTableModel pyParameterTableModel = new PyParameterTableModel(parameterList, this.myDefaultValueContext, this.myProject);
        if (pyParameterTableModel == null) {
            PyChangeSignatureDialog.$$$reportNull$$$0(1);
        }
        return pyParameterTableModel;
    }

    @Override
    public BaseRefactoringProcessor createRefactoringProcessor() {
        List parameters2 = this.getParameters();
        return new PyChangeSignatureProcessor(this.myProject, ((PyMethodDescriptor)this.myMethod).getMethod(), this.getMethodName(), parameters2.toArray(new PyParameterInfo[0]));
    }

    @Override
    @Nullable
    protected PsiCodeFragment createReturnTypeCodeFragment() {
        return null;
    }

    @Override
    @Nullable
    protected CallerChooserBase<PyFunction> createCallerChooser(String title, Tree treeToReuse, Consumer<Set<PyFunction>> callback2) {
        return null;
    }

    public boolean isNameValid(String name, Project project) {
        NamesValidator validator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)PythonLanguage.getInstance());
        return name != null && validator.isIdentifier(name, project) && !validator.isKeyword(name, project);
    }

    @Override
    @Nullable
    protected String validateAndCommitData() {
        String functionName = this.myNameField.getText().trim();
        if (!functionName.equals(((PyMethodDescriptor)this.myMethod).getName())) {
            boolean defined = IntroduceValidator.isDefinedInScope(functionName, ((PyMethodDescriptor)this.myMethod).getMethod());
            if (defined) {
                return PyBundle.message("refactoring.change.signature.dialog.validation.name.defined", new Object[0]);
            }
            if (!this.isNameValid(functionName, this.myProject)) {
                return PyBundle.message("refactoring.change.signature.dialog.validation.function.name", new Object[0]);
            }
        }
        List parameters2 = ((PyParameterTableModel)this.myParametersTableModel).getItems();
        HashSet<String> parameterNames = new HashSet<String>();
        boolean hadPositionalContainer = false;
        boolean hadKeywordContainer = false;
        boolean hadDefaultValue = false;
        boolean hadSingleStar = false;
        boolean hadParamsAfterSingleStar = false;
        LanguageLevel languageLevel = LanguageLevel.forElement(((PyMethodDescriptor)this.myMethod).getMethod());
        int parametersLength = parameters2.size();
        for (int index = 0; index < parametersLength; ++index) {
            PyParameterTableModelItem info = (PyParameterTableModelItem)parameters2.get(index);
            PyParameterInfo parameter = (PyParameterInfo)info.parameter;
            String name = parameter.getName();
            String nameWithoutStars = StringUtil.trimLeading((String)name, (char)'*').trim();
            if (parameterNames.contains(nameWithoutStars)) {
                return PyBundle.message("ANN.duplicate.param.name", new Object[0]);
            }
            parameterNames.add(nameWithoutStars);
            if (name.equals("*")) {
                hadSingleStar = true;
                if (index == parametersLength - 1) {
                    return PyBundle.message("ANN.named.parameters.after.star", new Object[0]);
                }
            } else if (name.startsWith("*") && !name.startsWith("**")) {
                if (hadKeywordContainer) {
                    return PyBundle.message("ANN.starred.param.after.kwparam", new Object[0]);
                }
                if (hadSingleStar || hadPositionalContainer) {
                    return PyBundle.message("refactoring.change.signature.dialog.validation.multiple.star", new Object[0]);
                }
                if (!this.isNameValid(name.substring(1), this.myProject)) {
                    return PyBundle.message("refactoring.change.signature.dialog.validation.parameter.name", new Object[0]);
                }
                hadPositionalContainer = true;
            } else if (name.startsWith("**")) {
                if (hadSingleStar && !hadParamsAfterSingleStar) {
                    return PyBundle.message("ANN.named.parameters.after.star", new Object[0]);
                }
                if (hadKeywordContainer) {
                    return PyBundle.message("refactoring.change.signature.dialog.validation.multiple.double.star", new Object[0]);
                }
                if (!this.isNameValid(name.substring(2), this.myProject)) {
                    return PyBundle.message("refactoring.change.signature.dialog.validation.parameter.name", new Object[0]);
                }
                hadKeywordContainer = true;
            } else {
                if (!this.isNameValid(name, this.myProject)) {
                    return PyBundle.message("refactoring.change.signature.dialog.validation.parameter.name", new Object[0]);
                }
                if (hadSingleStar) {
                    hadParamsAfterSingleStar = true;
                }
                if (hadPositionalContainer && languageLevel.isPython2()) {
                    return PyBundle.message("ANN.regular.param.after.vararg", new Object[0]);
                }
                if (hadKeywordContainer) {
                    return PyBundle.message("ANN.regular.param.after.keyword", new Object[0]);
                }
                String defaultValue = info.getDefaultValue();
                if (defaultValue != null && !StringUtil.isEmptyOrSpaces((String)defaultValue) && parameter.getDefaultInSignature()) {
                    hadDefaultValue = true;
                } else if (hadDefaultValue && !hadSingleStar && (languageLevel.isPython2() || !hadPositionalContainer)) {
                    return PyBundle.message("ANN.non.default.param.after.default", new Object[0]);
                }
            }
            if (parameter.getOldIndex() < 0) {
                if (parameter.getName().startsWith("*")) continue;
                if (StringUtil.isEmpty((String)info.defaultValueCodeFragment.getText())) {
                    return PyBundle.message("refactoring.change.signature.dialog.validation.default.missing", new Object[0]);
                }
                if (!StringUtil.isEmptyOrSpaces((String)parameter.getName())) continue;
                return PyBundle.message("refactoring.change.signature.dialog.validation.parameter.missing", new Object[0]);
            }
            if (!((PyMethodDescriptor)this.myMethod).getParameters().get(parameter.getOldIndex()).getDefaultInSignature() || !StringUtil.isEmptyOrSpaces((String)parameter.getDefaultValue())) continue;
            return PyBundle.message("refactoring.change.signature.dialog.validation.default.missing", new Object[0]);
        }
        return null;
    }

    protected ValidationInfo doValidate() {
        String message = this.validateAndCommitData();
        this.getRefactorAction().setEnabled(message == null);
        this.getPreviewAction().setEnabled(message == null);
        if (message != null) {
            return new ValidationInfo(message);
        }
        return super.doValidate();
    }

    @Override
    protected String calculateSignature() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append(this.getMethodName());
        builder2.append("(");
        List parameters2 = ((PyParameterTableModel)this.myParametersTableModel).getItems();
        for (int i = 0; i < parameters2.size(); ++i) {
            PyParameterTableModelItem parameterInfo = (PyParameterTableModelItem)parameters2.get(i);
            builder2.append(((PyParameterInfo)parameterInfo.parameter).getName());
            String defaultValue = parameterInfo.defaultValueCodeFragment.getText();
            if (!defaultValue.isEmpty() && parameterInfo.isDefaultInSignature()) {
                builder2.append(" = ").append(defaultValue);
            }
            if (i == parameters2.size() - 1) continue;
            builder2.append(", ");
        }
        builder2.append(")");
        return builder2.toString();
    }

    @Override
    protected VisibilityPanelBase<String> createVisibilityControl() {
        return new ComboBoxVisibilityPanel<String>(ArrayUtil.EMPTY_STRING_ARRAY);
    }

    @Override
    protected ChangeSignatureDialogBase.ParametersListTable createParametersListTable() {
        return new ChangeSignatureDialogBase.ParametersListTable(){

            @Override
            protected JBTableRowRenderer getRowRenderer(int row) {
                return new EditorTextFieldJBTableRowRenderer(PyChangeSignatureDialog.this.getProject(), (FileType)PyChangeSignatureDialog.this.getFileType(), PyChangeSignatureDialog.this.getDisposable()){

                    @Override
                    protected String getText(JTable table, int row) {
                        String defaultValue;
                        PyParameterTableModelItem pyItem = (PyParameterTableModelItem)this.getRowItem(row);
                        StringBuilder text2 = new StringBuilder(((PyParameterInfo)pyItem.parameter).getName());
                        String defaultCallValue = pyItem.defaultValueCodeFragment.getText();
                        String string = defaultValue = pyItem.isDefaultInSignature() ? pyItem.defaultValueCodeFragment.getText() : "";
                        if (StringUtil.isNotEmpty((String)defaultValue)) {
                            text2.append(" = ").append(defaultValue);
                        }
                        if (StringUtil.isNotEmpty((String)defaultCallValue)) {
                            text2.append(" // default value = ").append(defaultCallValue);
                        }
                        return text2.toString();
                    }
                };
            }

            @NotNull
            protected JBTableRowEditor getRowEditor(final ParameterTableModelItemBase<PyParameterInfo> item) {
                JBTableRowEditor jBTableRowEditor = new JBTableRowEditor(){
                    private EditorTextField myNameEditor;
                    private EditorTextField myDefaultValueEditor;
                    private JCheckBox myDefaultInSignature;

                    @Override
                    public void prepareEditor(JTable table, int row) {
                        this.setLayout(new GridLayout(1, 3));
                        JPanel parameterPanel = this.createParameterPanel();
                        this.add(parameterPanel);
                        JPanel defaultValuePanel = this.createDefaultValuePanel();
                        this.add(defaultValuePanel);
                        JPanel defaultValueCheckBox = this.createDefaultValueCheckBox();
                        this.add(defaultValueCheckBox);
                        String nameText = this.myNameEditor.getText();
                        this.myDefaultValueEditor.setEnabled(!nameText.startsWith("*") && !"self".equals(nameText));
                        this.myDefaultInSignature.setEnabled(!nameText.startsWith("*") && !"self".equals(nameText));
                    }

                    private JPanel createDefaultValueCheckBox() {
                        JPanel defaultValuePanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 4, 2, true, false));
                        JBLabel inSignatureLabel = new JBLabel(PyBundle.message("refactoring.change.signature.dialog.default.value.checkbox", new Object[0]), UIUtil.ComponentStyle.SMALL);
                        IJSwingUtilities.adjustComponentsOnMac((JLabel)inSignatureLabel, this.myDefaultInSignature);
                        defaultValuePanel.add((Component)inSignatureLabel, "West");
                        this.myDefaultInSignature = new JCheckBox();
                        this.myDefaultInSignature.setSelected(((PyParameterTableModelItem)item).isDefaultInSignature());
                        this.myDefaultInSignature.addItemListener(new ItemListener(){

                            @Override
                            public void itemStateChanged(ItemEvent event) {
                                ((PyParameterTableModelItem)item).setDefaultInSignature(myDefaultInSignature.isSelected());
                            }
                        });
                        this.myDefaultInSignature.addChangeListener(PyChangeSignatureDialog.this.mySignatureUpdater);
                        this.myDefaultInSignature.setEnabled(((PyParameterInfo)item.parameter).getOldIndex() == -1);
                        defaultValuePanel.add((Component)this.myDefaultInSignature, "East");
                        return defaultValuePanel;
                    }

                    private JPanel createDefaultValuePanel() {
                        JPanel defaultValuePanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 4, 2, true, false));
                        Document doc = PsiDocumentManager.getInstance((Project)PyChangeSignatureDialog.this.getProject()).getDocument((PsiFile)item.defaultValueCodeFragment);
                        this.myDefaultValueEditor = new EditorTextField(doc, PyChangeSignatureDialog.this.getProject(), (FileType)PyChangeSignatureDialog.this.getFileType());
                        JBLabel defaultValueLabel = new JBLabel(PyBundle.message("refactoring.change.signature.dialog.default.value.label", new Object[0]), UIUtil.ComponentStyle.SMALL);
                        IJSwingUtilities.adjustComponentsOnMac((JLabel)defaultValueLabel, (JComponent)((Object)this.myDefaultValueEditor));
                        defaultValuePanel.add((Component)defaultValueLabel);
                        defaultValuePanel.add((Component)((Object)this.myDefaultValueEditor));
                        this.myDefaultValueEditor.setPreferredWidth(this.getTable().getWidth() / 2);
                        this.myDefaultValueEditor.addDocumentListener(PyChangeSignatureDialog.this.mySignatureUpdater);
                        return defaultValuePanel;
                    }

                    private JPanel createParameterPanel() {
                        JPanel namePanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 4, 2, true, false));
                        this.myNameEditor = new EditorTextField(((PyParameterInfo)item.parameter).getName(), PyChangeSignatureDialog.this.getProject(), (FileType)PyChangeSignatureDialog.this.getFileType());
                        JBLabel nameLabel = new JBLabel(PyBundle.message("refactoring.change.signature.dialog.name.label", new Object[0]), UIUtil.ComponentStyle.SMALL);
                        IJSwingUtilities.adjustComponentsOnMac((JLabel)nameLabel, (JComponent)((Object)this.myNameEditor));
                        namePanel.add((Component)nameLabel);
                        namePanel.add((Component)((Object)this.myNameEditor));
                        this.myNameEditor.setPreferredWidth(this.getTable().getWidth() / 2);
                        this.myNameEditor.addDocumentListener(new DocumentListener(){

                            public void documentChanged(DocumentEvent event) {
                                this.fireDocumentChanged(event, 0);
                                myDefaultValueEditor.setEnabled(!myNameEditor.getText().startsWith("*"));
                                myDefaultInSignature.setEnabled(!myNameEditor.getText().startsWith("*"));
                            }
                        });
                        this.myNameEditor.addDocumentListener(PyChangeSignatureDialog.this.mySignatureUpdater);
                        return namePanel;
                    }

                    @Override
                    public JBTableRow getValue() {
                        return new JBTableRow(){

                            @Override
                            public Object getValueAt(int column) {
                                switch (column) {
                                    case 0: {
                                        return myNameEditor.getText().trim();
                                    }
                                    case 1: {
                                        return new Pair((Object)item.defaultValueCodeFragment, (Object)((PyParameterTableModelItem)item).isDefaultInSignature());
                                    }
                                }
                                return null;
                            }
                        };
                    }

                    @Override
                    public JComponent getPreferredFocusedComponent() {
                        return this.myNameEditor.getFocusTarget();
                    }

                    @Override
                    public JComponent[] getFocusableComponents() {
                        ArrayList<JComponent> focusable = new ArrayList<JComponent>();
                        focusable.add(this.myNameEditor.getFocusTarget());
                        if (this.myDefaultValueEditor != null) {
                            focusable.add(this.myDefaultValueEditor.getFocusTarget());
                        }
                        if (this.myDefaultInSignature != null) {
                            focusable.add(this.myDefaultInSignature);
                        }
                        return focusable.toArray(new JComponent[0]);
                    }
                };
                if (jBTableRowEditor == null) {
                    1.$$$reportNull$$$0(0);
                }
                return jBTableRowEditor;
            }

            @Override
            protected boolean isRowEmpty(int row) {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/changeSignature/PyChangeSignatureDialog$1", "getRowEditor"));
            }
        };
    }

    @Override
    protected boolean isListTableViewSupported() {
        return true;
    }

    @Override
    protected boolean mayPropagateParameters() {
        return false;
    }

    protected boolean postponeValidation() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/changeSignature/PyChangeSignatureDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/changeSignature/PyChangeSignatureDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createParametersInfoModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createParametersInfoModel";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

