/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SortedSetMultimap;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.packaging.PyCondaPackageCache;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.CondaEnvSdkFlavor;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;

@State(name="PyCondaPackageService", storages={@Storage(value="conda_packages.xml", roamingType=RoamingType.DISABLED)})
public class PyCondaPackageService
implements PersistentStateComponent<PyCondaPackageService> {
    private static final Logger LOG = Logger.getInstance(PyCondaPackageService.class);
    public Set<String> CONDA_CHANNELS = ContainerUtil.newConcurrentSet();
    public long LAST_TIME_CHECKED = 0L;
    @Nullable
    public @SystemDependent String PREFERRED_CONDA_PATH = null;

    public PyCondaPackageService getState() {
        return this;
    }

    public void loadState(@NotNull PyCondaPackageService state2) {
        if (state2 == null) {
            PyCondaPackageService.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean((Object)state2, (Object)this);
    }

    public static PyCondaPackageService getInstance() {
        return (PyCondaPackageService)ServiceManager.getService(PyCondaPackageService.class);
    }

    public void loadAndGetPackages(boolean force) {
        if (PyCondaPackageCache.getInstance().getPackageNames().isEmpty() || force) {
            this.updatePackagesCache();
        }
    }

    public Set<String> loadAndGetChannels() {
        if (this.CONDA_CHANNELS.isEmpty()) {
            this.updateChannels();
        }
        return this.CONDA_CHANNELS;
    }

    public void addChannel(@NotNull String url) {
        if (url == null) {
            PyCondaPackageService.$$$reportNull$$$0(1);
        }
        this.CONDA_CHANNELS.add(url);
    }

    public void removeChannel(@NotNull String url) {
        if (url == null) {
            PyCondaPackageService.$$$reportNull$$$0(2);
        }
        if (this.CONDA_CHANNELS.contains(url)) {
            this.CONDA_CHANNELS.remove(url);
        }
    }

    @Nullable
    public static String getCondaPython() {
        VirtualFile condaDir;
        VirtualFile python;
        VirtualFile condaFile;
        String pythonName;
        String conda = PyCondaPackageService.getSystemCondaExecutable();
        String string = pythonName = SystemInfo.isWindows ? "python.exe" : "python";
        if (conda != null && (condaFile = LocalFileSystem.getInstance().findFileByPath(conda)) != null && (python = (condaDir = condaFile.getParent().getParent()).findChild(pythonName)) != null) {
            return python.getPath();
        }
        return PyCondaPackageService.getCondaExecutable(pythonName);
    }

    @Nullable
    public static String getSystemCondaExecutable() {
        String condaName = SystemInfo.isWindows ? "conda.exe" : "conda";
        File condaInPath = PathEnvironmentVariableUtil.findInPath((String)condaName);
        if (condaInPath != null) {
            return condaInPath.getPath();
        }
        return PyCondaPackageService.getCondaExecutable(condaName);
    }

    @Nullable
    public static String getCondaExecutable(VirtualFile sdkPath) {
        VirtualFile conda;
        VirtualFile bin = sdkPath.getParent();
        String condaName = "conda";
        if (SystemInfo.isWindows) {
            String string = condaName = bin.findChild("envs") != null ? "conda.exe" : "conda.bat";
        }
        if ((conda = bin.findChild(condaName)) != null) {
            return conda.getPath();
        }
        VirtualFile condaFolder = bin.getParent();
        String condaPath = PyCondaPackageService.findExecutable(condaName, condaFolder);
        if (condaPath != null) {
            return condaPath;
        }
        return PyCondaPackageService.getSystemCondaExecutable();
    }

    @Nullable
    public static String getCondaExecutable(@NotNull String condaName) {
        VirtualFile userHome;
        if (condaName == null) {
            PyCondaPackageService.$$$reportNull$$$0(3);
        }
        if ((userHome = LocalFileSystem.getInstance().findFileByPath(SystemProperties.getUserHome().replace('\\', '/'))) != null) {
            for (String root : CondaEnvSdkFlavor.CONDA_DEFAULT_ROOTS) {
                VirtualFile condaFolder = userHome.findChild(root);
                String executableFile = PyCondaPackageService.findExecutable(condaName, condaFolder);
                if (executableFile != null) {
                    return executableFile;
                }
                if (SystemInfo.isWindows) {
                    VirtualFile appData = userHome.findFileByRelativePath("AppData\\Local\\Continuum\\" + root);
                    executableFile = PyCondaPackageService.findExecutable(condaName, appData);
                    if (executableFile != null) {
                        return executableFile;
                    }
                    condaFolder = LocalFileSystem.getInstance().findFileByPath("C:\\" + root);
                    executableFile = PyCondaPackageService.findExecutable(condaName, condaFolder);
                    if (executableFile == null) continue;
                    return executableFile;
                }
                String systemWidePath = "/opt/anaconda";
                condaFolder = LocalFileSystem.getInstance().findFileByPath("/opt/anaconda");
                executableFile = PyCondaPackageService.findExecutable(condaName, condaFolder);
                if (executableFile == null) continue;
                return executableFile;
            }
        }
        return null;
    }

    @Nullable
    private static String findExecutable(String condaName, @Nullable VirtualFile condaFolder) {
        String directoryPath2;
        String executableFile;
        VirtualFile bin;
        VirtualFile binFolder;
        if (condaFolder != null && (binFolder = condaFolder.findChild(SystemInfo.isWindows ? "Scripts" : "bin")) != null && (bin = binFolder.findChild(condaName)) != null && (executableFile = PythonSdkType.getExecutablePath(directoryPath2 = bin.getPath(), condaName)) != null) {
            return executableFile;
        }
        return null;
    }

    public void updatePackagesCache() {
        String condaPython = PyCondaPackageService.getCondaPython();
        if (condaPython == null) {
            return;
        }
        String path = PythonHelpersLocator.getHelperPath("conda_packaging_tool.py");
        String runDirectory = new File(condaPython).getParent();
        String[] command = new String[]{condaPython, path, "listall"};
        ProcessOutput output = PySdkUtil.getProcessOutput(runDirectory, command);
        if (output.getExitCode() != 0) {
            LOG.warn("Failed to get list of conda packages");
            LOG.warn(StringUtil.join((String[])command, (String)" "));
            LOG.warn(output.getStderr());
            return;
        }
        SortedSetMultimap nameToVersions = Multimaps.newSortedSetMultimap(new HashMap(), () -> new TreeSet(VersionComparatorUtil.COMPARATOR.reversed()));
        for (String line : output.getStdoutLines()) {
            List split = StringUtil.split((String)line, (String)"\t");
            if (split.size() < 2) continue;
            nameToVersions.put(split.get(0), split.get(1));
        }
        PyCondaPackageCache.reload((Multimap<String, String>)nameToVersions);
        this.LAST_TIME_CHECKED = System.currentTimeMillis();
    }

    @NotNull
    public List<String> getPackageVersions(@NotNull String packageName) {
        if (packageName == null) {
            PyCondaPackageService.$$$reportNull$$$0(4);
        }
        List list2 = ContainerUtil.notNullize(PyCondaPackageCache.getInstance().getVersions(packageName));
        if (list2 == null) {
            PyCondaPackageService.$$$reportNull$$$0(5);
        }
        return list2;
    }

    public void updateChannels() {
        String condaPython = PyCondaPackageService.getCondaPython();
        if (condaPython == null) {
            return;
        }
        String path = PythonHelpersLocator.getHelperPath("conda_packaging_tool.py");
        String runDirectory = new File(condaPython).getParent();
        ProcessOutput output = PySdkUtil.getProcessOutput(runDirectory, new String[]{condaPython, path, "channels"});
        if (output.getExitCode() != 0) {
            return;
        }
        List lines2 = output.getStdoutLines();
        this.CONDA_CHANNELS.addAll(lines2);
        this.LAST_TIME_CHECKED = System.currentTimeMillis();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condaName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyCondaPackageService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyCondaPackageService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageVersions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addChannel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeChannel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCondaExecutable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPackageVersions";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

