/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.nameResolver;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiCacheKey;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Function;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NameResolverTools {
    private static final PsiCacheKey<Pair<String, String>, PyElement> QUALIFIED_AND_CLASS_NAME = PsiCacheKey.create((String)NameResolverTools.class.getName(), (Function)new QualifiedAndClassNameObtainer(), (Key)PsiModificationTracker.MODIFICATION_COUNT);

    private NameResolverTools() {
    }

    public static boolean isElementWithName(@NotNull Collection<? extends PyElement> elements, FQNamesProvider ... namesProviders) {
        if (elements == null) {
            NameResolverTools.$$$reportNull$$$0(0);
        }
        if (namesProviders == null) {
            NameResolverTools.$$$reportNull$$$0(1);
        }
        for (PyElement pyElement : elements) {
            if (!NameResolverTools.isName(pyElement, namesProviders)) continue;
            return true;
        }
        return false;
    }

    public static boolean isName(@NotNull PyElement element, FQNamesProvider ... namesProviders) {
        if (element == null) {
            NameResolverTools.$$$reportNull$$$0(2);
        }
        if (namesProviders == null) {
            NameResolverTools.$$$reportNull$$$0(3);
        }
        assert (element.isValid());
        Pair qualifiedAndClassName = (Pair)QUALIFIED_AND_CLASS_NAME.getValue((PsiElement)element);
        String qualifiedName = (String)qualifiedAndClassName.first;
        String className = (String)qualifiedAndClassName.second;
        for (FQNamesProvider provider : namesProviders) {
            List<String> names = Arrays.asList(provider.getNames());
            if (qualifiedName != null && names.contains(qualifiedName)) {
                return true;
            }
            if (className == null || !provider.isClass() || !names.contains(className)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PyCallExpression findCallExpParent(@NotNull PsiElement anchor2, @NotNull FQNamesProvider functionName) {
        PsiElement parent;
        if (anchor2 == null) {
            NameResolverTools.$$$reportNull$$$0(4);
        }
        if (functionName == null) {
            NameResolverTools.$$$reportNull$$$0(5);
        }
        if ((parent = PsiTreeUtil.findFirstParent((PsiElement)anchor2, (Condition)new MyFunctionCondition(functionName))) instanceof PyCallExpression) {
            return (PyCallExpression)parent;
        }
        return null;
    }

    public static boolean isCalleeShortCut(@NotNull PyCallExpression call, @NotNull FQNamesProvider function) {
        PyExpression callee;
        if (call == null) {
            NameResolverTools.$$$reportNull$$$0(6);
        }
        if (function == null) {
            NameResolverTools.$$$reportNull$$$0(7);
        }
        if ((callee = call.getCallee()) == null) {
            return false;
        }
        String callableName = callee.getName();
        LinkedList<String> possibleNames = new LinkedList<String>();
        for (String lastComponent : NameResolverTools.getLastComponents(function)) {
            possibleNames.add(lastComponent);
        }
        return possibleNames.contains(callableName) && call.isCallee(function);
    }

    @NotNull
    private static List<String> getLastComponents(@NotNull FQNamesProvider provider) {
        if (provider == null) {
            NameResolverTools.$$$reportNull$$$0(8);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (String name : provider.getNames()) {
            String component = QualifiedName.fromDottedString((String)name).getLastComponent();
            if (component == null) continue;
            result2.add(component);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            NameResolverTools.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public static boolean isContainsName(@NotNull String text2, @NotNull FQNamesProvider names) {
        if (text2 == null) {
            NameResolverTools.$$$reportNull$$$0(10);
        }
        if (names == null) {
            NameResolverTools.$$$reportNull$$$0(11);
        }
        for (String lastComponent : NameResolverTools.getLastComponents(names)) {
            if (!text2.contains(lastComponent)) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainsName(@NotNull PsiFile file2, @NotNull FQNamesProvider names) {
        if (file2 == null) {
            NameResolverTools.$$$reportNull$$$0(12);
        }
        if (names == null) {
            NameResolverTools.$$$reportNull$$$0(13);
        }
        return NameResolverTools.isContainsName(file2.getText(), names);
    }

    public static boolean isSubclass(@NotNull PyClass child, @NotNull FQNamesProvider parentName, @NotNull TypeEvalContext context) {
        if (child == null) {
            NameResolverTools.$$$reportNull$$$0(14);
        }
        if (parentName == null) {
            NameResolverTools.$$$reportNull$$$0(15);
        }
        if (context == null) {
            NameResolverTools.$$$reportNull$$$0(16);
        }
        for (String nameToCheck : parentName.getNames()) {
            if (!child.isSubclass(nameToCheck, context)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesProviders";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/nameResolver/NameResolverTools";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/nameResolver/NameResolverTools";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isElementWithName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCallExpParent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCalleeShortCut";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLastComponents";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isContainsName";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isSubclass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class QualifiedAndClassNameObtainer
    implements Function<PyElement, Pair<String, String>> {
        private QualifiedAndClassNameObtainer() {
        }

        @NotNull
        public Pair<String, String> fun(@NotNull PyElement param) {
            PyClass aClass;
            PsiElement resolvedElement;
            if (param == null) {
                QualifiedAndClassNameObtainer.$$$reportNull$$$0(0);
            }
            PyElement elementToCheck = param;
            Object reference = param instanceof PyReferenceOwner ? ((PyReferenceOwner)param).getReference(PyResolveContext.noImplicits()) : param.getReference();
            if (reference != null && (resolvedElement = reference.resolve()) instanceof PyElement) {
                elementToCheck = (PyElement)resolvedElement;
            }
            String qualifiedName = null;
            if (elementToCheck instanceof PyQualifiedNameOwner) {
                qualifiedName = ((PyQualifiedNameOwner)elementToCheck).getQualifiedName();
            }
            String className = null;
            if (elementToCheck instanceof PyFunction && (aClass = ((PyFunction)elementToCheck).getContainingClass()) != null) {
                className = aClass.getQualifiedName();
            }
            Pair pair = Pair.create((Object)qualifiedName, className);
            if (pair == null) {
                QualifiedAndClassNameObtainer.$$$reportNull$$$0(1);
            }
            return pair;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "param";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/nameResolver/NameResolverTools$QualifiedAndClassNameObtainer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/nameResolver/NameResolverTools$QualifiedAndClassNameObtainer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fun";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fun";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyFunctionCondition
    implements Condition<PsiElement> {
        @NotNull
        private final FQNamesProvider myNameToSearch;

        MyFunctionCondition(@NotNull FQNamesProvider name) {
            if (name == null) {
                MyFunctionCondition.$$$reportNull$$$0(0);
            }
            this.myNameToSearch = name;
        }

        public boolean value(PsiElement element) {
            if (element instanceof PyCallExpression) {
                return ((PyCallExpression)element).isCallee(this.myNameToSearch);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/nameResolver/NameResolverTools$MyFunctionCondition", "<init>"));
        }
    }
}

