/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.python.toolbox.ChainIterable;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class DocumentationBuilderKit {
    static final TagWrapper TagBold = new TagWrapper("b");
    static final TagWrapper TagSmall = new TagWrapper("small");
    static final TagWrapper TagCode = new TagWrapper("code");
    static final TagWrapper TagSpan = new TagWrapper("span");
    @NonNls
    public static final String BR = "<br>";
    @NotNull
    static final Function<String, String> ESCAPE_ONLY = StringUtil::escapeXml;
    @NotNull
    static final Function<String, String> TO_ONE_LINE_AND_ESCAPE = s -> ESCAPE_ONLY.apply(s.replace('\n', ' '));
    @NotNull
    static final Function<String, String> ESCAPE_AND_SAVE_NEW_LINES_AND_SPACES = s -> ESCAPE_ONLY.apply((String)s).replace("\n", BR).replace(" ", "&nbsp;");
    @NotNull
    static final Function<String, String> WRAP_IN_ITALIC = s -> "<i>" + s + "</i>";
    @NotNull
    static final Function<String, String> WRAP_IN_BOLD = s -> "<b>" + s + "</b>";

    private DocumentationBuilderKit() {
    }

    static ChainIterable<String> wrapInTag(String tag, Iterable<String> content) {
        return new ChainIterable<String>("<" + tag + ">").add(content).addItem("</" + tag + ">");
    }

    static ChainIterable<String> wrapInTag(String tag, List<Pair<String, String>> attributes, Iterable<String> content) {
        if (attributes.size() == 0) {
            return DocumentationBuilderKit.wrapInTag(tag, content);
        }
        StringBuilder s = new StringBuilder("<" + tag);
        for (Pair<String, String> attr : attributes) {
            s.append(" ").append((String)attr.first).append("=\"").append((String)attr.second).append("\"");
        }
        s.append(">");
        return new ChainIterable<String>(s.toString()).add(content).addItem("</" + tag + ">");
    }

    @NonNls
    static String combUp(@NonNls String what) {
        return XmlStringUtil.escapeString((String)what).replace("\n", BR).replace(" ", "&nbsp;");
    }

    static ChainIterable<String> $(String ... content) {
        return new ChainIterable<List<String>>(Arrays.asList(content));
    }

    static class TagWrapper
    implements Function<Iterable<String>, Iterable<String>> {
        private final String myTag;
        private final List<Pair<String, String>> myAttributes = Lists.newArrayList();

        TagWrapper(String tag) {
            this.myTag = tag;
        }

        public TagWrapper withAttribute(String name, String value) {
            TagWrapper result2 = new TagWrapper(this.myTag);
            result2.myAttributes.addAll(this.myAttributes);
            result2.myAttributes.add((Pair<String, String>)Pair.create((Object)name, (Object)value));
            return result2;
        }

        @Override
        public Iterable<String> apply(Iterable<String> contents) {
            return DocumentationBuilderKit.wrapInTag(this.myTag, this.myAttributes, contents);
        }
    }
}

