/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.doctest.PyDocstringFile;
import com.jetbrains.python.formatter.PyBlock;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddImportHelper {
    private static final Logger LOG = Logger.getInstance(AddImportHelper.class);
    private static final Comparator<PyImportStatementBase> IMPORT_TYPE_COMPARATOR = (import1, import2) -> {
        int firstIsFromImport = import1 instanceof PyFromImportStatement ? 1 : 0;
        int secondIsFromImport = import2 instanceof PyFromImportStatement ? 1 : 0;
        return firstIsFromImport - secondIsFromImport;
    };
    private static final Comparator<PyImportStatementBase> IMPORT_NAMES_COMPARATOR = (import1, import2) -> ContainerUtil.compareLexicographically(AddImportHelper.getSortNames(import1), AddImportHelper.getSortNames(import2));
    private static final ImportPriority UNRESOLVED_SYMBOL_PRIORITY = ImportPriority.THIRD_PARTY;

    @NotNull
    private static List<String> getSortNames(@NotNull PyImportStatementBase importStatement) {
        if (importStatement == null) {
            AddImportHelper.$$$reportNull$$$0(0);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        PyFromImportStatement fromImport = PyUtil.as(importStatement, PyFromImportStatement.class);
        if (fromImport != null) {
            result2.add(StringUtil.repeatSymbol((char)'.', (int)fromImport.getRelativeLevel()));
            QualifiedName source = fromImport.getImportSourceQName();
            result2.add(Objects.toString(source, ""));
            if (fromImport.isStarImport()) {
                result2.add("*");
            }
        } else {
            result2.add("");
        }
        for (PyImportElement importElement : importStatement.getImportElements()) {
            QualifiedName qualifiedName = importElement.getImportedQName();
            result2.add(Objects.toString(qualifiedName, ""));
            result2.add(StringUtil.notNullize((String)importElement.getAsName()));
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            AddImportHelper.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static Comparator<PyImportStatementBase> getSameGroupImportsComparator(@NotNull PsiFile settingsAnchor) {
        if (settingsAnchor == null) {
            AddImportHelper.$$$reportNull$$$0(2);
        }
        PyCodeStyleSettings settings = (PyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)settingsAnchor, PyCodeStyleSettings.class);
        if (settings.OPTIMIZE_IMPORTS_SORT_BY_TYPE_FIRST) {
            Comparator<PyImportStatementBase> comparator2 = IMPORT_TYPE_COMPARATOR.thenComparing(IMPORT_NAMES_COMPARATOR);
            if (comparator2 == null) {
                AddImportHelper.$$$reportNull$$$0(3);
            }
            return comparator2;
        }
        Comparator<PyImportStatementBase> comparator3 = IMPORT_NAMES_COMPARATOR.thenComparing(IMPORT_TYPE_COMPARATOR);
        if (comparator3 == null) {
            AddImportHelper.$$$reportNull$$$0(4);
        }
        return comparator3;
    }

    private AddImportHelper() {
    }

    public static void addLocalImportStatement(@NotNull PsiElement element, @NotNull String name) {
        if (element == null) {
            AddImportHelper.$$$reportNull$$$0(5);
        }
        if (name == null) {
            AddImportHelper.$$$reportNull$$$0(6);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(element.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement(element);
        PsiElement anchor2 = AddImportHelper.getLocalInsertPosition(element);
        PsiElement parentElement = PyUtil.sure(anchor2).getParent();
        if (parentElement != null) {
            parentElement.addBefore((PsiElement)generator.createImportStatement(languageLevel, name, null), anchor2);
        }
    }

    public static void addLocalFromImportStatement(@NotNull PsiElement element, @NotNull String qualifier, @NotNull String name) {
        if (element == null) {
            AddImportHelper.$$$reportNull$$$0(7);
        }
        if (qualifier == null) {
            AddImportHelper.$$$reportNull$$$0(8);
        }
        if (name == null) {
            AddImportHelper.$$$reportNull$$$0(9);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(element.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement(element);
        PsiElement anchor2 = AddImportHelper.getLocalInsertPosition(element);
        PsiElement parentElement = PyUtil.sure(anchor2).getParent();
        if (parentElement != null) {
            parentElement.addBefore((PsiElement)generator.createFromImportStatement(languageLevel, qualifier, name, null), anchor2);
        }
    }

    @Nullable
    public static PsiElement getLocalInsertPosition(@NotNull PsiElement anchor2) {
        if (anchor2 == null) {
            AddImportHelper.$$$reportNull$$$0(10);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)anchor2, PyStatement.class, (boolean)false);
    }

    @Nullable
    public static PsiElement getFileInsertPosition(PsiFile file2) {
        return AddImportHelper.getInsertPosition((PsiElement)file2, null, null);
    }

    @Nullable
    private static PsiElement getInsertPosition(@NotNull PsiElement insertParent, @Nullable PyImportStatementBase newImport, @Nullable ImportPriority priority) {
        ImportPriority priorityBelow;
        PsiElement feeler;
        if (insertParent == null) {
            AddImportHelper.$$$reportNull$$$0(11);
        }
        if ((feeler = insertParent.getFirstChild()) == null) {
            return null;
        }
        boolean skippedOverImports = false;
        boolean skippedOverDoc = false;
        PsiElement seeker = feeler;
        boolean isInjected = InjectedLanguageManager.getInstance((Project)feeler.getProject()).isInjectedFragment(feeler.getContainingFile());
        PyImportStatementBase importAbove = null;
        PyImportStatementBase importBelow = null;
        do {
            PyStringLiteralExpression docElem;
            if (feeler instanceof PyImportStatementBase && !isInjected) {
                PyImportStatementBase existingImport = (PyImportStatementBase)feeler;
                if (priority != null && newImport != null) {
                    if (AddImportHelper.shouldInsertBefore(newImport, existingImport, priority)) {
                        importBelow = existingImport;
                        break;
                    }
                    importAbove = existingImport;
                }
                seeker = feeler;
                feeler = feeler.getNextSibling();
                skippedOverImports = true;
                continue;
            }
            if (PsiTreeUtil.instanceOf((Object)feeler, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class})) {
                seeker = feeler;
                feeler = feeler.getNextSibling();
                continue;
            }
            if (skippedOverImports || skippedOverDoc || !(insertParent instanceof PyFile) || (docElem = DocStringUtil.findDocStringExpression((PyElement)insertParent)) == null || docElem.getParent() != feeler) break;
            seeker = feeler = feeler.getNextSibling();
            skippedOverDoc = true;
        } while (feeler != null);
        ImportPriority priorityAbove = importAbove != null ? AddImportHelper.getImportPriority(importAbove) : null;
        ImportPriority importPriority = priorityBelow = importBelow != null ? AddImportHelper.getImportPriority(importBelow) : null;
        if (newImport != null && (priorityAbove == null || priorityAbove.compareTo(priority) < 0)) {
            newImport.putCopyableUserData(PyBlock.IMPORT_GROUP_BEGIN, true);
        }
        if (priorityBelow != null) {
            if (priorityBelow.compareTo(priority) > 0) {
                importBelow.putCopyableUserData(PyBlock.IMPORT_GROUP_BEGIN, true);
            } else if (priorityBelow == priority) {
                importBelow.putCopyableUserData(PyBlock.IMPORT_GROUP_BEGIN, null);
            }
        }
        return seeker;
    }

    private static boolean shouldInsertBefore(@Nullable PyImportStatementBase newImport, @NotNull PyImportStatementBase existingImport, @NotNull ImportPriority priority) {
        ImportPriority existingImportPriority;
        int byPriority;
        if (existingImport == null) {
            AddImportHelper.$$$reportNull$$$0(12);
        }
        if (priority == null) {
            AddImportHelper.$$$reportNull$$$0(13);
        }
        if ((byPriority = priority.compareTo(existingImportPriority = AddImportHelper.getImportPriority(existingImport))) != 0) {
            return byPriority < 0;
        }
        if (newImport == null) {
            return false;
        }
        return AddImportHelper.getSameGroupImportsComparator(existingImport.getContainingFile()).compare(newImport, existingImport) < 0;
    }

    @NotNull
    public static ImportPriority getImportPriority(@NotNull PsiElement importLocation, @NotNull PsiFileSystemItem toImport) {
        if (importLocation == null) {
            AddImportHelper.$$$reportNull$$$0(14);
        }
        if (toImport == null) {
            AddImportHelper.$$$reportNull$$$0(15);
        }
        ImportPriorityChoice choice = AddImportHelper.getImportPriorityWithReason(importLocation, toImport);
        LOG.debug(String.format("Import group for %s at %s is %s: %s", new Object[]{toImport, importLocation.getContainingFile(), choice.myPriority, choice.myDescription}));
        ImportPriority importPriority = choice.myPriority;
        if (importPriority == null) {
            AddImportHelper.$$$reportNull$$$0(16);
        }
        return importPriority;
    }

    @NotNull
    public static ImportPriority getImportPriority(@NotNull PyImportStatementBase importStatement) {
        if (importStatement == null) {
            AddImportHelper.$$$reportNull$$$0(17);
        }
        ImportPriorityChoice choice = AddImportHelper.getImportPriorityWithReason(importStatement);
        LOG.debug(String.format("Import group for '%s' is %s: %s", new Object[]{importStatement.getText(), choice.myPriority, choice.myDescription}));
        ImportPriority importPriority = choice.myPriority;
        if (importPriority == null) {
            AddImportHelper.$$$reportNull$$$0(18);
        }
        return importPriority;
    }

    @NotNull
    static ImportPriorityChoice getImportPriorityWithReason(@NotNull PyImportStatementBase importStatement) {
        PsiElement resolved;
        PyElement resolveAnchor;
        if (importStatement == null) {
            AddImportHelper.$$$reportNull$$$0(19);
        }
        if (importStatement instanceof PyFromImportStatement) {
            PyFromImportStatement fromImportStatement = (PyFromImportStatement)importStatement;
            if (fromImportStatement.isFromFuture()) {
                ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(ImportPriority.FUTURE, "import from __future__");
                if (importPriorityChoice == null) {
                    AddImportHelper.$$$reportNull$$$0(20);
                }
                return importPriorityChoice;
            }
            if (fromImportStatement.getRelativeLevel() > 0) {
                ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(ImportPriority.PROJECT, "explicit relative import");
                if (importPriorityChoice == null) {
                    AddImportHelper.$$$reportNull$$$0(21);
                }
                return importPriorityChoice;
            }
            resolveAnchor = ((PyFromImportStatement)importStatement).getImportSource();
            resolved = fromImportStatement.resolveImportSource();
        } else {
            PyImportElement firstImportElement = (PyImportElement)ArrayUtil.getFirstElement((Object[])importStatement.getImportElements());
            if (firstImportElement == null) {
                ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(UNRESOLVED_SYMBOL_PRIORITY, "incomplete import statement");
                if (importPriorityChoice == null) {
                    AddImportHelper.$$$reportNull$$$0(22);
                }
                return importPriorityChoice;
            }
            resolveAnchor = firstImportElement;
            resolved = firstImportElement.resolve();
        }
        if (resolved == null) {
            ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(UNRESOLVED_SYMBOL_PRIORITY, resolveAnchor == null ? "incomplete import statement" : resolveAnchor.getText() + " is unresolved");
            if (importPriorityChoice == null) {
                AddImportHelper.$$$reportNull$$$0(23);
            }
            return importPriorityChoice;
        }
        Object resolvedFileOrDir = resolved instanceof PsiDirectory ? (PsiFileSystemItem)resolved : (resolved instanceof PsiDirectoryContainer ? (PsiFileSystemItem)ArrayUtil.getFirstElement((Object[])((PsiDirectoryContainer)resolved).getDirectories()) : resolved.getContainingFile());
        if (resolvedFileOrDir instanceof PyiFile) {
            resolvedFileOrDir = PyUtil.as(PyiUtil.getOriginalElement((PyiFile)resolvedFileOrDir), PsiFileSystemItem.class);
        }
        if (resolvedFileOrDir == null) {
            ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(UNRESOLVED_SYMBOL_PRIORITY, resolved + " is not a file or directory");
            if (importPriorityChoice == null) {
                AddImportHelper.$$$reportNull$$$0(24);
            }
            return importPriorityChoice;
        }
        ImportPriorityChoice importPriorityChoice = AddImportHelper.getImportPriorityWithReason((PsiElement)importStatement, resolvedFileOrDir);
        if (importPriorityChoice == null) {
            AddImportHelper.$$$reportNull$$$0(25);
        }
        return importPriorityChoice;
    }

    @NotNull
    static ImportPriorityChoice getImportPriorityWithReason(@NotNull PsiElement importLocation, @NotNull PsiFileSystemItem toImport) {
        Sdk pythonSdk2;
        VirtualFile vFile;
        if (importLocation == null) {
            AddImportHelper.$$$reportNull$$$0(26);
        }
        if (toImport == null) {
            AddImportHelper.$$$reportNull$$$0(27);
        }
        if ((vFile = toImport.getVirtualFile()) == null) {
            ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(UNRESOLVED_SYMBOL_PRIORITY, toImport + " doesn't have an associated virtual file");
            if (importPriorityChoice == null) {
                AddImportHelper.$$$reportNull$$$0(28);
            }
            return importPriorityChoice;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)toImport.getProject());
        ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
        if (fileIndex.isInContent(vFile) && !fileIndex.isInLibraryClasses(vFile)) {
            ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(ImportPriority.PROJECT, vFile + " belongs to the project and not under interpreter paths");
            if (importPriorityChoice == null) {
                AddImportHelper.$$$reportNull$$$0(29);
            }
            return importPriorityChoice;
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)importLocation);
        Sdk sdk = pythonSdk2 = module2 != null ? PythonSdkType.findPythonSdk(module2) : projectRootManager.getProjectSdk();
        if (PythonSdkType.isStdLib(vFile, pythonSdk2)) {
            ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(ImportPriority.BUILTIN, vFile + " is either in lib but not under site-packages, or belongs to the root of skeletons, or is a .pyi stub definition for stdlib module");
            if (importPriorityChoice == null) {
                AddImportHelper.$$$reportNull$$$0(30);
            }
            return importPriorityChoice;
        }
        ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(ImportPriority.THIRD_PARTY, pythonSdk2 == null ? "SDK for " + vFile + " isn't found" : "Fall back value for " + vFile);
        if (importPriorityChoice == null) {
            AddImportHelper.$$$reportNull$$$0(31);
        }
        return importPriorityChoice;
    }

    public static boolean addImportStatement(@NotNull PsiFile file2, @NotNull String name, @Nullable String asName, @Nullable ImportPriority priority, @Nullable PsiElement anchor2) {
        if (file2 == null) {
            AddImportHelper.$$$reportNull$$$0(32);
        }
        if (name == null) {
            AddImportHelper.$$$reportNull$$$0(33);
        }
        if (!(file2 instanceof PyFile)) {
            return false;
        }
        List<PyImportElement> existingImports = ((PyFile)file2).getImportTargets();
        for (PyImportElement element : existingImports) {
            QualifiedName qName = element.getImportedQName();
            if (qName == null || !name.equals(qName.toString()) || (asName == null || !asName.equals(element.getAsName())) && (asName != null || element.getAsName() != null)) continue;
            return false;
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(file2.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)file2);
        PyImportStatement importNodeToInsert = generator.createImportStatement(languageLevel, name, asName);
        PyImportStatementBase importStatement = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)anchor2, PyImportStatementBase.class, (boolean)false);
        PsiFile insertParent = importStatement != null && importStatement.getContainingFile() == file2 ? importStatement.getParent() : file2;
        try {
            if (anchor2 instanceof PyImportStatementBase) {
                insertParent.addAfter((PsiElement)importNodeToInsert, anchor2);
            } else {
                insertParent.addBefore((PsiElement)importNodeToInsert, AddImportHelper.getInsertPosition((PsiElement)insertParent, importNodeToInsert, priority));
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return true;
    }

    public static void addFromImportStatement(@NotNull PsiFile file2, @NotNull String from, @NotNull String name, @Nullable String asName, @Nullable ImportPriority priority, @Nullable PsiElement anchor2) {
        if (file2 == null) {
            AddImportHelper.$$$reportNull$$$0(34);
        }
        if (from == null) {
            AddImportHelper.$$$reportNull$$$0(35);
        }
        if (name == null) {
            AddImportHelper.$$$reportNull$$$0(36);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(file2.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)file2);
        PyFromImportStatement newImport = generator.createFromImportStatement(languageLevel, from, name, asName);
        AddImportHelper.addFromImportStatement(file2, newImport, priority, anchor2);
    }

    public static void addFromImportStatement(@NotNull PsiFile file2, @NotNull PyFromImportStatement newImport, @Nullable ImportPriority priority, @Nullable PsiElement anchor2) {
        if (file2 == null) {
            AddImportHelper.$$$reportNull$$$0(37);
        }
        if (newImport == null) {
            AddImportHelper.$$$reportNull$$$0(38);
        }
        try {
            boolean insideDoctest;
            PyImportStatementBase parentImport = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)anchor2, PyImportStatementBase.class, (boolean)false);
            InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)file2.getProject());
            PsiLanguageInjectionHost injectionHost = manager.getInjectionHost((PsiElement)file2);
            boolean bl = insideDoctest = file2 instanceof PyDocstringFile && injectionHost != null && DocStringUtil.getParentDefinitionDocString((PsiElement)injectionHost) == injectionHost;
            Object insertParent = parentImport != null && parentImport.getContainingFile() == file2 ? parentImport.getParent() : (injectionHost != null && !insideDoctest ? manager.getTopLevelFile((PsiElement)file2) : file2);
            if (insideDoctest) {
                PsiElement element = insertParent.addBefore((PsiElement)newImport, AddImportHelper.getInsertPosition((PsiElement)insertParent, newImport, priority));
                PsiElement whitespace = element.getNextSibling();
                if (!(whitespace instanceof PsiWhiteSpace)) {
                    whitespace = PsiParserFacade.SERVICE.getInstance((Project)file2.getProject()).createWhiteSpaceFromText("  >>> ");
                }
                insertParent.addBefore(whitespace, element);
            } else if (anchor2 instanceof PyImportStatementBase) {
                insertParent.addAfter((PsiElement)newImport, anchor2);
            } else {
                insertParent.addBefore((PsiElement)newImport, AddImportHelper.getInsertPosition((PsiElement)insertParent, newImport, priority));
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public static boolean addOrUpdateFromImportStatement(@NotNull PsiFile file2, @NotNull String from, @NotNull String name, @Nullable String asName, @Nullable ImportPriority priority, @Nullable PsiElement anchor2) {
        if (file2 == null) {
            AddImportHelper.$$$reportNull$$$0(39);
        }
        if (from == null) {
            AddImportHelper.$$$reportNull$$$0(40);
        }
        if (name == null) {
            AddImportHelper.$$$reportNull$$$0(41);
        }
        List<PyFromImportStatement> existingImports = ((PyFile)file2).getFromImports();
        for (PyFromImportStatement existingImport : existingImports) {
            QualifiedName qName;
            if (existingImport.isStarImport() || (qName = existingImport.getImportSourceQName()) == null || !qName.toString().equals(from) || existingImport.getRelativeLevel() != 0) continue;
            for (PyImportElement el : existingImport.getImportElements()) {
                QualifiedName importedQName = el.getImportedQName();
                if (importedQName == null || !StringUtil.equals((CharSequence)name, (CharSequence)importedQName.toString()) || !StringUtil.equals((CharSequence)asName, (CharSequence)el.getAsName())) continue;
                return false;
            }
            PyElementGenerator generator = PyElementGenerator.getInstance(file2.getProject());
            PyImportElement importElement = generator.createImportElement(LanguageLevel.forElement((PsiElement)file2), name, asName);
            existingImport.add((PsiElement)importElement);
            CodeStyleManager.getInstance((Project)file2.getProject()).reformat((PsiElement)existingImport);
            return true;
        }
        AddImportHelper.addFromImportStatement(file2, from, name, asName, priority, anchor2);
        return true;
    }

    public static void addImport(@NotNull PsiNamedElement target2, @NotNull PsiFile file2, @NotNull PyElement element) {
        if (target2 == null) {
            AddImportHelper.$$$reportNull$$$0(42);
        }
        if (file2 == null) {
            AddImportHelper.$$$reportNull$$$0(43);
        }
        if (element == null) {
            AddImportHelper.$$$reportNull$$$0(44);
        }
        if (target2 instanceof PsiFileSystemItem) {
            AddImportHelper.addFileSystemItemImport((PsiFileSystemItem)target2, file2, element);
            return;
        }
        String name = target2.getName();
        if (name == null) {
            return;
        }
        PsiFile toImport = target2.getContainingFile();
        if (toImport == null) {
            return;
        }
        QualifiedName importPath = QualifiedNameFinder.findCanonicalImportPath((PsiElement)target2, (PsiElement)element);
        if (importPath == null) {
            return;
        }
        String path = importPath.toString();
        ImportPriority priority = AddImportHelper.getImportPriority((PsiElement)file2, (PsiFileSystemItem)toImport);
        if (!PyCodeInsightSettings.getInstance().PREFER_FROM_IMPORT) {
            AddImportHelper.addImportStatement(file2, path, null, priority, (PsiElement)element);
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(file2.getProject());
            element.replace((PsiElement)elementGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)target2), path + "." + name));
        } else {
            AddImportHelper.addOrUpdateFromImportStatement(file2, path, name, null, priority, (PsiElement)element);
        }
    }

    private static void addFileSystemItemImport(@NotNull PsiFileSystemItem target2, @NotNull PsiFile file2, @NotNull PyElement element) {
        PsiFileSystemItem toImport;
        if (target2 == null) {
            AddImportHelper.$$$reportNull$$$0(45);
        }
        if (file2 == null) {
            AddImportHelper.$$$reportNull$$$0(46);
        }
        if (element == null) {
            AddImportHelper.$$$reportNull$$$0(47);
        }
        if ((toImport = target2.getParent()) == null) {
            return;
        }
        QualifiedName importPath = QualifiedNameFinder.findCanonicalImportPath((PsiElement)target2, (PsiElement)element);
        if (importPath == null) {
            return;
        }
        ImportPriority priority = AddImportHelper.getImportPriority((PsiElement)file2, toImport);
        if (importPath.getComponentCount() == 1 || !PyCodeInsightSettings.getInstance().PREFER_FROM_IMPORT) {
            String path = importPath.toString();
            AddImportHelper.addImportStatement(file2, path, null, priority, (PsiElement)element);
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(file2.getProject());
            element.replace((PsiElement)elementGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)target2), path));
        } else {
            AddImportHelper.addOrUpdateFromImportStatement(file2, importPath.removeLastComponent().toString(), target2.getName(), null, priority, (PsiElement)element);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/imports/AddImportHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsAnchor";
                break;
            }
            case 5: 
            case 7: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 9: 
            case 33: 
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertParent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingImport";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 14: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importLocation";
                break;
            }
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 32: 
            case 34: 
            case 37: 
            case 39: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newImport";
                break;
            }
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/imports/AddImportHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortNames";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSameGroupImportsComparator";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPriority";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPriorityWithReason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSortNames";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSameGroupImportsComparator";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addLocalImportStatement";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addLocalFromImportStatement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLocalInsertPosition";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getInsertPosition";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "shouldInsertBefore";
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getImportPriority";
                break;
            }
            case 19: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getImportPriorityWithReason";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addImportStatement";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addFromImportStatement";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addOrUpdateFromImportStatement";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addImport";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addFileSystemItemImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ImportPriorityChoice {
        private final ImportPriority myPriority;
        private final String myDescription;

        public ImportPriorityChoice(@NotNull ImportPriority priority, @NotNull String description) {
            if (priority == null) {
                ImportPriorityChoice.$$$reportNull$$$0(0);
            }
            if (description == null) {
                ImportPriorityChoice.$$$reportNull$$$0(1);
            }
            this.myPriority = priority;
            this.myDescription = description;
        }

        @NotNull
        public ImportPriority getPriority() {
            ImportPriority importPriority = this.myPriority;
            if (importPriority == null) {
                ImportPriorityChoice.$$$reportNull$$$0(2);
            }
            return importPriority;
        }

        @NotNull
        public String getDescription() {
            String string = this.myDescription;
            if (string == null) {
                ImportPriorityChoice.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "priority";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/imports/AddImportHelper$ImportPriorityChoice";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/imports/AddImportHelper$ImportPriorityChoice";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPriority";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum ImportPriority {
        FUTURE,
        BUILTIN,
        THIRD_PARTY,
        PROJECT;

    }
}

