/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.psi.JsonFile;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaAnnotatorChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaComplianceChecker {
    private static final Key<Set<PsiElement>> ANNOTATED_PROPERTIES = Key.create((String)"JsonSchema.Properties.Annotated");
    @NotNull
    private final JsonSchemaObject myRootSchema;
    @NotNull
    private final ProblemsHolder myHolder;
    @NotNull
    private final JsonLikePsiWalker myWalker;
    private final LocalInspectionToolSession mySession;
    @NotNull
    private final JsonComplianceCheckerOptions myOptions;
    @Nullable
    private final String myMessagePrefix;

    public JsonSchemaComplianceChecker(@NotNull JsonSchemaObject rootSchema, @NotNull ProblemsHolder holder, @NotNull JsonLikePsiWalker walker, @NotNull LocalInspectionToolSession session2, @NotNull JsonComplianceCheckerOptions options) {
        if (rootSchema == null) {
            JsonSchemaComplianceChecker.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            JsonSchemaComplianceChecker.$$$reportNull$$$0(1);
        }
        if (walker == null) {
            JsonSchemaComplianceChecker.$$$reportNull$$$0(2);
        }
        if (session2 == null) {
            JsonSchemaComplianceChecker.$$$reportNull$$$0(3);
        }
        if (options == null) {
            JsonSchemaComplianceChecker.$$$reportNull$$$0(4);
        }
        this(rootSchema, holder, walker, session2, options, null);
    }

    public JsonSchemaComplianceChecker(@NotNull JsonSchemaObject rootSchema, @NotNull ProblemsHolder holder, @NotNull JsonLikePsiWalker walker, @NotNull LocalInspectionToolSession session2, @NotNull JsonComplianceCheckerOptions options, @Nullable String messagePrefix) {
        if (rootSchema == null) {
            JsonSchemaComplianceChecker.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            JsonSchemaComplianceChecker.$$$reportNull$$$0(6);
        }
        if (walker == null) {
            JsonSchemaComplianceChecker.$$$reportNull$$$0(7);
        }
        if (session2 == null) {
            JsonSchemaComplianceChecker.$$$reportNull$$$0(8);
        }
        if (options == null) {
            JsonSchemaComplianceChecker.$$$reportNull$$$0(9);
        }
        this.myRootSchema = rootSchema;
        this.myHolder = holder;
        this.myWalker = walker;
        this.mySession = session2;
        this.myOptions = options;
        this.myMessagePrefix = messagePrefix;
    }

    public void annotate(@NotNull PsiElement element) {
        JsonPropertyAdapter firstProp;
        if (element == null) {
            JsonSchemaComplianceChecker.$$$reportNull$$$0(10);
        }
        if ((firstProp = this.myWalker.getParentPropertyAdapter(element)) != null && firstProp.getValue() != null) {
            List<JsonSchemaVariantsTreeBuilder.Step> position = this.myWalker.findPosition(firstProp.getDelegate(), true);
            if (position == null || position.isEmpty()) {
                return;
            }
            MatchResult result2 = new JsonSchemaResolver(this.myRootSchema, false, position).detailedResolve();
            this.createWarnings(JsonSchemaAnnotatorChecker.checkByMatchResult(firstProp.getValue(), result2, this.myOptions));
        }
        this.checkRoot(element, firstProp);
    }

    private void checkRoot(@NotNull PsiElement element, @Nullable JsonPropertyAdapter firstProp) {
        JsonValueAdapter rootToCheck;
        if (element == null) {
            JsonSchemaComplianceChecker.$$$reportNull$$$0(11);
        }
        if (firstProp == null) {
            rootToCheck = JsonSchemaComplianceChecker.findTopLevelElement(this.myWalker, element);
        } else {
            rootToCheck = firstProp.getParentObject();
            if (rootToCheck == null || !this.myWalker.isTopJsonElement(rootToCheck.getDelegate().getParent())) {
                return;
            }
        }
        if (rootToCheck != null) {
            MatchResult matchResult = new JsonSchemaResolver(this.myRootSchema).detailedResolve();
            this.createWarnings(JsonSchemaAnnotatorChecker.checkByMatchResult(rootToCheck, matchResult, this.myOptions));
        }
    }

    private void createWarnings(@Nullable JsonSchemaAnnotatorChecker checker) {
        if (checker != null && !checker.isCorrect()) {
            for (Map.Entry<PsiElement, JsonValidationError> entry : checker.getErrors().entrySet()) {
                LocalQuickFix fix;
                if (this.checkIfAlreadyProcessed(entry.getKey())) continue;
                String value = entry.getValue().getMessage();
                if (this.myMessagePrefix != null) {
                    value = this.myMessagePrefix + value;
                }
                LocalQuickFix localQuickFix = fix = entry.getKey().getContainingFile() instanceof JsonFile ? entry.getValue().createFix() : null;
                if (fix == null) {
                    this.myHolder.registerProblem(entry.getKey(), value, new LocalQuickFix[0]);
                    continue;
                }
                this.myHolder.registerProblem(entry.getKey(), value, new LocalQuickFix[]{fix});
            }
        }
    }

    private static JsonValueAdapter findTopLevelElement(@NotNull JsonLikePsiWalker walker, @NotNull PsiElement element) {
        if (walker == null) {
            JsonSchemaComplianceChecker.$$$reportNull$$$0(12);
        }
        if (element == null) {
            JsonSchemaComplianceChecker.$$$reportNull$$$0(13);
        }
        Ref ref = new Ref();
        PsiTreeUtil.findFirstParent((PsiElement)element, el -> {
            boolean isTop;
            if (walker == null) {
                JsonSchemaComplianceChecker.$$$reportNull$$$0(15);
            }
            if (!(isTop = walker.isTopJsonElement((PsiElement)el))) {
                ref.set(el);
            }
            return isTop;
        });
        return ref.isNull() ? null : walker.createValueAdapter((PsiElement)ref.get());
    }

    private boolean checkIfAlreadyProcessed(@NotNull PsiElement property) {
        HashSet<PsiElement> data;
        if (property == null) {
            JsonSchemaComplianceChecker.$$$reportNull$$$0(14);
        }
        if ((data = (HashSet<PsiElement>)this.mySession.getUserData(ANNOTATED_PROPERTIES)) == null) {
            data = new HashSet<PsiElement>();
            this.mySession.putUserData(ANNOTATED_PROPERTIES, data);
        }
        if (data.contains(property)) {
            return true;
        }
        data.add(property);
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSchema";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 7: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "walker";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaComplianceChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRoot";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "findTopLevelElement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIfAlreadyProcessed";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findTopLevelElement$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

