/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorLinePainter;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.evaluate.XValueCompactPresentation;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererImpl;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerEditorLinePainter
extends EditorLinePainter {
    public static final Key<Map<Variable, VariableValue>> CACHE = Key.create((String)"debug.inline.variables.cache");
    private static final int LINE_EXTENSIONS_MAX_COUNT = 200;

    @Override
    public Collection<LineExtensionInfo> getLineExtensions(@NotNull Project project, @NotNull VirtualFile file2, int lineNumber) {
        List<XValueNodeImpl> values;
        if (project == null) {
            XDebuggerEditorLinePainter.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            XDebuggerEditorLinePainter.$$$reportNull$$$0(1);
        }
        if (!XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowValuesInline()) {
            return null;
        }
        XDebugSession session2 = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        if (session2 == null) {
            return null;
        }
        XVariablesView.InlineVariablesInfo data = XVariablesView.InlineVariablesInfo.get(session2);
        Document doc = FileDocumentManager.getInstance().getDocument(file2);
        if (data == null || doc == null) {
            return null;
        }
        HashMap<Variable, VariableValue> oldValues = (HashMap<Variable, VariableValue>)project.getUserData(CACHE);
        if (oldValues == null) {
            oldValues = new HashMap<Variable, VariableValue>();
            project.putUserData(CACHE, oldValues);
        }
        if ((values = data.get(file2, lineNumber, doc.getModificationStamp())) != null && !values.isEmpty()) {
            int bpLine = XDebuggerEditorLinePainter.getCurrentBreakPointLineInFile(session2, file2);
            boolean isTopFrame = session2 instanceof XDebugSessionImpl && ((XDebugSessionImpl)session2).isTopFrameSelected();
            TextAttributes attributes = bpLine == lineNumber && isTopFrame && ((XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)project)).isFullLineHighlighter() ? XDebuggerEditorLinePainter.getTopFrameSelectedAttributes() : XDebuggerEditorLinePainter.getNormalAttributes();
            ArrayList<VariableText> result2 = new ArrayList<VariableText>();
            for (XValueNodeImpl value : values) {
                SimpleColoredText simpleColoredText;
                block16: {
                    simpleColoredText = new SimpleColoredText();
                    XValueTextRendererImpl renderer = new XValueTextRendererImpl((ColoredTextContainer)simpleColoredText);
                    XValuePresentation presentation = value.getValuePresentation();
                    if (presentation == null) continue;
                    try {
                        String type;
                        if (presentation instanceof XValueCompactPresentation && !value.getTree().isUnderRemoteDebug()) {
                            ((XValueCompactPresentation)presentation).renderValue(renderer, value);
                        } else {
                            presentation.renderValue((XValuePresentation.XValueTextRenderer)renderer);
                        }
                        if (!StringUtil.isEmpty((String)simpleColoredText.toString()) || StringUtil.isEmpty((String)(type = value.getValuePresentation().getType()))) break block16;
                        simpleColoredText.append(type, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                    catch (Exception ignored) {
                        continue;
                    }
                }
                String name = value.getName();
                if (StringUtil.isEmpty((String)simpleColoredText.toString())) continue;
                VariableText res = new VariableText();
                result2.add(res);
                res.add(new LineExtensionInfo("  " + name + ": ", attributes));
                Variable var = new Variable(name, lineNumber);
                VariableValue variableValue = oldValues.computeIfAbsent(var, k -> new VariableValue(simpleColoredText.toString(), null, value.hashCode()));
                if (variableValue.valueNodeHashCode != value.hashCode()) {
                    variableValue.old = variableValue.actual;
                    variableValue.actual = simpleColoredText.toString();
                    variableValue.valueNodeHashCode = value.hashCode();
                }
                if (!variableValue.isChanged()) {
                    for (String s : simpleColoredText.getTexts()) {
                        res.add(new LineExtensionInfo(s, attributes));
                    }
                    continue;
                }
                variableValue.produceChangedParts(res.infos);
            }
            ArrayList<LineExtensionInfo> infos = new ArrayList<LineExtensionInfo>();
            for (VariableText variableText : result2) {
                infos.addAll(variableText.infos);
            }
            return infos.size() > 200 ? infos.subList(0, 200) : infos;
        }
        return null;
    }

    private static int getCurrentBreakPointLineInFile(@Nullable XDebugSession session2, VirtualFile file2) {
        try {
            XSourcePosition position;
            if (session2 != null && (position = session2.getCurrentPosition()) != null && position.getFile().equals(file2)) {
                return position.getLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private static TextAttributes getNormalAttributes() {
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DebuggerColors.INLINED_VALUES);
        if (attributes == null || attributes.getForegroundColor() == null) {
            return new TextAttributes((Color)new JBColor(() -> EditorColorsManager.getInstance().isDarkEditor() ? new Color(4030565) : Gray._135), null, null, null, 2);
        }
        return attributes;
    }

    private static TextAttributes getChangedAttributes() {
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DebuggerColors.INLINED_VALUES_MODIFIED);
        if (attributes == null || attributes.getForegroundColor() == null) {
            return new TextAttributes((Color)new JBColor(() -> EditorColorsManager.getInstance().isDarkEditor() ? new Color(10584842) : new Color(13271073)), null, null, null, 2);
        }
        return attributes;
    }

    private static TextAttributes getTopFrameSelectedAttributes() {
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DebuggerColors.INLINED_VALUES_EXECUTION_LINE);
        if (attributes == null || attributes.getForegroundColor() == null) {
            return new TextAttributes(EditorColorsManager.getInstance().isDarkEditor() ? new Color(255, 235, 9) : new Color(0, 255, 86), null, null, null, 2);
        }
        return attributes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/xdebugger/impl/evaluate/XDebuggerEditorLinePainter";
        objectArray[2] = "getLineExtensions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class VariableText {
        final List<LineExtensionInfo> infos = new ArrayList<LineExtensionInfo>();
        int length;

        private VariableText() {
        }

        void add(LineExtensionInfo info) {
            this.infos.add(info);
            this.length += info.getText().length();
        }
    }

    static class VariableValue {
        private String actual;
        private String old;
        private int valueNodeHashCode;

        VariableValue(String actual, String old, int valueNodeHashCode) {
            this.actual = actual;
            this.old = old;
            this.valueNodeHashCode = valueNodeHashCode;
        }

        public boolean isChanged() {
            return this.old != null && !StringUtil.equals((CharSequence)this.actual, (CharSequence)this.old);
        }

        void produceChangedParts(List<? super LineExtensionInfo> result2) {
            if (VariableValue.isArray(this.actual) && VariableValue.isArray(this.old)) {
                List<String> actualParts = VariableValue.getArrayParts(this.actual);
                List<String> oldParts = VariableValue.getArrayParts(this.old);
                result2.add(new LineExtensionInfo("{", XDebuggerEditorLinePainter.getNormalAttributes()));
                for (int i = 0; i < actualParts.size(); ++i) {
                    if (i < oldParts.size() && StringUtil.equals((CharSequence)actualParts.get(i), (CharSequence)oldParts.get(i))) {
                        result2.add(new LineExtensionInfo(actualParts.get(i), XDebuggerEditorLinePainter.getNormalAttributes()));
                    } else {
                        result2.add(new LineExtensionInfo(actualParts.get(i), XDebuggerEditorLinePainter.getChangedAttributes()));
                    }
                    if (i == actualParts.size() - 1) continue;
                    result2.add(new LineExtensionInfo(", ", XDebuggerEditorLinePainter.getNormalAttributes()));
                }
                result2.add(new LineExtensionInfo("}", XDebuggerEditorLinePainter.getNormalAttributes()));
                return;
            }
            result2.add(new LineExtensionInfo(this.actual, XDebuggerEditorLinePainter.getChangedAttributes()));
        }

        private static boolean isArray(String s) {
            return s != null && s.startsWith("{") && s.endsWith("}");
        }

        private static List<String> getArrayParts(String array) {
            return StringUtil.split((String)array.substring(1, array.length() - 1), (String)", ");
        }
    }

    static class Variable {
        private final int lineNumber;
        private final String name;

        public Variable(String name, int lineNumber) {
            this.lineNumber = lineNumber;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            if (this.lineNumber != variable.lineNumber) {
                return false;
            }
            return this.name.equals(variable.name);
        }

        public int hashCode() {
            return Objects.hash(this.lineNumber, this.name);
        }
    }
}

