/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.google.common.primitives.Ints;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.roots.ui.componentsList.components.ScrollablePanel;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.vcs.commit.CommitMessageInspectionProfile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.CommitPanel;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import com.intellij.vcs.log.ui.table.CommitSelectionListener;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.TroveUtil;
import gnu.trove.TIntHashSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetailsPanel
extends JPanel
implements EditorColorsListener,
Disposable {
    private static final int MAX_ROWS = 50;
    private static final int MIN_SIZE = 20;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final JScrollPane myScrollPane;
    @NotNull
    private final JPanel myMainContentPanel;
    @NotNull
    private final StatusText myEmptyText;
    @NotNull
    private final JBLoadingPanel myLoadingPanel;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private List<Integer> mySelection;
    @NotNull
    private TIntHashSet myCommitIds;
    @Nullable
    private ProgressIndicator myResolveIndicator;

    public DetailsPanel(@NotNull VcsLogData logData, @NotNull VcsLogColorManager colorManager, @NotNull Disposable parent) {
        if (logData == null) {
            DetailsPanel.$$$reportNull$$$0(0);
        }
        if (colorManager == null) {
            DetailsPanel.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            DetailsPanel.$$$reportNull$$$0(2);
        }
        this.mySelection = ContainerUtil.emptyList();
        this.myCommitIds = new TIntHashSet();
        this.myResolveIndicator = null;
        this.myLogData = logData;
        this.myColorManager = colorManager;
        this.myScrollPane = new JBScrollPane(20, 31);
        this.myMainContentPanel = new MyMainContentPanel();
        this.myEmptyText = new StatusText(this.myMainContentPanel){

            protected boolean isStatusVisible() {
                return StringUtil.isNotEmpty((String)this.getText());
            }
        };
        this.myMainContentPanel.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.myMainContentPanel.setOpaque(false);
        this.myScrollPane.setViewportView(this.myMainContentPanel);
        this.myScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myScrollPane.setViewportBorder((Border)JBUI.Borders.empty());
        this.myLoadingPanel = new JBLoadingPanel(new BorderLayout(), parent, 300){

            public Color getBackground() {
                return CommitPanel.getCommitDetailsBackground();
            }
        };
        this.myLoadingPanel.add((Component)this.myScrollPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.myLoadingPanel, "Center");
        ProjectInspectionProfileManager.getInstance(logData.getProject()).addProfileChangeListener(new ProfileChangeAdapter(){

            public void profileChanged(@Nullable InspectionProfile profile2) {
                if (CommitMessageInspectionProfile.getInstance(DetailsPanel.this.myLogData.getProject()).equals(profile2)) {
                    ApplicationManager.getApplication().invokeLater(() -> DetailsPanel.this.update(), ModalityState.NON_MODAL);
                }
            }
        }, this);
        this.myEmptyText.setText("Commit details");
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public void globalSchemeChange(EditorColorsScheme scheme2) {
        this.update();
    }

    private void update() {
        for (int i = 0; i < this.mySelection.size(); ++i) {
            CommitPanel commitPanel = this.getCommitPanel(i);
            commitPanel.update();
        }
    }

    @Override
    public Color getBackground() {
        return CommitPanel.getCommitDetailsBackground();
    }

    public void installCommitSelectionListener(@NotNull VcsLogGraphTable graphTable) {
        if (graphTable == null) {
            DetailsPanel.$$$reportNull$$$0(3);
        }
        graphTable.getSelectionModel().addListSelectionListener(new CommitSelectionListenerForDetails(graphTable));
    }

    public void branchesChanged() {
        for (int i = 0; i < this.mySelection.size(); ++i) {
            CommitPanel commitPanel = this.getCommitPanel(i);
            commitPanel.updateBranches();
        }
    }

    protected void navigate(@NotNull CommitId commitId) {
        if (commitId == null) {
            DetailsPanel.$$$reportNull$$$0(4);
        }
    }

    private void rebuildCommitPanels(int[] selection) {
        this.myEmptyText.setText("");
        int selectionLength = selection.length;
        int existingCount = (this.myMainContentPanel.getComponentCount() + 1) / 2;
        int requiredCount = Math.min(selectionLength, 50);
        for (int i = existingCount; i < requiredCount; ++i) {
            if (i > 0) {
                this.myMainContentPanel.add((Component)new SeparatorComponent(0, OnePixelDivider.BACKGROUND, null));
            }
            this.myMainContentPanel.add((Component)((Object)new CommitPanel(this.myLogData, this.myColorManager, (Consumer<CommitId>)((Consumer)this::navigate))));
        }
        while (this.myMainContentPanel.getComponentCount() > 2 * requiredCount - 1) {
            this.myMainContentPanel.remove(this.myMainContentPanel.getComponentCount() - 1);
        }
        if (selectionLength > 50) {
            this.myMainContentPanel.add((Component)new SeparatorComponent(0, OnePixelDivider.BACKGROUND, null));
            JBLabel label2 = new JBLabel("(showing 50 of " + selectionLength + " selected commits)");
            label2.setFont(FontUtil.getCommitMetadataFont());
            label2.setBorder((Border)JBUI.Borders.emptyLeft((int)14));
            this.myMainContentPanel.add((Component)label2);
        }
        this.mySelection = Ints.asList((int[])Arrays.copyOf(selection, requiredCount));
        this.repaint();
    }

    private void resolveHashes(@NotNull List<CommitId> ids, @NotNull List<CommitPresentationUtil.CommitPresentation> presentations, @NotNull Set<String> unResolvedHashes, @NotNull Condition<Object> expired) {
        if (ids == null) {
            DetailsPanel.$$$reportNull$$$0(5);
        }
        if (presentations == null) {
            DetailsPanel.$$$reportNull$$$0(6);
        }
        if (unResolvedHashes == null) {
            DetailsPanel.$$$reportNull$$$0(7);
        }
        if (expired == null) {
            DetailsPanel.$$$reportNull$$$0(8);
        }
        if (!unResolvedHashes.isEmpty()) {
            this.myResolveIndicator = BackgroundTaskUtil.executeOnPooledThread(this, () -> {
                if (unResolvedHashes == null) {
                    DetailsPanel.$$$reportNull$$$0(12);
                }
                if (presentations == null) {
                    DetailsPanel.$$$reportNull$$$0(13);
                }
                if (ids == null) {
                    DetailsPanel.$$$reportNull$$$0(14);
                }
                if (expired == null) {
                    DetailsPanel.$$$reportNull$$$0(15);
                }
                MultiMap resolvedHashes = MultiMap.createSmart();
                HashSet fullHashes = ContainerUtil.newHashSet((Iterable)ContainerUtil.filter((Collection)unResolvedHashes, h -> h.length() == 40));
                for (String fullHash : fullHashes) {
                    Hash hash = HashImpl.build(fullHash);
                    for (VirtualFile root : this.myLogData.getRoots()) {
                        CommitId id = new CommitId(hash, root);
                        if (!this.myLogData.getStorage().containsCommit(id)) continue;
                        resolvedHashes.putValue((Object)fullHash, (Object)id);
                    }
                }
                unResolvedHashes.removeAll(fullHashes);
                if (!unResolvedHashes.isEmpty()) {
                    this.myLogData.getStorage().iterateCommits((Function<CommitId, Boolean>)((Function)commitId -> {
                        if (unResolvedHashes == null) {
                            DetailsPanel.$$$reportNull$$$0(17);
                        }
                        for (String hashString : unResolvedHashes) {
                            if (!StringUtil.startsWithIgnoreCase((String)commitId.getHash().asString(), (String)hashString)) continue;
                            resolvedHashes.putValue((Object)hashString, commitId);
                        }
                        return false;
                    }));
                }
                List resolvedPresentations = ContainerUtil.map2List((Collection)presentations, presentation -> presentation.resolve((MultiMap<String, CommitId>)resolvedHashes));
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (ids == null) {
                        DetailsPanel.$$$reportNull$$$0(16);
                    }
                    this.myResolveIndicator = null;
                    this.setPresentations(ids, resolvedPresentations);
                }, Conditions.or(o -> this.myResolveIndicator != indicator, (Condition)expired));
            });
        }
    }

    private void cancelResolve() {
        if (this.myResolveIndicator != null) {
            this.myResolveIndicator.cancel();
            this.myResolveIndicator = null;
        }
    }

    private void setPresentations(@NotNull List<CommitId> ids, @NotNull List<? extends CommitPresentationUtil.CommitPresentation> presentations) {
        if (ids == null) {
            DetailsPanel.$$$reportNull$$$0(9);
        }
        if (presentations == null) {
            DetailsPanel.$$$reportNull$$$0(10);
        }
        assert (ids.size() == presentations.size());
        for (int i = 0; i < this.mySelection.size(); ++i) {
            CommitPanel commitPanel = this.getCommitPanel(i);
            commitPanel.setCommit(ids.get(i), presentations.get(i));
        }
    }

    @NotNull
    private CommitPanel getCommitPanel(int index) {
        CommitPanel commitPanel = (CommitPanel)((Object)this.myMainContentPanel.getComponent(2 * index));
        if (commitPanel == null) {
            DetailsPanel.$$$reportNull$$$0(11);
        }
        return commitPanel;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension minimumSize = super.getMinimumSize();
        return new Dimension(Math.max(minimumSize.width, JBUI.scale((int)20)), Math.max(minimumSize.height, JBUI.scale((int)20)));
    }

    public void dispose() {
        this.cancelResolve();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphTable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 5: 
            case 9: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 6: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentations";
                break;
            }
            case 7: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unResolvedHashes";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expired";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/DetailsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/DetailsPanel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installCommitSelectionListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveHashes";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setPresentations";
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveHashes$5";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyMainContentPanel
    extends ScrollablePanel {
        private MyMainContentPanel() {
        }

        @Override
        public Insets getInsets() {
            return JBUI.emptyInsets();
        }

        @Override
        public Color getBackground() {
            return CommitPanel.getCommitDetailsBackground();
        }

        @Override
        protected void paintChildren(Graphics g) {
            if (StringUtil.isNotEmpty((String)DetailsPanel.this.myEmptyText.getText())) {
                DetailsPanel.this.myEmptyText.paint((Component)this, g);
            } else {
                super.paintChildren(g);
            }
        }
    }

    private class CommitSelectionListenerForDetails
    extends CommitSelectionListener {
        public CommitSelectionListenerForDetails(VcsLogGraphTable graphTable) {
            super(DetailsPanel.this.myLogData, graphTable);
        }

        @Override
        protected void onDetailsLoaded(@NotNull List<VcsFullCommitDetails> detailsList) {
            if (detailsList == null) {
                CommitSelectionListenerForDetails.$$$reportNull$$$0(0);
            }
            List ids = ContainerUtil.map(detailsList, detail -> new CommitId((Hash)detail.getId(), detail.getRoot()));
            HashSet unResolvedHashes = ContainerUtil.newHashSet();
            List presentations = ContainerUtil.map(detailsList, detail -> CommitPresentationUtil.buildPresentation(DetailsPanel.this.myLogData.getProject(), detail, unResolvedHashes));
            DetailsPanel.this.setPresentations(ids, presentations);
            TIntHashSet newCommitIds = TroveUtil.map2IntSet(detailsList, c -> DetailsPanel.this.myLogData.getStorage().getCommitIndex((Hash)c.getId(), c.getRoot()));
            if (!TroveUtil.intersects(DetailsPanel.this.myCommitIds, newCommitIds)) {
                DetailsPanel.this.myScrollPane.getVerticalScrollBar().setValue(0);
            }
            DetailsPanel.this.myCommitIds = newCommitIds;
            List currentSelection = DetailsPanel.this.mySelection;
            DetailsPanel.this.resolveHashes(ids, presentations, unResolvedHashes, (Condition<Object>)o -> currentSelection != DetailsPanel.this.mySelection);
        }

        @Override
        protected void onSelection(@NotNull int[] selection) {
            if (selection == null) {
                CommitSelectionListenerForDetails.$$$reportNull$$$0(1);
            }
            DetailsPanel.this.cancelResolve();
            DetailsPanel.this.rebuildCommitPanels(selection);
            List currentSelection = DetailsPanel.this.mySelection;
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                ArrayList result2 = ContainerUtil.newArrayList();
                for (Integer row : currentSelection) {
                    result2.add(this.myGraphTable.getModel().getRefsAtRow(row));
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (currentSelection == DetailsPanel.this.mySelection) {
                        for (int i = 0; i < currentSelection.size(); ++i) {
                            CommitPanel commitPanel = DetailsPanel.this.getCommitPanel(i);
                            commitPanel.setRefs((Collection)result2.get(i));
                        }
                    }
                });
            });
        }

        @Override
        protected void onEmptySelection() {
            DetailsPanel.this.cancelResolve();
            this.setEmpty("No commits selected");
        }

        @Override
        @NotNull
        protected List<Integer> getSelectionToLoad() {
            List list2 = DetailsPanel.this.mySelection;
            if (list2 == null) {
                CommitSelectionListenerForDetails.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @Override
        protected void startLoading() {
            DetailsPanel.this.myLoadingPanel.startLoading();
        }

        @Override
        protected void stopLoading() {
            DetailsPanel.this.myLoadingPanel.stopLoading();
        }

        @Override
        protected void onError(@NotNull Throwable error) {
            if (error == null) {
                CommitSelectionListenerForDetails.$$$reportNull$$$0(3);
            }
            this.setEmpty("Error loading commits");
        }

        private void setEmpty(@NotNull String text2) {
            if (text2 == null) {
                CommitSelectionListenerForDetails.$$$reportNull$$$0(4);
            }
            DetailsPanel.this.myEmptyText.setText(text2);
            DetailsPanel.this.myMainContentPanel.removeAll();
            DetailsPanel.this.mySelection = ContainerUtil.emptyList();
            DetailsPanel.this.myCommitIds = new TIntHashSet();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "detailsList";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/frame/DetailsPanel$CommitSelectionListenerForDetails";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/frame/DetailsPanel$CommitSelectionListenerForDetails";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectionToLoad";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "onDetailsLoaded";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "onSelection";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onError";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setEmpty";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

