/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogProgress
implements Disposable {
    @NotNull
    private final Object myLock;
    @NotNull
    private final List<ProgressListener> myListeners;
    @NotNull
    private final Set<VcsLogProgressIndicator> myTasksWithVisibleProgress;
    @NotNull
    private final Set<ProgressIndicator> myTasksWithSilentProgress;
    private boolean myDisposed;

    public VcsLogProgress(@NotNull Project project, @NotNull Disposable parent) {
        if (project == null) {
            VcsLogProgress.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            VcsLogProgress.$$$reportNull$$$0(1);
        }
        this.myLock = new Object();
        this.myListeners = ContainerUtil.newArrayList();
        this.myTasksWithVisibleProgress = ContainerUtil.newHashSet();
        this.myTasksWithSilentProgress = ContainerUtil.newHashSet();
        this.myDisposed = false;
        Disposer.register((Disposable)parent, () -> Disposer.dispose((Disposable)this));
        Disposer.register((Disposable)project, (Disposable)this);
    }

    @NotNull
    public ProgressIndicator createProgressIndicator(@NotNull ProgressKey key) {
        if (key == null) {
            VcsLogProgress.$$$reportNull$$$0(2);
        }
        ProgressIndicator progressIndicator = this.createProgressIndicator(true, key);
        if (progressIndicator == null) {
            VcsLogProgress.$$$reportNull$$$0(3);
        }
        return progressIndicator;
    }

    @NotNull
    public ProgressIndicator createProgressIndicator(boolean visible, @NotNull ProgressKey key) {
        if (key == null) {
            VcsLogProgress.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            EmptyProgressIndicator emptyProgressIndicator = new EmptyProgressIndicator();
            if (emptyProgressIndicator == null) {
                VcsLogProgress.$$$reportNull$$$0(5);
            }
            return emptyProgressIndicator;
        }
        VcsLogProgressIndicator vcsLogProgressIndicator = new VcsLogProgressIndicator(visible, key);
        if (vcsLogProgressIndicator == null) {
            VcsLogProgress.$$$reportNull$$$0(6);
        }
        return vcsLogProgressIndicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressIndicatorListener(@NotNull ProgressListener listener2, @Nullable Disposable parentDisposable) {
        if (listener2 == null) {
            VcsLogProgress.$$$reportNull$$$0(7);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myListeners.add(listener2);
            if (parentDisposable != null) {
                Disposer.register((Disposable)parentDisposable, () -> {
                    if (listener2 == null) {
                        VcsLogProgress.$$$reportNull$$$0(17);
                    }
                    this.removeProgressIndicatorListener(listener2);
                });
            }
            if (this.isRunning()) {
                Set<ProgressKey> keys = this.getRunningKeys();
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (listener2 == null) {
                        VcsLogProgress.$$$reportNull$$$0(16);
                    }
                    listener2.progressStarted(keys);
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressIndicatorListener(@NotNull ProgressListener listener2) {
        if (listener2 == null) {
            VcsLogProgress.$$$reportNull$$$0(8);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myListeners.remove(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.myLock;
        synchronized (object) {
            return !this.myTasksWithVisibleProgress.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Set<ProgressKey> getRunningKeys() {
        Object object = this.myLock;
        // MONITORENTER : object
        Set set2 = ContainerUtil.map2Set(this.myTasksWithVisibleProgress, VcsLogProgressIndicator::getKey);
        // MONITOREXIT : object
        if (set2 != null) return set2;
        VcsLogProgress.$$$reportNull$$$0(9);
        return set2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void started(@NotNull VcsLogProgressIndicator indicator) {
        if (indicator == null) {
            VcsLogProgress.$$$reportNull$$$0(10);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myDisposed) {
                indicator.cancel();
                return;
            }
            if (indicator.isVisible()) {
                Set<ProgressKey> oldKeys = this.getRunningKeys();
                this.myTasksWithVisibleProgress.add(indicator);
                if (this.myTasksWithVisibleProgress.size() == 1) {
                    ProgressKey key = indicator.getKey();
                    this.fireNotification(listener2 -> listener2.progressStarted(Collections.singleton(key)));
                } else {
                    this.keysUpdated(oldKeys);
                }
            } else {
                this.myTasksWithSilentProgress.add(indicator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopped(@NotNull VcsLogProgressIndicator indicator) {
        if (indicator == null) {
            VcsLogProgress.$$$reportNull$$$0(11);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (indicator.isVisible()) {
                this.myTasksWithVisibleProgress.remove(indicator);
                if (this.myTasksWithVisibleProgress.isEmpty()) {
                    this.fireNotification(ProgressListener::progressStopped);
                }
            } else {
                this.myTasksWithSilentProgress.remove(indicator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keysUpdated(@NotNull Set<ProgressKey> oldKeys) {
        if (oldKeys == null) {
            VcsLogProgress.$$$reportNull$$$0(12);
        }
        Object object = this.myLock;
        synchronized (object) {
            Set<ProgressKey> newKeys = this.getRunningKeys();
            if (!oldKeys.equals(newKeys)) {
                this.fireNotification(listener2 -> listener2.progressChanged(newKeys));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNotification(@NotNull Consumer<ProgressListener> action) {
        if (action == null) {
            VcsLogProgress.$$$reportNull$$$0(13);
        }
        Object object = this.myLock;
        synchronized (object) {
            ArrayList list2 = ContainerUtil.newArrayList(this.myListeners);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (action == null) {
                    VcsLogProgress.$$$reportNull$$$0(15);
                }
                list2.forEach(action);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            this.myDisposed = true;
            for (ProgressIndicator progressIndicator : this.myTasksWithVisibleProgress) {
                progressIndicator.cancel();
            }
            for (ProgressIndicator progressIndicator : this.myTasksWithSilentProgress) {
                progressIndicator.cancel();
            }
        }
    }

    public static void updateCurrentKey(@NotNull ProgressKey key) {
        ProgressIndicator indicator;
        if (key == null) {
            VcsLogProgress.$$$reportNull$$$0(14);
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) instanceof VcsLogProgressIndicator) {
            ((VcsLogProgressIndicator)indicator).updateKey(key);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/VcsLogProgress";
                break;
            }
            case 7: 
            case 8: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldKeys";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/VcsLogProgress";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createProgressIndicator";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunningKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createProgressIndicator";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addProgressIndicatorListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeProgressIndicatorListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "started";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "stopped";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "keysUpdated";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fireNotification";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateCurrentKey";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fireNotification$5";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addProgressIndicatorListener$2";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addProgressIndicatorListener$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ProgressKey {
        @NotNull
        private final String myName;

        public ProgressKey(@NotNull String name) {
            if (name == null) {
                ProgressKey.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProgressKey key = (ProgressKey)o;
            return Objects.equals(this.myName, key.myName);
        }

        public int hashCode() {
            return Objects.hash(this.myName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/data/VcsLogProgress$ProgressKey", "<init>"));
        }
    }

    public static interface ProgressListener {
        public void progressStarted(@NotNull Collection<ProgressKey> var1);

        public void progressChanged(@NotNull Collection<ProgressKey> var1);

        public void progressStopped();
    }

    private class VcsLogProgressIndicator
    extends AbstractProgressIndicatorBase {
        @NotNull
        private ProgressKey myKey;
        private final boolean myVisible;

        private VcsLogProgressIndicator(@NotNull boolean visible, ProgressKey key) {
            if (key == null) {
                VcsLogProgressIndicator.$$$reportNull$$$0(0);
            }
            this.myKey = key;
            this.myVisible = visible;
        }

        @Override
        public synchronized void start() {
            super.start();
            VcsLogProgress.this.started(this);
        }

        @Override
        public synchronized void stop() {
            super.stop();
            VcsLogProgress.this.stopped(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateKey(@NotNull ProgressKey key) {
            if (key == null) {
                VcsLogProgressIndicator.$$$reportNull$$$0(1);
            }
            Object object = VcsLogProgress.this.myLock;
            synchronized (object) {
                Set<ProgressKey> oldKeys = VcsLogProgress.this.getRunningKeys();
                this.myKey = key;
                VcsLogProgress.this.keysUpdated(oldKeys);
            }
        }

        public boolean isVisible() {
            return this.myVisible;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        public ProgressKey getKey() {
            Object object = VcsLogProgress.this.myLock;
            // MONITORENTER : object
            ProgressKey progressKey = this.myKey;
            // MONITOREXIT : object
            if (progressKey != null) return progressKey;
            VcsLogProgressIndicator.$$$reportNull$$$0(2);
            return progressKey;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/VcsLogProgress$VcsLogProgressIndicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/VcsLogProgress$VcsLogProgressIndicator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "updateKey";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

