/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.EmptyPermanentGraph;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsLogStorageImpl;
import com.intellij.vcs.log.graph.GraphColorManagerImpl;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.util.StopWatch;
import gnu.trove.TIntHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DataPack
extends DataPackBase {
    public static final DataPack EMPTY = DataPack.createEmptyInstance();
    @NotNull
    private final PermanentGraph<Integer> myPermanentGraph;

    DataPack(@NotNull RefsModel refsModel, @NotNull PermanentGraph<Integer> permanentGraph, @NotNull Map<VirtualFile, VcsLogProvider> providers, boolean full) {
        if (refsModel == null) {
            DataPack.$$$reportNull$$$0(0);
        }
        if (permanentGraph == null) {
            DataPack.$$$reportNull$$$0(1);
        }
        if (providers == null) {
            DataPack.$$$reportNull$$$0(2);
        }
        super(providers, refsModel, full);
        this.myPermanentGraph = permanentGraph;
    }

    @NotNull
    public static DataPack build(@NotNull List<? extends GraphCommit<Integer>> commits2, @NotNull Map<VirtualFile, CompressedRefs> refs, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogStorage storage2, boolean full) {
        PermanentGraph<Integer> permanentGraph;
        RefsModel refsModel;
        if (commits2 == null) {
            DataPack.$$$reportNull$$$0(3);
        }
        if (refs == null) {
            DataPack.$$$reportNull$$$0(4);
        }
        if (providers == null) {
            DataPack.$$$reportNull$$$0(5);
        }
        if (storage2 == null) {
            DataPack.$$$reportNull$$$0(6);
        }
        if (commits2.isEmpty()) {
            refsModel = new RefsModel(refs, ContainerUtil.newHashSet(), storage2, providers);
            permanentGraph = EmptyPermanentGraph.getInstance();
        } else {
            refsModel = new RefsModel(refs, DataPack.getHeads(commits2), storage2, providers);
            Function<Integer, Hash> hashGetter = VcsLogStorageImpl.createHashGetter(storage2);
            GraphColorManagerImpl colorManager = new GraphColorManagerImpl(refsModel, hashGetter, DataPack.getRefManagerMap(providers));
            Set<Integer> branches = DataPack.getBranchCommitHashIndexes(refsModel.getBranches(), storage2);
            StopWatch sw = StopWatch.start("building graph");
            permanentGraph = PermanentGraphImpl.newInstance(commits2, colorManager, branches);
            sw.report();
        }
        DataPack dataPack = new DataPack(refsModel, permanentGraph, providers, full);
        if (dataPack == null) {
            DataPack.$$$reportNull$$$0(7);
        }
        return dataPack;
    }

    @NotNull
    private static Set<Integer> getHeads(@NotNull List<? extends GraphCommit<Integer>> commits2) {
        if (commits2 == null) {
            DataPack.$$$reportNull$$$0(8);
        }
        TIntHashSet parents = new TIntHashSet();
        for (GraphCommit<Integer> graphCommit : commits2) {
            Iterator iterator = graphCommit.getParents().iterator();
            while (iterator.hasNext()) {
                int parent = (Integer)iterator.next();
                parents.add(parent);
            }
        }
        HashSet heads = ContainerUtil.newHashSet();
        for (GraphCommit<Integer> graphCommit : commits2) {
            if (parents.contains(((Integer)graphCommit.getId()).intValue())) continue;
            heads.add(graphCommit.getId());
        }
        HashSet hashSet = heads;
        if (hashSet == null) {
            DataPack.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    @NotNull
    private static Set<Integer> getBranchCommitHashIndexes(@NotNull Collection<VcsRef> branches, @NotNull VcsLogStorage storage2) {
        if (branches == null) {
            DataPack.$$$reportNull$$$0(10);
        }
        if (storage2 == null) {
            DataPack.$$$reportNull$$$0(11);
        }
        HashSet<Integer> result2 = new HashSet<Integer>();
        for (VcsRef vcsRef : branches) {
            result2.add(storage2.getCommitIndex(vcsRef.getCommitHash(), vcsRef.getRoot()));
        }
        HashSet<Integer> hashSet = result2;
        if (hashSet == null) {
            DataPack.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    @NotNull
    public static Map<VirtualFile, VcsLogRefManager> getRefManagerMap(@NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
        if (logProviders == null) {
            DataPack.$$$reportNull$$$0(13);
        }
        HashMap map2 = ContainerUtil.newHashMap();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : logProviders.entrySet()) {
            map2.put(entry.getKey(), entry.getValue().getReferenceManager());
        }
        HashMap hashMap = map2;
        if (hashMap == null) {
            DataPack.$$$reportNull$$$0(14);
        }
        return hashMap;
    }

    @NotNull
    private static DataPack createEmptyInstance() {
        RefsModel emptyModel = new RefsModel(ContainerUtil.newHashMap(), ContainerUtil.newHashSet(), VcsLogStorageImpl.EMPTY, ContainerUtil.newHashMap());
        DataPack dataPack = new DataPack(emptyModel, EmptyPermanentGraph.getInstance(), Collections.emptyMap(), false);
        if (dataPack == null) {
            DataPack.$$$reportNull$$$0(15);
        }
        return dataPack;
    }

    @NotNull
    public PermanentGraph<Integer> getPermanentGraph() {
        PermanentGraph<Integer> permanentGraph = this.myPermanentGraph;
        if (permanentGraph == null) {
            DataPack.$$$reportNull$$$0(16);
        }
        return permanentGraph;
    }

    public String toString() {
        return "{DataPack. " + this.myPermanentGraph.getAllCommits().size() + " commits in " + this.myLogProviders.keySet().size() + " roots}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refsModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentGraph";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/DataPack";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branches";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/DataPack";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeads";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchCommitHashIndexes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefManagerMap";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyInstance";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermanentGraph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getHeads";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBranchCommitHashIndexes";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRefManagerMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

