/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ui.JBListUpdater;
import com.intellij.openapi.ui.ListComponentUpdater;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

class PopupListAdapter<T>
implements PopupChooserBuilder.PopupComponentAdapter<T> {
    private final JList myList;
    private PopupChooserBuilder myBuilder;
    private ListWithFilter myListWithFilter;

    public PopupListAdapter(PopupChooserBuilder builder2, JList list2) {
        this.myBuilder = builder2;
        this.myList = list2;
    }

    public JComponent getComponent() {
        return this.myList;
    }

    public void setRenderer(ListCellRenderer renderer) {
        this.myList.setCellRenderer(renderer);
    }

    public void setItemChosenCallback(Consumer<T> callback2) {
        this.myBuilder.setItemChoosenCallback(() -> {
            Object selectedValue = this.myList.getSelectedValue();
            if (selectedValue != null) {
                callback2.consume(selectedValue);
            }
        });
    }

    public void setItemsChosenCallback(Consumer<Set<T>> callback2) {
        this.myBuilder.setItemChoosenCallback(() -> {
            List list2 = this.myList.getSelectedValuesList();
            callback2.consume((Object)(list2 != null ? ContainerUtil.newHashSet(list2) : Collections.emptySet()));
        });
    }

    public JScrollPane createScrollPane() {
        return this.myListWithFilter.getScrollPane();
    }

    public boolean hasOwnScrollPane() {
        return true;
    }

    @Nullable
    public BooleanFunction<KeyEvent> getKeyEventHandler() {
        return InputEvent::isConsumed;
    }

    public JComponent buildFinalComponent() {
        this.myListWithFilter = (ListWithFilter)ListWithFilter.wrap((JList)this.myList, (JScrollPane)((Object)new MyListWrapper(this.myList)), (Function)this.myBuilder.getItemsNamer());
        this.myListWithFilter.setAutoPackHeight(this.myBuilder.isAutoPackHeightOnFiltering());
        return this.myListWithFilter;
    }

    public void addMouseListener(MouseListener listener2) {
        this.myList.addMouseListener(listener2);
    }

    public void autoSelect() {
        JList list2 = this.myList;
        if (list2.getSelectedIndex() == -1) {
            list2.setSelectedIndex(0);
        }
    }

    public ListComponentUpdater getBackgroundUpdater() {
        return new JBListUpdater((JBList)this.myList);
    }

    public void setSelectedValue(T preselection, boolean shouldScroll) {
        this.myList.setSelectedValue(preselection, shouldScroll);
    }

    public void setItemSelectedCallback(Consumer<T> c) {
        this.myList.addListSelectionListener(e -> {
            Object selectedValue = this.myList.getSelectedValue();
            c.consume(selectedValue);
        });
    }

    public void setSelectionMode(int selection) {
        this.myList.setSelectionMode(selection);
    }

    public boolean checkResetFilter() {
        return this.myListWithFilter.resetFilter();
    }

    private class MyListWrapper
    extends JBScrollPane
    implements DataProvider {
        private final JList myList;

        private MyListWrapper(JList list2) {
            super(UIUtil.isUnderAquaLookAndFeel() ? 0 : -1);
            list2.setVisibleRowCount(PopupListAdapter.this.myBuilder.getVisibleRowCount());
            this.setViewportView(list2);
            if (PopupListAdapter.this.myBuilder.isAutoselectOnMouseMove()) {
                ListUtil.installAutoSelectOnMouseMove((JList)list2);
            }
            ScrollingUtil.installActions((JList)list2);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.myList = list2;
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (PlatformDataKeys.SELECTED_ITEM.is(dataId)) {
                return this.myList.getSelectedValue();
            }
            if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
                return this.myList.getSelectedValues();
            }
            return null;
        }

        public void setBorder(Border border) {
            if (this.myList != null) {
                this.myList.setBorder(border);
            }
        }

        public void requestFocus() {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myList, true));
        }

        public synchronized void addMouseListener(MouseListener l) {
            this.myList.addMouseListener(l);
        }
    }
}

