/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateOrStatusOptionsDialog;
import java.util.LinkedHashMap;

public interface ActionInfo {
    public static final ActionInfo UPDATE = new ActionInfo(){

        @Override
        public boolean showOptions(Project project) {
            return ProjectLevelVcsManagerEx.getInstanceEx(project).getOptions(VcsConfiguration.StandardOption.UPDATE).getValue();
        }

        @Override
        public UpdateEnvironment getEnvironment(AbstractVcs vcs) {
            return vcs.getUpdateEnvironment();
        }

        @Override
        public String getActionName() {
            return VcsBundle.message((String)"action.name.update", (Object[])new Object[0]);
        }

        @Override
        public UpdateOrStatusOptionsDialog createOptionsDialog(final Project project, LinkedHashMap<Configurable, AbstractVcs> envToConfMap, final String scopeName) {
            return new UpdateOrStatusOptionsDialog(project, envToConfMap){

                @Override
                protected String getRealTitle() {
                    return VcsBundle.message((String)"action.display.name.update.scope", (Object[])new Object[]{scopeName});
                }

                @Override
                protected String getActionNameForDimensions() {
                    return "update";
                }

                protected boolean isToBeShown() {
                    return ProjectLevelVcsManagerEx.getInstanceEx(project).getOptions(VcsConfiguration.StandardOption.UPDATE).getValue();
                }

                protected void setToBeShown(boolean value, boolean onOk) {
                    if (onOk) {
                        ProjectLevelVcsManagerEx.getInstanceEx(project).getOptions(VcsConfiguration.StandardOption.UPDATE).setValue(value);
                    }
                }
            };
        }

        @Override
        public String getActionName(String scopeName) {
            return VcsBundle.message((String)"action.name.update.scope", (Object[])new Object[]{scopeName});
        }

        @Override
        public String getGroupName(FileGroup fileGroup) {
            return fileGroup.getUpdateName();
        }

        @Override
        public boolean canGroupByChangelist() {
            return true;
        }

        @Override
        public boolean canChangeFileStatus() {
            return false;
        }
    };
    public static final ActionInfo STATUS = new ActionInfo(){

        @Override
        public boolean showOptions(Project project) {
            return ProjectLevelVcsManagerEx.getInstanceEx(project).getOptions(VcsConfiguration.StandardOption.STATUS).getValue();
        }

        @Override
        public UpdateEnvironment getEnvironment(AbstractVcs vcs) {
            return vcs.getStatusEnvironment();
        }

        @Override
        public UpdateOrStatusOptionsDialog createOptionsDialog(final Project project, LinkedHashMap<Configurable, AbstractVcs> envToConfMap, final String scopeName) {
            return new UpdateOrStatusOptionsDialog(project, envToConfMap){

                @Override
                protected String getRealTitle() {
                    return VcsBundle.message((String)"action.display.name.check.scope.status", (Object[])new Object[]{scopeName});
                }

                @Override
                protected String getActionNameForDimensions() {
                    return "status";
                }

                protected boolean isToBeShown() {
                    return ProjectLevelVcsManagerEx.getInstanceEx(project).getOptions(VcsConfiguration.StandardOption.STATUS).getValue();
                }

                protected void setToBeShown(boolean value, boolean onOk) {
                    if (onOk) {
                        ProjectLevelVcsManagerEx.getInstanceEx(project).getOptions(VcsConfiguration.StandardOption.STATUS).setValue(value);
                    }
                }
            };
        }

        @Override
        public String getActionName() {
            return VcsBundle.message((String)"action.name.check.status", (Object[])new Object[0]);
        }

        @Override
        public String getActionName(String scopeName) {
            return VcsBundle.message((String)"action.name.check.scope.status", (Object[])new Object[]{scopeName});
        }

        @Override
        public String getGroupName(FileGroup fileGroup) {
            return fileGroup.getStatusName();
        }

        @Override
        public boolean canGroupByChangelist() {
            return false;
        }

        @Override
        public boolean canChangeFileStatus() {
            return true;
        }
    };
    public static final ActionInfo INTEGRATE = new ActionInfo(){

        @Override
        public boolean showOptions(Project project) {
            return true;
        }

        @Override
        public UpdateEnvironment getEnvironment(AbstractVcs vcs) {
            return vcs.getIntegrateEnvironment();
        }

        @Override
        public UpdateOrStatusOptionsDialog createOptionsDialog(Project project, LinkedHashMap<Configurable, AbstractVcs> envToConfMap, final String scopeName) {
            return new UpdateOrStatusOptionsDialog(project, envToConfMap){

                @Override
                protected String getRealTitle() {
                    return VcsBundle.message((String)"action.display.name.integrate.scope", (Object[])new Object[]{scopeName});
                }

                @Override
                protected String getActionNameForDimensions() {
                    return "integrate";
                }

                protected boolean canBeHidden() {
                    return false;
                }

                protected boolean isToBeShown() {
                    return true;
                }

                protected void setToBeShown(boolean value, boolean onOk) {
                }
            };
        }

        @Override
        public boolean canChangeFileStatus() {
            return true;
        }

        @Override
        public String getActionName(String scopeName) {
            return VcsBundle.message((String)"action.name.integrate.scope", (Object[])new Object[]{scopeName});
        }

        @Override
        public String getActionName() {
            return VcsBundle.message((String)"action.name.integrate", (Object[])new Object[0]);
        }

        @Override
        public String getGroupName(FileGroup fileGroup) {
            return fileGroup.getUpdateName();
        }

        @Override
        public boolean canGroupByChangelist() {
            return false;
        }
    };

    public boolean showOptions(Project var1);

    public UpdateEnvironment getEnvironment(AbstractVcs var1);

    public UpdateOrStatusOptionsDialog createOptionsDialog(Project var1, LinkedHashMap<Configurable, AbstractVcs> var2, String var3);

    public String getActionName(String var1);

    public String getActionName();

    public String getGroupName(FileGroup var1);

    public boolean canGroupByChangelist();

    public boolean canChangeFileStatus();
}

