/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class VcsToolbarLabelAction
extends DumbAwareAction
implements CustomComponentAction {
    private static final String DEFAULT_LABEL = "VCS:";

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(false);
        Project project = e.getProject();
        e.getPresentation().setVisible(project != null && ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss());
    }

    public void actionPerformed(AnActionEvent e) {
    }

    public JComponent createCustomComponent(Presentation presentation) {
        return new VcsToolbarLabel().withFont(JBUI.Fonts.toolbarFont()).withBorder((Border)JBUI.Borders.empty((int)0, (int)6, (int)0, (int)5));
    }

    private static String getConsolidatedVcsName(Project project) {
        AbstractVcs[] vcss;
        List ids;
        String name = DEFAULT_LABEL;
        if (project != null && (ids = Arrays.stream(vcss = ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss()).map(vcs -> vcs.getShortName()).distinct().collect(Collectors.toList())).size() == 1) {
            name = (String)ids.get(0) + ":";
        }
        return name;
    }

    private static class VcsToolbarLabel
    extends JBLabel {
        public VcsToolbarLabel() {
            super(VcsToolbarLabelAction.DEFAULT_LABEL);
        }

        public String getText() {
            Project project = (Project)DataManager.getInstance().getDataContext((Component)((Object)this)).getData(CommonDataKeys.PROJECT);
            return VcsToolbarLabelAction.getConsolidatedVcsName(project);
        }
    }
}

