/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.codeHighlighting.ColorGenerator;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationsSettings {
    private static final int ANCHORS_COUNT = 5;
    private static final int COLORS_BETWEEN_ANCHORS = 4;
    private static final int SHUFFLE_STEP = 4;
    static final List<ColorKey> ANCHOR_COLOR_KEYS = AnnotationsSettings.createColorKeys(5);

    @NotNull
    private static List<ColorKey> createColorKeys(int count) {
        ArrayList<ColorKey> keys = new ArrayList<ColorKey>();
        for (int i = 0; i < count; ++i) {
            keys.add(ColorKey.createColorKey((String)("VCS_ANNOTATIONS_COLOR_" + (i + 1))));
        }
        ArrayList<ColorKey> arrayList = keys;
        if (arrayList == null) {
            AnnotationsSettings.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public static AnnotationsSettings getInstance() {
        return (AnnotationsSettings)ServiceManager.getService(AnnotationsSettings.class);
    }

    @NotNull
    public List<Color> getAuthorsColors(@Nullable EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        }
        List<Color> colors = this.getOrderedColors(scheme2);
        ArrayList<Color> authorColors = new ArrayList<Color>();
        for (int i = 0; i < 4; ++i) {
            for (int k = 0; k <= colors.size() / 4; ++k) {
                int index = k * 4 + i;
                if (index >= colors.size()) continue;
                authorColors.add(colors.get(index));
            }
        }
        ArrayList<Color> arrayList = authorColors;
        if (arrayList == null) {
            AnnotationsSettings.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public List<Color> getOrderedColors(@Nullable EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        }
        ArrayList<Color> anchorColors = new ArrayList<Color>();
        for (ColorKey key : ANCHOR_COLOR_KEYS) {
            ContainerUtil.addIfNotNull(anchorColors, (Object)scheme2.getColor(key));
        }
        List<Color> list2 = ColorGenerator.generateLinearColorSequence(anchorColors, 4);
        if (list2 == null) {
            AnnotationsSettings.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    List<Integer> getAnchorIndexes(@Nullable EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        }
        ArrayList<Integer> result2 = new ArrayList<Integer>(5);
        int count = 0;
        for (ColorKey key : ANCHOR_COLOR_KEYS) {
            if (scheme2.getColor(key) != null) {
                result2.add(count);
                count += 5;
                continue;
            }
            result2.add(null);
        }
        ArrayList<Integer> arrayList = result2;
        if (arrayList == null) {
            AnnotationsSettings.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/vcs/actions/AnnotationsSettings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createColorKeys";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthorsColors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderedColors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnchorIndexes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

