/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="UnknownFeatures", storages={@Storage(value="$WORKSPACE_FILE$")})
public class UnknownFeaturesCollector
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String FEATURE_ID = "featureType";
    @NonNls
    private static final String IMPLEMENTATION_NAME = "implementationName";
    private final Set<UnknownFeature> myUnknownFeatures = new HashSet<UnknownFeature>();
    private final Set<UnknownFeature> myIgnoredUnknownFeatures = new HashSet<UnknownFeature>();

    public static UnknownFeaturesCollector getInstance(Project project) {
        return (UnknownFeaturesCollector)ServiceManager.getService((Project)project, UnknownFeaturesCollector.class);
    }

    public void registerUnknownRunConfiguration(@NotNull String configurationId, @Nullable String factoryName) {
        if (configurationId == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(0);
        }
        this.registerUnknownFeature("com.intellij.configurationType", configurationId, "Run Configuration", StringUtil.notNullize((String)factoryName, (String)configurationId));
    }

    public void registerUnknownFeature(@NotNull String featureType, @NotNull String implementationName, @NotNull String featureDisplayName) {
        if (featureType == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(1);
        }
        if (implementationName == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(2);
        }
        if (featureDisplayName == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(3);
        }
        this.registerUnknownFeature(featureType, implementationName, featureDisplayName, implementationName);
    }

    public void registerUnknownFeature(@NotNull String featureType, @NotNull String implementationName, @NotNull String featureDisplayName, @NotNull String implementationDisplayName) {
        UnknownFeature feature;
        if (featureType == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(4);
        }
        if (implementationName == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(5);
        }
        if (featureDisplayName == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(6);
        }
        if (implementationDisplayName == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(7);
        }
        if (!this.isIgnored(feature = new UnknownFeature(featureType, featureDisplayName, implementationName, implementationDisplayName))) {
            this.myUnknownFeatures.add(feature);
        }
    }

    public boolean isIgnored(UnknownFeature feature) {
        return this.myIgnoredUnknownFeatures.contains(feature);
    }

    public void ignoreFeature(UnknownFeature feature) {
        this.myIgnoredUnknownFeatures.add(feature);
    }

    public Set<UnknownFeature> getUnknownFeatures() {
        return this.myUnknownFeatures;
    }

    @Nullable
    public Element getState() {
        if (this.myIgnoredUnknownFeatures.isEmpty()) {
            return null;
        }
        Element ignored = new Element("ignored");
        for (UnknownFeature feature : this.myIgnoredUnknownFeatures) {
            Element option = new Element("option");
            option.setAttribute(FEATURE_ID, feature.getFeatureType());
            option.setAttribute(IMPLEMENTATION_NAME, feature.getImplementationName());
            ignored.addContent(option);
        }
        return ignored;
    }

    public void loadState(@NotNull Element state2) {
        if (state2 == null) {
            UnknownFeaturesCollector.$$$reportNull$$$0(8);
        }
        this.myIgnoredUnknownFeatures.clear();
        for (Element element : state2.getChildren()) {
            this.myIgnoredUnknownFeatures.add(new UnknownFeature(element.getAttributeValue(FEATURE_ID), null, element.getAttributeValue(IMPLEMENTATION_NAME), null));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationId";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = FEATURE_ID;
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = IMPLEMENTATION_NAME;
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureDisplayName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementationDisplayName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/UnknownFeaturesCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerUnknownRunConfiguration";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "registerUnknownFeature";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

