/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.IdeUICustomization;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleConfigurableEditor
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(SingleConfigurableEditor.class);
    private Project myProject;
    private Configurable myConfigurable;
    private JComponent myCenterPanel;
    private final String myDimensionKey;
    private final boolean myShowApplyButton;
    private boolean mySaveAllOnClose;

    public SingleConfigurableEditor(@Nullable Project project, @NotNull Configurable configurable, @NonNls String dimensionKey, boolean showApplyButton, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        if (configurable == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(0);
        }
        if (ideModalityType == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(1);
        }
        super(project, true, ideModalityType);
        this.myDimensionKey = dimensionKey;
        this.myShowApplyButton = showApplyButton;
        String title = SingleConfigurableEditor.createTitleString(configurable);
        if (project != null && project.isDefault()) {
            title = OptionsBundle.message((String)"title.for.new.projects", (Object[])new Object[]{title, StringUtil.capitalize((String)IdeUICustomization.getInstance().getProjectConceptName())});
        }
        this.setTitle(title);
        this.myProject = project;
        this.myConfigurable = configurable;
        this.init();
        this.myConfigurable.reset();
    }

    public SingleConfigurableEditor(Component parent, @NotNull Configurable configurable, String dimensionServiceKey, boolean showApplyButton, DialogWrapper.IdeModalityType ideModalityType) {
        if (configurable == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(2);
        }
        super(parent, true);
        this.myDimensionKey = dimensionServiceKey;
        this.myShowApplyButton = showApplyButton;
        this.setTitle(SingleConfigurableEditor.createTitleString(configurable));
        this.myConfigurable = configurable;
        this.init();
        this.myConfigurable.reset();
    }

    public SingleConfigurableEditor(@Nullable Project project, Configurable configurable, @NonNls String dimensionKey, boolean showApplyButton) {
        this(project, configurable, dimensionKey, showApplyButton, DialogWrapper.IdeModalityType.IDE);
    }

    public SingleConfigurableEditor(Component parent, Configurable configurable, String dimensionServiceKey, boolean showApplyButton) {
        this(parent, configurable, dimensionServiceKey, showApplyButton, DialogWrapper.IdeModalityType.IDE);
    }

    public SingleConfigurableEditor(@Nullable Project project, Configurable configurable, @NonNls String dimensionKey, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(3);
        }
        this(project, configurable, dimensionKey, true, ideModalityType);
    }

    public SingleConfigurableEditor(@Nullable Project project, Configurable configurable, @NonNls String dimensionKey) {
        this(project, configurable, dimensionKey, true);
    }

    public SingleConfigurableEditor(Component parent, Configurable configurable, String dimensionServiceKey) {
        this(parent, configurable, dimensionServiceKey, true);
    }

    public SingleConfigurableEditor(@Nullable Project project, Configurable configurable, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(4);
        }
        this(project, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable), ideModalityType);
    }

    public SingleConfigurableEditor(@Nullable Project project, Configurable configurable) {
        this(project, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable));
    }

    public SingleConfigurableEditor(Component parent, Configurable configurable) {
        this(parent, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable));
    }

    public Configurable getConfigurable() {
        return this.myConfigurable;
    }

    public Project getProject() {
        return this.myProject;
    }

    private static String createTitleString(@NotNull Configurable configurable) {
        String displayName;
        if (configurable == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(5);
        }
        LOG.assertTrue((displayName = configurable.getDisplayName()) != null, (Object)configurable.getClass().getName());
        return displayName.replaceAll("\n", " ");
    }

    protected String getDimensionServiceKey() {
        if (this.myDimensionKey == null) {
            return super.getDimensionServiceKey();
        }
        return this.myDimensionKey;
    }

    @NotNull
    protected Action[] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getOKAction());
        actions.add(this.getCancelAction());
        if (this.myShowApplyButton) {
            actions.add(new ApplyAction());
        }
        if (this.myConfigurable.getHelpTopic() != null) {
            actions.add(this.getHelpAction());
        }
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(6);
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.myConfigurable.getHelpTopic());
    }

    protected void doOKAction() {
        try {
            if (this.myConfigurable.isModified()) {
                this.myConfigurable.apply();
                this.mySaveAllOnClose = true;
            }
        }
        catch (ConfigurationException e) {
            if (e.getMessage() != null) {
                if (this.myProject != null) {
                    Messages.showMessageDialog((Project)this.myProject, (String)e.getMessage(), (String)e.getTitle(), (Icon)Messages.getErrorIcon());
                } else {
                    Messages.showMessageDialog((Component)this.getRootPane(), (String)e.getMessage(), (String)e.getTitle(), (Icon)Messages.getErrorIcon());
                }
            }
            return;
        }
        super.doOKAction();
    }

    protected static String createDimensionKey(Configurable configurable) {
        String displayName = configurable.getDisplayName();
        displayName = displayName.replaceAll("\n", "_").replaceAll(" ", "_");
        return "#" + displayName;
    }

    protected JComponent createCenterPanel() {
        this.myCenterPanel = this.myConfigurable.createComponent();
        return this.myCenterPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        Configurable configurable = this.myConfigurable;
        JComponent preferred = configurable == null ? null : configurable.getPreferredFocusedComponent();
        return preferred == null ? IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myCenterPanel) : preferred;
    }

    public void dispose() {
        super.dispose();
        this.myConfigurable.disposeUIResources();
        this.myConfigurable = null;
        if (this.mySaveAllOnClose) {
            ApplicationManager.getApplication().saveAll();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModalityType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/ex/SingleConfigurableEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/ex/SingleConfigurableEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTitleString";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class ApplyAction
    extends AbstractAction {
        private final Alarm myUpdateAlarm;

        public ApplyAction() {
            super(CommonBundle.getApplyButtonText());
            this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
            Runnable updateRequest = new Runnable(){

                @Override
                public void run() {
                    if (!SingleConfigurableEditor.this.isShowing()) {
                        return;
                    }
                    try {
                        ApplyAction.this.setEnabled(SingleConfigurableEditor.this.myConfigurable != null && SingleConfigurableEditor.this.myConfigurable.isModified());
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        // empty catch block
                    }
                    ApplyAction.this.addUpdateRequest(this);
                }
            };
            SwingUtilities.invokeLater(() -> {
                if (SingleConfigurableEditor.this.myConfigurable != null) {
                    this.addUpdateRequest(updateRequest);
                }
            });
        }

        private void addUpdateRequest(Runnable updateRequest) {
            this.myUpdateAlarm.addRequest(updateRequest, 500, ModalityState.stateForComponent((Component)SingleConfigurableEditor.this.getWindow()));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (SingleConfigurableEditor.this.myPerformAction) {
                return;
            }
            try {
                SingleConfigurableEditor.this.myPerformAction = true;
                if (SingleConfigurableEditor.this.myConfigurable.isModified()) {
                    SingleConfigurableEditor.this.myConfigurable.apply();
                    SingleConfigurableEditor.this.mySaveAllOnClose = true;
                    SingleConfigurableEditor.this.setCancelButtonText(CommonBundle.getCloseButtonText());
                }
            }
            catch (ConfigurationException e) {
                if (SingleConfigurableEditor.this.myProject != null) {
                    Messages.showMessageDialog((Project)SingleConfigurableEditor.this.myProject, (String)e.getMessage(), (String)e.getTitle(), (Icon)Messages.getErrorIcon());
                } else {
                    Messages.showMessageDialog((Component)SingleConfigurableEditor.this.getRootPane(), (String)e.getMessage(), (String)e.getTitle(), (Icon)Messages.getErrorIcon());
                }
            }
            finally {
                SingleConfigurableEditor.this.myPerformAction = false;
            }
        }
    }
}

