/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.util.Getter;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldRegionImpl
extends RangeMarkerImpl
implements FoldRegion,
Getter<FoldRegionImpl> {
    private boolean myIsExpanded;
    private final EditorImpl myEditor;
    private final String myPlaceholderText;
    private final FoldingGroup myGroup;
    private final boolean myShouldNeverExpand;
    private boolean myDocumentRegionWasChanged;

    FoldRegionImpl(@NotNull EditorImpl editor, int startOffset, int endOffset, @NotNull String placeholder, @Nullable FoldingGroup group, boolean shouldNeverExpand) {
        if (editor == null) {
            FoldRegionImpl.$$$reportNull$$$0(0);
        }
        if (placeholder == null) {
            FoldRegionImpl.$$$reportNull$$$0(1);
        }
        super(editor.getDocument(), startOffset, endOffset, false);
        this.myGroup = group;
        this.myShouldNeverExpand = shouldNeverExpand;
        this.myIsExpanded = true;
        this.myEditor = editor;
        this.myPlaceholderText = placeholder;
    }

    public boolean isExpanded() {
        return this.myIsExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.setExpanded(expanded, true);
    }

    void setExpanded(boolean expanded, boolean notify) {
        FoldingModelImpl foldingModel = this.myEditor.getFoldingModel();
        if (this.myGroup == null) {
            FoldRegionImpl.doSetExpanded(expanded, foldingModel, this, notify);
        } else {
            for (FoldRegion region : foldingModel.getGroupedRegions(this.myGroup)) {
                FoldRegionImpl.doSetExpanded(expanded, foldingModel, region, notify || region != this);
                if (region.isExpanded() == expanded) continue;
                for (FoldRegion regionToRevert : foldingModel.getGroupedRegions(this.myGroup)) {
                    if (regionToRevert == region) break;
                    FoldRegionImpl.doSetExpanded(!expanded, foldingModel, regionToRevert, notify || region != this);
                }
                return;
            }
        }
    }

    public FoldRegionImpl get() {
        return this;
    }

    private static void doSetExpanded(boolean expanded, FoldingModelImpl foldingModel, FoldRegion region, boolean notify) {
        if (expanded) {
            foldingModel.expandFoldRegion(region, notify);
        } else {
            foldingModel.collapseFoldRegion(region, notify);
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.intervalStart() < this.intervalEnd();
    }

    void setExpandedInternal(boolean toExpand) {
        this.myIsExpanded = toExpand;
    }

    @NotNull
    public String getPlaceholderText() {
        String string = this.myPlaceholderText;
        if (string == null) {
            FoldRegionImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    @Nullable
    public FoldingGroup getGroup() {
        return this.myGroup;
    }

    public boolean shouldNeverExpand() {
        return this.myShouldNeverExpand;
    }

    boolean hasDocumentRegionChanged() {
        return this.myDocumentRegionWasChanged;
    }

    void resetDocumentRegionChanged() {
        this.myDocumentRegionWasChanged = false;
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            FoldRegionImpl.$$$reportNull$$$0(3);
        }
        if (this.isValid()) {
            int oldStart = this.intervalStart();
            int oldEnd = this.intervalEnd();
            int changeStart = e.getOffset();
            int changeEnd = e.getOffset() + e.getOldLength();
            if (changeStart < oldEnd && changeEnd > oldStart) {
                this.myDocumentRegionWasChanged = true;
            }
        }
        super.changedUpdateImpl(e);
        if (this.isValid()) {
            this.alignToSurrogateBoundaries();
        } else {
            this.myEditor.getFoldingModel().removeRegionFromGroup(this);
        }
        this.myEditor.getFoldingModel().clearCachedValues();
    }

    @Override
    protected void onReTarget(int startOffset, int endOffset, int destOffset) {
        this.alignToSurrogateBoundaries();
    }

    private void alignToSurrogateBoundaries() {
        DocumentEx document = this.getDocument();
        int start = this.intervalStart();
        int end = this.intervalEnd();
        if (DocumentUtil.isInsideSurrogatePair(document, start)) {
            this.setIntervalStart(start - 1);
        }
        if (DocumentUtil.isInsideSurrogatePair(document, end)) {
            this.setIntervalEnd(end - 1);
        }
    }

    @Override
    public void dispose() {
        this.myEditor.getFoldingModel().removeRegionFromTree(this);
    }

    @Override
    public String toString() {
        return "FoldRegion " + (this.myIsExpanded ? "-" : "+") + "(" + this.getStartOffset() + ":" + this.getEndOffset() + ")" + (this.isValid() ? "" : "(invalid)") + ", placeholder='" + this.myPlaceholderText + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/FoldRegionImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/FoldRegionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholderText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "changedUpdateImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

