/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.apply;

import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlainSimplePatchApplier {
    private static final Logger LOG = Logger.getInstance(PlainSimplePatchApplier.class);
    @NotNull
    private final List<PatchHunk> myHunks;
    @NotNull
    private final CharSequence myText;
    @NotNull
    private final LineOffsets myLineOffsets;
    private final StringBuilder sb;
    private int baseLine;
    private int patchedLine;

    @Nullable
    public static String apply(@NotNull CharSequence text2, @NotNull List<PatchHunk> hunks) {
        if (text2 == null) {
            PlainSimplePatchApplier.$$$reportNull$$$0(0);
        }
        if (hunks == null) {
            PlainSimplePatchApplier.$$$reportNull$$$0(1);
        }
        return new PlainSimplePatchApplier(text2, hunks).execute();
    }

    private PlainSimplePatchApplier(@NotNull CharSequence text2, @NotNull List<PatchHunk> hunks) {
        if (text2 == null) {
            PlainSimplePatchApplier.$$$reportNull$$$0(2);
        }
        if (hunks == null) {
            PlainSimplePatchApplier.$$$reportNull$$$0(3);
        }
        this.sb = new StringBuilder();
        this.baseLine = 0;
        this.patchedLine = 0;
        this.myText = text2;
        this.myHunks = hunks;
        this.myLineOffsets = LineOffsetsUtil.create(text2);
    }

    @Nullable
    private String execute() {
        if (this.myHunks.isEmpty()) {
            return this.myText.toString();
        }
        try {
            for (PatchHunk hunk : this.myHunks) {
                this.appendUnchangedLines(hunk.getStartLineBefore());
                this.checkContextLines(hunk);
                this.applyChangedLines(hunk);
            }
            if (!this.handleLastLine()) {
                this.appendUnchangedLines(this.myLineOffsets.getLineCount());
            }
            return this.sb.toString();
        }
        catch (PatchApplyException e) {
            LOG.debug((Throwable)e);
            return null;
        }
    }

    private boolean handleLastLine() {
        List lastHunkLines = ((PatchHunk)ObjectUtils.notNull((Object)ContainerUtil.getLastItem(this.myHunks))).getLines();
        PatchLine lastBaseLine = (PatchLine)ContainerUtil.findLast((List)lastHunkLines, line -> line.getType() != PatchLine.Type.ADD);
        PatchLine lastPatchedLine = (PatchLine)ContainerUtil.findLast((List)lastHunkLines, line -> line.getType() != PatchLine.Type.REMOVE);
        if (lastBaseLine != null) {
            boolean lastLineAlreadyApplied;
            boolean bl = lastLineAlreadyApplied = !lastBaseLine.isSuppressNewLine() && this.baseLine + 1 == this.myLineOffsets.getLineCount() && this.getLineContent(this.baseLine).length() == 0 || lastBaseLine.isSuppressNewLine() && this.baseLine == this.myLineOffsets.getLineCount();
            if (lastLineAlreadyApplied) {
                boolean isNoNewlinePatched;
                boolean bl2 = isNoNewlinePatched = lastPatchedLine != null ? lastPatchedLine.isSuppressNewLine() : lastBaseLine.isSuppressNewLine();
                if (!isNoNewlinePatched && this.patchedLine > 0) {
                    this.sb.append('\n');
                }
                return true;
            }
            return false;
        }
        if (this.baseLine == 0 && this.myText.length() == 0) {
            boolean isNoNewlinePatched;
            boolean bl = isNoNewlinePatched = lastPatchedLine != null && lastPatchedLine.isSuppressNewLine();
            if (!isNoNewlinePatched && this.patchedLine > 0) {
                this.sb.append('\n');
            }
            return true;
        }
        return false;
    }

    private void checkContextLines(@NotNull PatchHunk hunk) {
        if (hunk == null) {
            PlainSimplePatchApplier.$$$reportNull$$$0(4);
        }
        int baseStart = hunk.getStartLineBefore();
        int baseEnd = hunk.getEndLineBefore();
        int patchedStart = hunk.getStartLineAfter();
        int patchedEnd = hunk.getEndLineAfter();
        if (this.baseLine != baseStart) {
            PlainSimplePatchApplier.error(String.format("Unexpected hunk base start: expected  - %s, actual - %s", this.baseLine, baseStart));
        }
        if (this.patchedLine != patchedStart) {
            PlainSimplePatchApplier.error(String.format("Unexpected hunk patched start: expected  - %s, actual - %s", this.patchedLine, patchedStart));
        }
        if (baseEnd > this.myLineOffsets.getLineCount()) {
            PlainSimplePatchApplier.error(String.format("Unexpected hunk base end: total lines  - %s, hunk end - %s", this.myLineOffsets.getLineCount(), baseEnd));
        }
        int baseCount = ContainerUtil.count((Iterable)hunk.getLines(), patchLine -> patchLine.getType() != PatchLine.Type.ADD);
        int patchedCount = ContainerUtil.count((Iterable)hunk.getLines(), patchLine -> patchLine.getType() != PatchLine.Type.REMOVE);
        if (baseCount != baseEnd - baseStart) {
            PlainSimplePatchApplier.error(String.format("Unexpected hunk base body: expected - %s, actual - %s", baseEnd - baseStart, baseCount));
        }
        if (patchedCount != patchedEnd - patchedStart) {
            PlainSimplePatchApplier.error(String.format("Unexpected hunk patched body: expected - %s, actual - %s", patchedEnd - patchedStart, patchedCount));
        }
        int count = 0;
        for (PatchLine patchLine2 : hunk.getLines()) {
            String actualContent;
            if (patchLine2.getType() == PatchLine.Type.ADD) continue;
            CharSequence expectedContent = this.getLineContent(baseStart + count);
            if (!StringUtil.equals((CharSequence)expectedContent, (CharSequence)(actualContent = patchLine2.getText()))) {
                PlainSimplePatchApplier.error(String.format("Unexpected hunk content: expected - '%s', actual - '%s'", expectedContent, patchLine2));
            }
            ++count;
        }
    }

    private void applyChangedLines(@NotNull PatchHunk hunk) {
        if (hunk == null) {
            PlainSimplePatchApplier.$$$reportNull$$$0(5);
        }
        for (PatchLine patchLine : hunk.getLines()) {
            if (patchLine.getType() == PatchLine.Type.REMOVE) continue;
            this.appendLine(patchLine.getText());
        }
        this.baseLine = hunk.getEndLineBefore();
    }

    private void appendUnchangedLines(int untilLine) {
        if (this.baseLine > untilLine) {
            PlainSimplePatchApplier.error(String.format("Unexpected base line: expected - %s, actual - %s", this.baseLine, untilLine));
        }
        if (untilLine > this.myLineOffsets.getLineCount()) {
            PlainSimplePatchApplier.error(String.format("Unexpected base line: total lines - %s, actual - %s", this.myLineOffsets.getLineCount(), untilLine));
        }
        for (int i = this.baseLine; i < untilLine; ++i) {
            this.appendLine(this.getLineContent(i));
        }
        this.baseLine = untilLine;
    }

    private void appendLine(CharSequence lineContent) {
        if (this.patchedLine > 0) {
            this.sb.append('\n');
        }
        this.sb.append(lineContent);
        ++this.patchedLine;
    }

    @NotNull
    private CharSequence getLineContent(int line) {
        CharSequence charSequence = this.myText.subSequence(this.myLineOffsets.getLineStart(line), this.myLineOffsets.getLineEnd(line));
        if (charSequence == null) {
            PlainSimplePatchApplier.$$$reportNull$$$0(6);
        }
        return charSequence;
    }

    private static void error(@NotNull String error) {
        if (error == null) {
            PlainSimplePatchApplier.$$$reportNull$$$0(7);
        }
        throw new PatchApplyException(error);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hunks";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hunk";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/patch/apply/PlainSimplePatchApplier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/patch/apply/PlainSimplePatchApplier";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkContextLines";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyChangedLines";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PatchApplyException
    extends RuntimeException {
        public PatchApplyException(String message) {
            super(message);
        }
    }
}

