/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.json.JsonBundle;
import com.intellij.json.codeinsight.JsonLiteralChecker;
import com.intellij.json.highlighting.JsonSyntaxHighlighterFactory;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsonLiteralAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        block8: {
            JsonLiteralChecker[] extensions;
            block9: {
                block7: {
                    if (element == null) {
                        JsonLiteralAnnotator.$$$reportNull$$$0(0);
                    }
                    if (holder == null) {
                        JsonLiteralAnnotator.$$$reportNull$$$0(1);
                    }
                    extensions = (JsonLiteralChecker[])JsonLiteralChecker.EP_NAME.getExtensions();
                    if (!(element instanceof JsonReferenceExpression)) break block7;
                    JsonLiteralAnnotator.highlightPropertyKey(element, holder);
                    break block8;
                }
                if (!(element instanceof JsonStringLiteral)) break block9;
                JsonStringLiteral stringLiteral = (JsonStringLiteral)element;
                int elementOffset = element.getTextOffset();
                JsonLiteralAnnotator.highlightPropertyKey(element, holder);
                String text2 = JsonPsiUtil.getElementTextWithoutHostEscaping(element);
                int length = text2.length();
                if (length <= 1 || text2.charAt(0) != text2.charAt(length - 1) || JsonPsiUtil.isEscapedChar(text2, length - 1)) {
                    holder.createErrorAnnotation(element, JsonBundle.message("syntax.error.missing.closing.quote", new Object[0]));
                }
                List<Pair<TextRange, String>> fragments = stringLiteral.getTextFragments();
                for (Pair<TextRange, String> fragment : fragments) {
                    for (JsonLiteralChecker checker : extensions) {
                        String error;
                        if (!checker.isApplicable(element) || (error = checker.getErrorForStringFragment((String)fragment.getSecond())) == null) continue;
                        TextRange fragmentRange = (TextRange)fragment.getFirst();
                        holder.createErrorAnnotation(fragmentRange.shiftRight(elementOffset), error);
                    }
                }
                break block8;
            }
            if (!(element instanceof JsonNumberLiteral)) break block8;
            String text3 = null;
            for (JsonLiteralChecker checker : extensions) {
                String error;
                if (!checker.isApplicable(element)) continue;
                if (text3 == null) {
                    text3 = JsonPsiUtil.getElementTextWithoutHostEscaping(element);
                }
                if ((error = checker.getErrorForNumericLiteral(text3)) == null) continue;
                holder.createErrorAnnotation(element, error);
            }
        }
    }

    private static void highlightPropertyKey(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            JsonLiteralAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            JsonLiteralAnnotator.$$$reportNull$$$0(3);
        }
        if (JsonPsiUtil.isPropertyKey(element)) {
            holder.createInfoAnnotation(element, Holder.DEBUG ? "property key" : null).setTextAttributes(JsonSyntaxHighlighterFactory.JSON_PROPERTY_KEY);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/json/codeinsight/JsonLiteralAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightPropertyKey";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Holder {
        private static final boolean DEBUG = ApplicationManager.getApplication().isUnitTestMode();

        private Holder() {
        }
    }
}

