/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indentation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndentationParser
implements PsiParser {
    @NotNull
    private final IElementType myEolTokenType;
    @NotNull
    private final IElementType myIndentTokenType;
    @NotNull
    private final IElementType myBlockElementType;
    @NotNull
    private final IElementType myDocumentType;
    private final List<IElementType> myContainerTypes;

    public IndentationParser(@NotNull IElementType documentType, @NotNull IElementType blockElementType, @NotNull IElementType eolTokenType, @NotNull IElementType indentTokenType, List<IElementType> containerTypes) {
        if (documentType == null) {
            IndentationParser.$$$reportNull$$$0(0);
        }
        if (blockElementType == null) {
            IndentationParser.$$$reportNull$$$0(1);
        }
        if (eolTokenType == null) {
            IndentationParser.$$$reportNull$$$0(2);
        }
        if (indentTokenType == null) {
            IndentationParser.$$$reportNull$$$0(3);
        }
        this.myDocumentType = documentType;
        this.myBlockElementType = blockElementType;
        this.myEolTokenType = eolTokenType;
        this.myIndentTokenType = indentTokenType;
        this.myContainerTypes = containerTypes;
    }

    public IndentationParser(@NotNull IElementType documentType, @NotNull IElementType blockElementType, @NotNull IElementType eolTokenType, @NotNull IElementType indentTokenType) {
        if (documentType == null) {
            IndentationParser.$$$reportNull$$$0(4);
        }
        if (blockElementType == null) {
            IndentationParser.$$$reportNull$$$0(5);
        }
        if (eolTokenType == null) {
            IndentationParser.$$$reportNull$$$0(6);
        }
        if (indentTokenType == null) {
            IndentationParser.$$$reportNull$$$0(7);
        }
        this(documentType, blockElementType, eolTokenType, indentTokenType, null);
    }

    @NotNull
    public final ASTNode parse(IElementType root, PsiBuilder builder2) {
        PsiBuilder.Marker fileMarker = builder2.mark();
        ArrayList<PsiBuilder.Marker> containerMarkers = new ArrayList<PsiBuilder.Marker>();
        if (this.myContainerTypes != null) {
            for (IElementType ignored : this.myContainerTypes) {
                PsiBuilder.Marker containerMarker = builder2.mark();
                containerMarkers.add(containerMarker);
            }
        }
        PsiBuilder.Marker documentMarker = builder2.mark();
        while (builder2.getTokenType() == this.myEolTokenType) {
            this.advanceLexer(builder2);
        }
        int currentIndent = 0;
        boolean eolSeen = false;
        if (builder2.getTokenType() == this.myIndentTokenType) {
            currentIndent = builder2.getTokenText().length();
            this.advanceLexer(builder2);
        }
        Stack stack = new Stack();
        stack.push((Object)new BlockInfo(currentIndent, builder2.mark(), builder2.getTokenType()));
        PsiBuilder.Marker startLineMarker = null;
        while (!builder2.eof()) {
            IElementType type = builder2.getTokenType();
            if (type == this.myEolTokenType) {
                if (startLineMarker == null) {
                    startLineMarker = builder2.mark();
                }
                eolSeen = true;
                currentIndent = 0;
            } else if (type == this.myIndentTokenType) {
                currentIndent = builder2.getTokenText().length();
            } else {
                if (!eolSeen && !stack.isEmpty() && currentIndent > 0 && currentIndent < ((BlockInfo)stack.peek()).getIndent()) {
                    eolSeen = true;
                }
                if (this.isCustomTagDelimiter(type)) {
                    builder2.advanceLexer();
                    stack.push((Object)new BlockInfo(currentIndent, builder2.mark(), type));
                }
                if (eolSeen) {
                    BlockInfo blockInfo;
                    if (startLineMarker != null) {
                        startLineMarker.rollbackTo();
                        startLineMarker = null;
                    }
                    while (!stack.isEmpty() && currentIndent < ((BlockInfo)stack.peek()).getIndent()) {
                        blockInfo = (BlockInfo)stack.pop();
                        this.closeBlock(builder2, blockInfo.getMarker(), blockInfo.getStartTokenType());
                    }
                    if (!stack.isEmpty() && currentIndent >= (blockInfo = (BlockInfo)stack.peek()).getIndent()) {
                        if (currentIndent == blockInfo.getIndent()) {
                            BlockInfo info = (BlockInfo)stack.pop();
                            this.closeBlock(builder2, info.getMarker(), info.getStartTokenType());
                        }
                        this.passEOLsAndIndents(builder2);
                        stack.push((Object)new BlockInfo(currentIndent, builder2.mark(), type));
                    }
                    eolSeen = false;
                    currentIndent = 0;
                }
            }
            this.advanceLexer(builder2);
        }
        if (startLineMarker != null) {
            startLineMarker.drop();
        }
        while (!stack.isEmpty()) {
            BlockInfo blockInfo = (BlockInfo)stack.pop();
            this.closeBlock(builder2, blockInfo.getMarker(), blockInfo.getStartTokenType());
        }
        documentMarker.done(this.myDocumentType);
        if (this.myContainerTypes != null) {
            for (int i = containerMarkers.size() - 1; i >= 0; --i) {
                PsiBuilder.Marker marker = (PsiBuilder.Marker)containerMarkers.get(i);
                marker.done(this.myContainerTypes.get(i));
            }
        }
        fileMarker.done(root);
        ASTNode aSTNode = builder2.getTreeBuilt();
        if (aSTNode == null) {
            IndentationParser.$$$reportNull$$$0(8);
        }
        return aSTNode;
    }

    protected boolean isCustomTagDelimiter(IElementType type) {
        return false;
    }

    protected void closeBlock(@NotNull PsiBuilder builder2, @NotNull PsiBuilder.Marker marker, @Nullable IElementType startTokenType) {
        if (builder2 == null) {
            IndentationParser.$$$reportNull$$$0(9);
        }
        if (marker == null) {
            IndentationParser.$$$reportNull$$$0(10);
        }
        marker.done(this.myBlockElementType);
    }

    protected void advanceLexer(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            IndentationParser.$$$reportNull$$$0(11);
        }
        builder2.advanceLexer();
    }

    private void passEOLsAndIndents(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            IndentationParser.$$$reportNull$$$0(12);
        }
        IElementType tokenType = builder2.getTokenType();
        while (tokenType == this.myEolTokenType || tokenType == this.myIndentTokenType) {
            builder2.advanceLexer();
            tokenType = builder2.getTokenType();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentType";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockElementType";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eolTokenType";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentTokenType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indentation/IndentationParser";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indentation/IndentationParser";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "closeBlock";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "advanceLexer";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "passEOLsAndIndents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class BlockInfo {
        private final int myIndent;
        @NotNull
        private final PsiBuilder.Marker myMarker;
        @Nullable
        private final IElementType myStartTokenType;

        private BlockInfo(int indent, @NotNull PsiBuilder.Marker marker, @Nullable IElementType type) {
            if (marker == null) {
                BlockInfo.$$$reportNull$$$0(0);
            }
            this.myIndent = indent;
            this.myMarker = marker;
            this.myStartTokenType = type;
        }

        public int getIndent() {
            return this.myIndent;
        }

        @NotNull
        public PsiBuilder.Marker getMarker() {
            PsiBuilder.Marker marker = this.myMarker;
            if (marker == null) {
                BlockInfo.$$$reportNull$$$0(1);
            }
            return marker;
        }

        @Nullable
        public IElementType getStartTokenType() {
            return this.myStartTokenType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "marker";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/indentation/IndentationParser$BlockInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/indentation/IndentationParser$BlockInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMarker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

