/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.concurrency.JobLauncher;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class ContributorsBasedGotoByModel
implements ChooseByNameModelEx {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.gotoByName.ContributorsBasedGotoByModel");
    protected final Project myProject;
    private final ChooseByNameContributor[] myContributors;
    private final ConcurrentMap<ChooseByNameContributor, TIntHashSet> myContributorToItsSymbolsMap;
    private volatile IdFilter myIdFilter;
    private volatile boolean myIdFilterForLibraries;

    protected ContributorsBasedGotoByModel(@NotNull Project project, @NotNull ChooseByNameContributor[] contributors) {
        if (project == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(0);
        }
        if (contributors == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(1);
        }
        this.myContributorToItsSymbolsMap = ContainerUtil.newConcurrentMap();
        this.myProject = project;
        this.myContributors = contributors;
        assert (!Arrays.asList(contributors).contains(null));
    }

    public ListCellRenderer getListCellRenderer() {
        return new NavigationItemListCellRenderer();
    }

    public boolean sameNamesForProjectAndLibraries() {
        return !ChooseByNameBase.ourLoadNamesEachTime;
    }

    @Override
    public void processNames(final Processor<String> nameProcessor, final boolean checkBoxState) {
        long start = System.currentTimeMillis();
        List<ChooseByNameContributor> liveContribs = this.filterDumb(this.myContributors);
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        ReadActionProcessor<ChooseByNameContributor> processor2 = new ReadActionProcessor<ChooseByNameContributor>(){

            public boolean processInReadAction(@NotNull ChooseByNameContributor contributor) {
                if (contributor == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    if (!ContributorsBasedGotoByModel.this.myProject.isDisposed()) {
                        long contributorStarted = System.currentTimeMillis();
                        TIntHashSet filter = new TIntHashSet(1000);
                        ContributorsBasedGotoByModel.this.myContributorToItsSymbolsMap.put(contributor, filter);
                        if (contributor instanceof ChooseByNameContributorEx) {
                            ((ChooseByNameContributorEx)contributor).processNames((Processor<String>)((Processor)s -> {
                                if (nameProcessor.process(s)) {
                                    filter.add(s.hashCode());
                                }
                                return true;
                            }), FindSymbolParameters.searchScopeFor(ContributorsBasedGotoByModel.this.myProject, checkBoxState), ContributorsBasedGotoByModel.this.getIdFilter(checkBoxState));
                        } else {
                            String[] names;
                            for (String element : names = contributor.getNames(ContributorsBasedGotoByModel.this.myProject, checkBoxState)) {
                                if (!nameProcessor.process((Object)element)) continue;
                                filter.add(element.hashCode());
                            }
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(contributor + " for " + (System.currentTimeMillis() - contributorStarted));
                        }
                    }
                }
                catch (ProcessCanceledException | IndexNotReadyException contributorStarted) {
                }
                catch (Exception ex) {
                    LOG.error((Throwable)ex);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contributor", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel$1", "processInReadAction"));
            }
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(liveContribs, indicator, processor2)) {
            throw new ProcessCanceledException();
        }
        if (indicator != null) {
            indicator.checkCanceled();
        }
        long finish = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("processNames(): " + (finish - start) + "ms;");
        }
    }

    IdFilter getIdFilter(boolean withLibraries) {
        IdFilter idFilter = this.myIdFilter;
        if (idFilter == null || this.myIdFilterForLibraries != withLibraries) {
            this.myIdFilter = idFilter = IdFilter.getProjectIdFilter((Project)this.myProject, (boolean)withLibraries);
            this.myIdFilterForLibraries = withLibraries;
        }
        return idFilter;
    }

    @NotNull
    public String[] getNames(boolean checkBoxState) {
        THashSet allNames = ContainerUtil.newTroveSet();
        Collection result2 = Collections.synchronizedCollection(allNames);
        this.processNames((Processor<String>)Processors.cancelableCollectProcessor(result2), checkBoxState);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getNames(): (got " + allNames.size() + " elements)");
        }
        String[] stringArray = ArrayUtil.toStringArray((Collection)allNames);
        if (stringArray == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    private List<ChooseByNameContributor> filterDumb(ChooseByNameContributor[] contributors) {
        if (!DumbService.getInstance((Project)this.myProject).isDumb()) {
            return Arrays.asList(contributors);
        }
        ArrayList<ChooseByNameContributor> answer = new ArrayList<ChooseByNameContributor>(contributors.length);
        for (ChooseByNameContributor contributor : contributors) {
            if (!DumbService.isDumbAware((Object)contributor)) continue;
            answer.add(contributor);
        }
        return answer;
    }

    @NotNull
    public Object[] getElementsByName(@NotNull String name, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator canceled) {
        if (name == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(3);
        }
        if (parameters2 == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(4);
        }
        if (canceled == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(5);
        }
        long elementByNameStarted = System.currentTimeMillis();
        List items = Collections.synchronizedList(new ArrayList());
        Processor processor2 = contributor -> {
            if (name == null) {
                ContributorsBasedGotoByModel.$$$reportNull$$$0(11);
            }
            if (parameters2 == null) {
                ContributorsBasedGotoByModel.$$$reportNull$$$0(12);
            }
            if (canceled == null) {
                ContributorsBasedGotoByModel.$$$reportNull$$$0(13);
            }
            if (this.myProject.isDisposed()) {
                return true;
            }
            TIntHashSet filter = (TIntHashSet)this.myContributorToItsSymbolsMap.get(contributor);
            if (filter != null && !filter.contains(name.hashCode())) {
                return true;
            }
            try {
                boolean searchInLibraries = parameters2.getSearchScope().isSearchInLibraries();
                long contributorStarted = System.currentTimeMillis();
                if (contributor instanceof ChooseByNameContributorEx) {
                    ((ChooseByNameContributorEx)contributor).processElementsWithName(name, (Processor<NavigationItem>)((Processor)item -> {
                        if (canceled == null) {
                            ContributorsBasedGotoByModel.$$$reportNull$$$0(14);
                        }
                        canceled.checkCanceled();
                        if (this.acceptItem((NavigationItem)item)) {
                            items.add(item);
                        }
                        return true;
                    }), parameters2);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(System.currentTimeMillis() - contributorStarted + "," + contributor + ",");
                    }
                } else {
                    NavigationItem[] itemsByName;
                    for (NavigationItem item2 : itemsByName = contributor.getItemsByName(name, parameters2.getLocalPatternName(), this.myProject, searchInLibraries)) {
                        canceled.checkCanceled();
                        if (item2 == null) {
                            PluginId pluginId = PluginManagerCore.getPluginByClassName(contributor.getClass().getName());
                            if (pluginId != null) {
                                LOG.error((Throwable)new PluginException("null item from contributor " + contributor + " for name " + name, pluginId));
                                continue;
                            }
                            LOG.error("null item from contributor " + contributor + " for name " + name);
                            continue;
                        }
                        if (!this.acceptItem(item2)) continue;
                        items.add(item2);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(System.currentTimeMillis() - contributorStarted + "," + contributor + "," + itemsByName.length);
                    }
                }
            }
            catch (ProcessCanceledException searchInLibraries) {
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
            return true;
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(this.filterDumb(this.myContributors), canceled, processor2)) {
            canceled.cancel();
        }
        canceled.checkCanceled();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving " + name + ":" + items.size() + " for " + (System.currentTimeMillis() - elementByNameStarted));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(items);
        if (objectArray == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(6);
        }
        return objectArray;
    }

    @NotNull
    public Object[] getElementsByName(String name, boolean checkBoxState, String pattern) {
        Object[] objectArray = this.getElementsByName(name, FindSymbolParameters.wrap(pattern, this.myProject, checkBoxState), new ProgressIndicatorBase());
        if (objectArray == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    public String getElementName(Object element) {
        if (!(element instanceof NavigationItem)) {
            throw new AssertionError((Object)((element == null ? "null" : element + " of " + element.getClass()) + " in " + this + " of " + this.getClass()));
        }
        return ((NavigationItem)element).getName();
    }

    public String getHelpId() {
        return null;
    }

    protected ChooseByNameContributor[] getContributors() {
        return this.myContributors;
    }

    protected boolean acceptItem(NavigationItem item) {
        return true;
    }

    public boolean useMiddleMatching() {
        return true;
    }

    @NotNull
    public String removeModelSpecificMarkup(@NotNull String pattern) {
        if (pattern == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(8);
        }
        String string = pattern;
        if (string == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(10);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributors";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canceled";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsByName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "removeModelSpecificMarkup";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementsByName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeModelSpecificMarkup";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getElementsByName$1";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

