/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class DarculaTabbedPaneUI
extends BasicTabbedPaneUI {
    private TabStyle tabStyle;
    private PropertyChangeListener borderTypePropertyListener;
    private MouseListener paneMouseListener;
    private MouseMotionListener paneMouseMotionListener;
    private int hoverTab = -1;
    public static final JBValue OFFSET = new JBValue.Float(1.0f);

    public static ComponentUI createUI(JComponent c) {
        return new DarculaTabbedPaneUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Object rStyle = UIManager.get("TabbedPane.tabFillStyle");
        this.tabStyle = rStyle != null ? TabStyle.valueOf(rStyle.toString()) : TabStyle.underline;
        this.contentBorderInsets = this.tabPane.getTabLayoutPolicy() == 0 ? JBUI.insetsTop((int)1) : JBUI.emptyInsets();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.borderTypePropertyListener = evt -> {
            boolean fullBorder;
            boolean bl = fullBorder = this.tabPane.getClientProperty("JTabbedPane.hasFullBorder") == Boolean.TRUE;
            this.contentBorderInsets = this.tabPane.getTabLayoutPolicy() == 0 ? (fullBorder ? JBUI.insets((int)1) : JBUI.insetsTop((int)1)) : (fullBorder ? JBUI.insets((int)0, (int)1, (int)1, (int)1) : JBUI.emptyInsets());
            this.tabPane.revalidate();
            this.tabPane.repaint();
        };
        this.tabPane.addPropertyChangeListener("JTabbedPane.hasFullBorder", this.borderTypePropertyListener);
        this.tabPane.addPropertyChangeListener("tabLayoutPolicy", this.borderTypePropertyListener);
        this.paneMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                DarculaTabbedPaneUI.this.hoverTab = DarculaTabbedPaneUI.this.tabForCoordinate(DarculaTabbedPaneUI.this.tabPane, e.getX(), e.getY());
                DarculaTabbedPaneUI.this.tabPane.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DarculaTabbedPaneUI.this.hoverTab = -1;
                DarculaTabbedPaneUI.this.tabPane.repaint();
            }
        };
        this.tabPane.addMouseListener(this.paneMouseListener);
        this.paneMouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                DarculaTabbedPaneUI.this.hoverTab = DarculaTabbedPaneUI.this.tabForCoordinate(DarculaTabbedPaneUI.this.tabPane, e.getX(), e.getY());
                DarculaTabbedPaneUI.this.tabPane.repaint();
            }
        };
        this.tabPane.addMouseMotionListener(this.paneMouseMotionListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.borderTypePropertyListener != null) {
            this.tabPane.removePropertyChangeListener("JTabbedPane.hasFullBorder", this.borderTypePropertyListener);
        }
        if (this.paneMouseListener != null) {
            this.tabPane.removeMouseListener(this.paneMouseListener);
        }
        if (this.paneMouseMotionListener != null) {
            this.tabPane.removeMouseMotionListener(this.paneMouseMotionListener);
        }
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        JBInsets i = JBInsets.create((Insets)this.contentBorderInsets);
        DarculaTabbedPaneUI.rotateInsets(this.contentBorderInsets, (Insets)i, tabPlacement);
        return i;
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            Rectangle bounds = g.getClipBounds();
            g.setColor((Color)JBColor.namedColor((String)"TabbedPane.contentAreaColor", (int)0xBFBFBF));
            if (tabPlacement == 2 || tabPlacement == 4) {
                g.fillRect(bounds.x + bounds.width - OFFSET.get(), bounds.y, OFFSET.get(), bounds.y + bounds.height);
            } else {
                g.fillRect(bounds.x, bounds.y + bounds.height - OFFSET.get(), bounds.x + bounds.width, OFFSET.get());
            }
        }
        super.paintTabArea(g, tabPlacement, selectedIndex);
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        switch (this.tabStyle) {
            case fill: {
                if (this.tabPane.isEnabled()) {
                    g.setColor(isSelected ? JBUI.CurrentTheme.Focus.TabbedPane.ENABLED_SELECTED_COLOR : (tabIndex == this.hoverTab ? JBUI.CurrentTheme.Focus.TabbedPane.HOVER_COLOR : this.tabPane.getBackground()));
                    break;
                }
                g.setColor(isSelected ? JBUI.CurrentTheme.Focus.TabbedPane.DISABLED_SELECTED_COLOR : this.tabPane.getBackground());
                break;
            }
            default: {
                if (!this.tabPane.isEnabled()) break;
                g.setColor(tabIndex == this.hoverTab ? JBUI.CurrentTheme.Focus.TabbedPane.HOVER_COLOR : this.tabPane.getBackground());
            }
        }
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            if (tabPlacement == 2 || tabPlacement == 4) {
                w -= OFFSET.get();
            } else {
                h -= OFFSET.get();
            }
        }
        g.fillRect(x, y, w, h);
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (isSelected && this.tabStyle == TabStyle.underline) {
            g.setColor(this.tabPane.isEnabled() ? JBUI.CurrentTheme.Focus.TabbedPane.ENABLED_SELECTED_COLOR : JBUI.CurrentTheme.Focus.TabbedPane.DISABLED_SELECTED_COLOR);
            int offset = this.tabPane.getTabLayoutPolicy() == 0 ? OFFSET.get() : JBUI.CurrentTheme.Focus.TabbedPane.SELECTION_HEIGHT.get();
            switch (tabPlacement) {
                case 2: {
                    g.fillRect(x + w - offset, y, JBUI.CurrentTheme.Focus.TabbedPane.SELECTION_HEIGHT.get(), h);
                    break;
                }
                case 4: {
                    g.fillRect(x - offset, y, JBUI.CurrentTheme.Focus.TabbedPane.SELECTION_HEIGHT.get(), h);
                    break;
                }
                case 3: {
                    g.fillRect(x, y - offset, w, JBUI.CurrentTheme.Focus.TabbedPane.SELECTION_HEIGHT.get());
                    break;
                }
                default: {
                    g.fillRect(x, y + h - offset, w, JBUI.CurrentTheme.Focus.TabbedPane.SELECTION_HEIGHT.get());
                }
            }
        }
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
        int width = tabInsets.left + tabInsets.right;
        Component tabComponent = this.tabPane.getTabComponentAt(tabIndex);
        if (tabComponent != null) {
            width += tabComponent.getPreferredSize().width;
        } else {
            View v;
            Icon icon = this.getIconForTab(tabIndex);
            if (icon != null) {
                width += icon.getIconWidth() + this.textIconGap;
            }
            if ((v = this.getTextViewForTab(tabIndex)) != null) {
                width += (int)v.getPreferredSpan(0);
            } else {
                String title = this.tabPane.getTitleAt(tabIndex);
                width += SwingUtilities2.stringWidth(this.tabPane, metrics, title);
            }
        }
        return width;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        int height = 0;
        Component c = this.tabPane.getTabComponentAt(tabIndex);
        if (c != null) {
            height = c.getPreferredSize().height;
        } else {
            View v = this.getTextViewForTab(tabIndex);
            height = v != null ? (height += (int)v.getPreferredSpan(1)) : (height += fontHeight);
            Icon icon = this.getIconForTab(tabIndex);
            if (icon != null) {
                height = Math.max(height, icon.getIconHeight());
            }
        }
        Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
        int minHeight = JBUI.CurrentTheme.Focus.TabbedPane.TAB_HEIGHT.get() - (this.tabPane.getTabLayoutPolicy() == 0 ? OFFSET.get() : 0);
        return Math.max(height += tabInsets.top + tabInsets.bottom, minHeight);
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    private static enum TabStyle {
        underline,
        fill;

    }
}

