/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;

public class DarculaInstaller {
    private static final String DARCULA_EDITOR_THEME_KEY = "Darcula.savedEditorTheme";
    private static final String DEFAULT_EDITOR_THEME_KEY = "Default.savedEditorTheme";

    public static void uninstall() {
        DarculaInstaller.performImpl(false);
    }

    public static void install() {
        DarculaInstaller.performImpl(true);
    }

    private static void performImpl(boolean dark) {
        JBColor.setDark((boolean)dark);
        IconLoader.setUseDarkIcons((boolean)dark);
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme current = colorsManager.getGlobalScheme();
        if (dark != ColorUtil.isDark((Color)current.getDefaultBackground())) {
            String targetScheme = dark ? "Darcula" : "Default";
            PropertiesComponent properties = PropertiesComponent.getInstance();
            String savedEditorThemeKey = dark ? DARCULA_EDITOR_THEME_KEY : DEFAULT_EDITOR_THEME_KEY;
            String toSavedEditorThemeKey = dark ? DEFAULT_EDITOR_THEME_KEY : DARCULA_EDITOR_THEME_KEY;
            String themeName = properties.getValue(savedEditorThemeKey);
            if (themeName != null && colorsManager.getScheme(themeName) != null) {
                targetScheme = themeName;
            }
            properties.setValue(toSavedEditorThemeKey, current.getName(), dark ? "Default" : "Darcula");
            EditorColorsScheme scheme2 = colorsManager.getScheme(targetScheme);
            if (scheme2 != null) {
                colorsManager.setGlobalScheme(scheme2);
            }
        }
        DarculaInstaller.update();
    }

    protected static void update() {
        UISettings.getShadowInstance().fireUISettingsChanged();
        ActionToolbarImpl.updateAllToolbarsImmediately();
    }
}

