/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UIThemeProvider;
import com.intellij.ide.ui.laf.IdeaBlueMetalTheme;
import com.intellij.ide.ui.laf.IdeaLaf;
import com.intellij.ide.ui.laf.IdeaLookAndFeelInfo;
import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.ide.ui.laf.IntelliJLookAndFeelInfo;
import com.intellij.ide.ui.laf.UIThemeBasedLookAndFeelInfo;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.BasicOptionButtonUI;
import com.intellij.ui.mac.MacPopupMenuUI;
import com.intellij.ui.popup.OurHeavyWeightPopup;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LafIconLookup;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import org.intellij.lang.annotations.JdkConstants;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="LafManager", storages={@Storage(value="laf.xml", roamingType=RoamingType.PER_OS), @Storage(value="options.xml", deprecated=true)})
public final class LafManagerImpl
extends LafManager
implements PersistentStateComponent<Element>,
Disposable,
ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.ui.LafManager");
    @NonNls
    private static final String ELEMENT_LAF = "laf";
    @NonNls
    private static final String ATTRIBUTE_CLASS_NAME = "class-name";
    @NonNls
    private static final String ATTRIBUTE_THEME_NAME = "themeId";
    @NonNls
    private static final String GNOME_THEME_PROPERTY_NAME = "gnome.Net/ThemeName";
    @NonNls
    private static final String[] ourPatchableFontResources = new String[]{"Button.font", "ToggleButton.font", "RadioButton.font", "CheckBox.font", "ColorChooser.font", "ComboBox.font", "Label.font", "List.font", "MenuBar.font", "MenuItem.font", "MenuItem.acceleratorFont", "RadioButtonMenuItem.font", "CheckBoxMenuItem.font", "Menu.font", "PopupMenu.font", "OptionPane.font", "Panel.font", "ProgressBar.font", "ScrollPane.font", "Viewport.font", "TabbedPane.font", "Table.font", "TableHeader.font", "TextField.font", "FormattedTextField.font", "Spinner.font", "PasswordField.font", "TextArea.font", "TextPane.font", "EditorPane.font", "TitledBorder.font", "ToolBar.font", "ToolTip.font", "Tree.font"};
    @NonNls
    private static final String[] ourFileChooserTextKeys = new String[]{"FileChooser.viewMenuLabelText", "FileChooser.newFolderActionLabelText", "FileChooser.listViewActionLabelText", "FileChooser.detailsViewActionLabelText", "FileChooser.refreshActionLabelText"};
    private static final String[] ourAlloyComponentsToPatchSelection = new String[]{"Tree", "MenuItem", "Menu", "List", "ComboBox", "Table", "TextArea", "EditorPane", "TextPane", "FormattedTextField", "PasswordField", "TextField", "RadioButtonMenuItem", "CheckBoxMenuItem"};
    private final EventDispatcher<LafManagerListener> myEventDispatcher = EventDispatcher.create(LafManagerListener.class);
    private final UIManager.LookAndFeelInfo[] myLaFs;
    private final UIDefaults ourDefaults;
    private UIManager.LookAndFeelInfo myCurrentLaf;
    private final Map<UIManager.LookAndFeelInfo, HashMap<String, Object>> myStoredDefaults = ContainerUtil.newHashMap();
    public static final String WINDOW_ALPHA = "Window.alpha";
    private static final Map<String, String> ourLafClassesAliases = ContainerUtil.newHashMap();
    private static LafManagerImpl ourTestInstance;

    public static boolean useIntelliJInsteadOfAqua() {
        return Registry.is((String)"ide.mac.yosemite.laf") && LafManagerImpl.isIntelliJLafEnabled() && SystemInfo.isMacOSYosemite;
    }

    LafManagerImpl() {
        ArrayList lafList = ContainerUtil.newArrayList();
        this.ourDefaults = (UIDefaults)UIManager.getDefaults().clone();
        if (SystemInfo.isMac) {
            String className = LafManagerImpl.useIntelliJInsteadOfAqua() ? IntelliJLaf.class.getName() : UIManager.getSystemLookAndFeelClassName();
            lafList.add(new UIManager.LookAndFeelInfo("Light", className));
        } else {
            if (LafManagerImpl.isIntelliJLafEnabled()) {
                lafList.add(new IntelliJLookAndFeelInfo());
            } else {
                lafList.add(new IdeaLookAndFeelInfo());
            }
            for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
                String name = laf.getName();
                if ("Metal".equalsIgnoreCase(name) || "CDE/Motif".equalsIgnoreCase(name) || "Nimbus".equalsIgnoreCase(name) || "Windows Classic".equalsIgnoreCase(name) || name.startsWith("JGoodies") || "Windows".equalsIgnoreCase(name) && SystemInfo.isWin8OrNewer) continue;
                lafList.add(laf);
            }
        }
        lafList.add(new DarculaLookAndFeelInfo());
        lafList.addAll(Arrays.stream(UIThemeProvider.EP_NAME.getExtensions()).map(UIThemeProvider::createTheme).filter(x -> x != null).map(UIThemeBasedLookAndFeelInfo::new).collect(Collectors.toList()));
        this.myLaFs = lafList.toArray(new UIManager.LookAndFeelInfo[0]);
        if (!SystemInfo.isMac) {
            Arrays.sort(this.myLaFs, (obj1, obj2) -> {
                String name1 = obj1.getName();
                String name2 = obj2.getName();
                return name1.compareToIgnoreCase(name2);
            });
        }
        this.myCurrentLaf = this.getDefaultLaf();
    }

    private static boolean isIntelliJLafEnabled() {
        return !Registry.is((String)"idea.4.5.laf.enabled");
    }

    public void addLafManagerListener(@NotNull LafManagerListener listener2) {
        if (listener2 == null) {
            LafManagerImpl.$$$reportNull$$$0(0);
        }
        this.myEventDispatcher.addListener((EventListener)listener2);
    }

    public void addLafManagerListener(@NotNull LafManagerListener listener2, @NotNull Disposable disposable) {
        if (listener2 == null) {
            LafManagerImpl.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            LafManagerImpl.$$$reportNull$$$0(2);
        }
        this.myEventDispatcher.addListener((EventListener)listener2, disposable);
    }

    public void removeLafManagerListener(@NotNull LafManagerListener listener2) {
        if (listener2 == null) {
            LafManagerImpl.$$$reportNull$$$0(3);
        }
        this.myEventDispatcher.removeListener((EventListener)listener2);
    }

    public void initComponent() {
        UIManager.LookAndFeelInfo laf;
        if (this.myCurrentLaf != null && (laf = this.findLaf(this.myCurrentLaf.getClassName())) != null) {
            boolean needUninstall = UIUtil.isUnderDarcula();
            this.setCurrentLookAndFeel(laf);
            this.updateWizardLAF(needUninstall);
        }
        this.updateUI();
        if (SystemInfo.isXWindow) {
            final PropertyChangeListener themeChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SwingUtilities.invokeLater(() -> {
                        LafManagerImpl.fixGtkPopupStyle();
                        LafManagerImpl.patchGtkDefaults(UIManager.getLookAndFeelDefaults());
                    });
                }
            };
            Toolkit.getDefaultToolkit().addPropertyChangeListener(GNOME_THEME_PROPERTY_NAME, themeChangeListener);
            Disposer.register((Disposable)this, (Disposable)new Disposable(){

                public void dispose() {
                    Toolkit.getDefaultToolkit().removePropertyChangeListener(LafManagerImpl.GNOME_THEME_PROPERTY_NAME, themeChangeListener);
                }
            });
        }
    }

    public void updateWizardLAF(boolean wasUnderDarcula) {
        if (WelcomeWizardUtil.getWizardLAF() != null) {
            if (UIUtil.isUnderDarcula()) {
                DarculaInstaller.install();
            } else if (wasUnderDarcula) {
                DarculaInstaller.uninstall();
            }
            WelcomeWizardUtil.setWizardLAF(null);
        }
    }

    public void dispose() {
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            LafManagerImpl.$$$reportNull$$$0(4);
        }
        String className = null;
        String themeId = null;
        UIManager.LookAndFeelInfo laf = null;
        Element lafElement = element.getChild(ELEMENT_LAF);
        if (lafElement != null) {
            className = lafElement.getAttributeValue(ATTRIBUTE_CLASS_NAME);
            themeId = lafElement.getAttributeValue(ATTRIBUTE_THEME_NAME);
            if (themeId != null) {
                for (UIManager.LookAndFeelInfo f : this.myLaFs) {
                    if (!(f instanceof UIThemeBasedLookAndFeelInfo) || !((UIThemeBasedLookAndFeelInfo)f).getTheme().getId().equals(themeId)) continue;
                    laf = f;
                    break;
                }
            }
            if (className != null && ourLafClassesAliases.containsKey(className)) {
                className = ourLafClassesAliases.get(className);
            }
        }
        if (laf == null) {
            laf = this.findLaf(className);
        }
        if (laf == null) {
            laf = this.getDefaultLaf();
        }
        if (this.myCurrentLaf != null && !laf.getClassName().equals(this.myCurrentLaf.getClassName())) {
            this.setCurrentLookAndFeel(laf);
            this.updateUI();
        }
        this.myCurrentLaf = laf;
    }

    public Element getState() {
        String className;
        Element element = new Element("state");
        if (this.myCurrentLaf != null && (className = this.myCurrentLaf.getClassName()) != null) {
            Element child = new Element(ELEMENT_LAF);
            child.setAttribute(ATTRIBUTE_CLASS_NAME, className);
            if (this.myCurrentLaf instanceof UIThemeBasedLookAndFeelInfo) {
                child.setAttribute(ATTRIBUTE_THEME_NAME, ((UIThemeBasedLookAndFeelInfo)this.myCurrentLaf).getTheme().getId());
            }
            element.addContent(child);
        }
        return element;
    }

    @NotNull
    public UIManager.LookAndFeelInfo[] getInstalledLookAndFeels() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = (UIManager.LookAndFeelInfo[])this.myLaFs.clone();
        if (lookAndFeelInfoArray == null) {
            LafManagerImpl.$$$reportNull$$$0(5);
        }
        return lookAndFeelInfoArray;
    }

    public UIManager.LookAndFeelInfo getCurrentLookAndFeel() {
        return this.myCurrentLaf;
    }

    public UIManager.LookAndFeelInfo getDefaultLaf() {
        String defaultLafName;
        UIManager.LookAndFeelInfo laf;
        String appLafName;
        UIManager.LookAndFeelInfo laf2;
        String wizardLafName = WelcomeWizardUtil.getWizardLAF();
        if (wizardLafName != null) {
            UIManager.LookAndFeelInfo laf3 = this.findLaf(wizardLafName);
            if (laf3 != null) {
                return laf3;
            }
            LOG.error("Could not find wizard L&F: " + wizardLafName);
        }
        if (SystemInfo.isMac) {
            String className = LafManagerImpl.useIntelliJInsteadOfAqua() ? IntelliJLaf.class.getName() : UIManager.getSystemLookAndFeelClassName();
            laf2 = this.findLaf(className);
            if (laf2 != null) {
                return laf2;
            }
            LOG.error("Could not find OS X L&F: " + className);
        }
        if ((appLafName = WelcomeWizardUtil.getDefaultLAF()) != null) {
            laf2 = this.findLaf(appLafName);
            if (laf2 != null) {
                return laf2;
            }
            LOG.error("Could not find app L&F: " + appLafName);
        }
        if ((laf = this.findLaf(defaultLafName = LafManagerImpl.isIntelliJLafEnabled() ? IntelliJLaf.class.getName() : "idea.laf.classname")) != null) {
            return laf;
        }
        throw new IllegalStateException("No default L&F found: " + defaultLafName);
    }

    @Nullable
    private UIManager.LookAndFeelInfo findLaf(@Nullable String className) {
        if (className == null) {
            return null;
        }
        for (UIManager.LookAndFeelInfo laf : this.myLaFs) {
            if (!Comparing.equal((String)laf.getClassName(), (String)className)) continue;
            return laf;
        }
        return null;
    }

    public void setCurrentLookAndFeel(@NotNull UIManager.LookAndFeelInfo lookAndFeelInfo) {
        LookAndFeel laf;
        if (lookAndFeelInfo == null) {
            LafManagerImpl.$$$reportNull$$$0(6);
        }
        if (this.findLaf(lookAndFeelInfo.getClassName()) == null) {
            LOG.error("unknown LookAndFeel : " + lookAndFeelInfo);
            return;
        }
        UIManager.getDefaults().clear();
        UIManager.getDefaults().putAll(this.ourDefaults);
        if ("idea.laf.classname".equals(lookAndFeelInfo.getClassName())) {
            laf = new IdeaLaf();
            MetalLookAndFeel.setCurrentTheme(new IdeaBlueMetalTheme());
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception e) {
                Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.set.look.and.feel", (Object[])new Object[]{lookAndFeelInfo.getName(), e.getMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
        }
        if (DarculaLookAndFeelInfo.CLASS_NAME.equals(lookAndFeelInfo.getClassName())) {
            laf = new DarculaLaf();
            try {
                UIManager.setLookAndFeel(laf);
                LafManagerImpl.updateForDarcula(true);
            }
            catch (Exception e) {
                Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.set.look.and.feel", (Object[])new Object[]{lookAndFeelInfo.getName(), e.getMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
        }
        try {
            laf = (LookAndFeel)Class.forName(lookAndFeelInfo.getClassName()).newInstance();
            if (laf instanceof MetalLookAndFeel) {
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            }
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception e) {
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.set.look.and.feel", (Object[])new Object[]{lookAndFeelInfo.getName(), e.getMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        if (lookAndFeelInfo instanceof UIThemeBasedLookAndFeelInfo) {
            try {
                ((UIThemeBasedLookAndFeelInfo)lookAndFeelInfo).installTheme(UIManager.getLookAndFeelDefaults());
            }
            catch (Exception e) {
                Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.set.look.and.feel", (Object[])new Object[]{lookAndFeelInfo.getName(), e.getMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
        }
        if (SystemInfo.isMacOSYosemite) {
            LafManagerImpl.installMacOSXFonts(UIManager.getLookAndFeelDefaults());
        }
        this.myCurrentLaf = (UIManager.LookAndFeelInfo)ObjectUtils.chooseNotNull((Object)lookAndFeelInfo, (Object)this.findLaf(lookAndFeelInfo.getClassName()));
    }

    public static void updateForDarcula(boolean isDarcula) {
        JBColor.setDark((boolean)isDarcula);
        IconLoader.setUseDarkIcons((boolean)isDarcula);
    }

    public void setLookAndFeelAfterRestart(UIManager.LookAndFeelInfo lookAndFeelInfo) {
        this.myCurrentLaf = lookAndFeelInfo;
    }

    @Nullable
    private static Icon getAquaMenuDisabledIcon() {
        Icon arrowIcon = (Icon)UIManager.get("Menu.arrowIcon");
        if (arrowIcon != null) {
            return IconLoader.getDisabledIcon((Icon)arrowIcon);
        }
        return null;
    }

    @Nullable
    private static Icon getAquaMenuInvertedIcon() {
        if (UIUtil.isUnderAquaLookAndFeel() || SystemInfo.isMac && UIUtil.isUnderIntelliJLaF()) {
            return AllIcons.Mac.Tree_white_right_arrow;
        }
        return null;
    }

    public void updateUI() {
        UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
        LafManagerImpl.fixPopupWeight();
        LafManagerImpl.fixGtkPopupStyle();
        LafManagerImpl.fixMenuIssues(uiDefaults);
        if (UIUtil.isUnderAquaLookAndFeel()) {
            uiDefaults.put("Panel.opaque", Boolean.TRUE);
        } else if (UIUtil.isWinLafOnVista()) {
            uiDefaults.put("ComboBox.border", (Object)null);
        }
        LafManagerImpl.initInputMapDefaults(uiDefaults);
        uiDefaults.put("Button.defaultButtonFollowsFocus", Boolean.FALSE);
        uiDefaults.put("Balloon.error.textInsets", new JBInsets(3, 8, 3, 8).asUIResource());
        LafManagerImpl.patchFileChooserStrings(uiDefaults);
        this.patchLafFonts(uiDefaults);
        LafManagerImpl.patchHiDPI(uiDefaults);
        LafManagerImpl.patchGtkDefaults(uiDefaults);
        LafManagerImpl.fixSeparatorColor(uiDefaults);
        LafManagerImpl.fixProgressBar(uiDefaults);
        LafManagerImpl.fixOptionButton(uiDefaults);
        for (Frame frame : Frame.getFrames()) {
            if (SystemInfo.isMac) {
                frame.setBackground(new Color(UIUtil.getPanelBackground().getRGB()));
            }
            LafManagerImpl.updateUI(frame);
        }
        ((LafManagerListener)this.myEventDispatcher.getMulticaster()).lookAndFeelChanged((LafManager)this);
    }

    @NotNull
    private static FontUIResource getFont(String yosemite, int size, @JdkConstants.FontStyle int style) {
        Font font;
        if (SystemInfo.isMacOSElCapitan && !UIUtil.isDialogFont((Font)(font = new Font(".SF NS Text", style, size)))) {
            FontUIResource fontUIResource = new FontUIResource(font);
            if (fontUIResource == null) {
                LafManagerImpl.$$$reportNull$$$0(7);
            }
            return fontUIResource;
        }
        FontUIResource fontUIResource = new FontUIResource(yosemite, style, size);
        if (fontUIResource == null) {
            LafManagerImpl.$$$reportNull$$$0(8);
        }
        return fontUIResource;
    }

    public static void installMacOSXFonts(UIDefaults defaults) {
        String face = "HelveticaNeue-Regular";
        FontUIResource uiFont = LafManagerImpl.getFont("HelveticaNeue-Regular", 13, 0);
        LafManagerImpl.initFontDefaults(defaults, uiFont);
        for (Object key : new HashSet(defaults.keySet())) {
            FontUIResource font;
            Object value = defaults.get(key);
            if (!(value instanceof FontUIResource) || !(font = (FontUIResource)value).getFamily().equals("Lucida Grande") && !font.getFamily().equals("Serif") || key.toString().contains("Menu")) continue;
            defaults.put(key, LafManagerImpl.getFont("HelveticaNeue-Regular", font.getSize(), font.getStyle()));
        }
        FontUIResource uiFont11 = LafManagerImpl.getFont("HelveticaNeue-Regular", 11, 0);
        defaults.put("TableHeader.font", uiFont11);
        FontUIResource buttonFont = LafManagerImpl.getFont("HelveticaNeue-Medium", 13, 0);
        defaults.put("Button.font", buttonFont);
        FontUIResource menuFont = LafManagerImpl.getFont("Lucida Grande", 14, 0);
        defaults.put("Menu.font", menuFont);
        defaults.put("MenuItem.font", menuFont);
        defaults.put("MenuItem.acceleratorFont", menuFont);
        defaults.put("PasswordField.font", defaults.getFont("TextField.font"));
    }

    private static void patchHiDPI(UIDefaults defaults) {
        float prevScale;
        Object prevScaleVal = defaults.get("hidpi.scaleFactor");
        float f = prevScale = prevScaleVal != null ? ((Float)prevScaleVal).floatValue() : 1.0f;
        if (prevScale == JBUI.scale((float)1.0f) && prevScaleVal != null) {
            return;
        }
        List<String> myIntKeys = Arrays.asList("Tree.leftChildIndent", "Tree.rightChildIndent", "Tree.rowHeight");
        List<String> myDimensionKeys = Arrays.asList("Slider.horizontalSize", "Slider.verticalSize", "Slider.minimumHorizontalSize", "Slider.minimumVerticalSize");
        for (Map.Entry entry : defaults.entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey().toString();
            if (value instanceof Dimension) {
                if (!(value instanceof UIResource) && !myDimensionKeys.contains(key)) continue;
                entry.setValue(JBUI.size((Dimension)((Dimension)value)).asUIResource());
                continue;
            }
            if (value instanceof Insets) {
                if (!(value instanceof UIResource)) continue;
                entry.setValue(JBUI.insets((Insets)((Insets)value)).asUIResource());
                continue;
            }
            if (!(value instanceof Integer) || !key.endsWith(".maxGutterIconWidth") && !myIntKeys.contains(key)) continue;
            int normValue = (int)((float)((Integer)value).intValue() / prevScale);
            entry.setValue(JBUI.scale((int)normValue));
        }
        defaults.put("hidpi.scaleFactor", Float.valueOf(JBUI.scale((float)1.0f)));
    }

    private static void fixMenuIssues(UIDefaults uiDefaults) {
        if (UIUtil.isUnderAquaLookAndFeel() || SystemInfo.isMac && UIUtil.isUnderIntelliJLaF()) {
            uiDefaults.put("PopupMenuUI", MacPopupMenuUI.class.getCanonicalName());
            uiDefaults.put("Menu.invertedArrowIcon", LafManagerImpl.getAquaMenuInvertedIcon());
            uiDefaults.put("Menu.disabledArrowIcon", LafManagerImpl.getAquaMenuDisabledIcon());
        }
        if (UIUtil.isUnderWin10LookAndFeel()) {
            uiDefaults.put("Menu.arrowIcon", new Win10MenuArrowIcon());
        } else if ((SystemInfo.isLinux || SystemInfo.isWindows) && (UIUtil.isUnderIntelliJLaF() || UIUtil.isUnderDarcula())) {
            uiDefaults.put("Menu.arrowIcon", new DefaultMenuArrowIcon(AllIcons.Actions.Right));
        }
        uiDefaults.put("MenuItem.background", UIManager.getColor("Menu.background"));
    }

    private static void fixSeparatorColor(UIDefaults uiDefaults) {
        if (UIUtil.isUnderAquaLookAndFeel()) {
            uiDefaults.put("Separator.background", UIUtil.AQUA_SEPARATOR_BACKGROUND_COLOR);
            uiDefaults.put("Separator.foreground", UIUtil.AQUA_SEPARATOR_FOREGROUND_COLOR);
        }
    }

    private static void fixProgressBar(UIDefaults uiDefaults) {
        if (!UIUtil.isUnderIntelliJLaF() && !UIUtil.isUnderDarcula()) {
            uiDefaults.put("ProgressBarUI", "com.intellij.ide.ui.laf.darcula.ui.DarculaProgressBarUI");
            uiDefaults.put("ProgressBar.border", "com.intellij.ide.ui.laf.darcula.ui.DarculaProgressBarBorder");
        }
    }

    private static void fixOptionButton(UIDefaults uiDefaults) {
        if (!UIUtil.isUnderIntelliJLaF() && !UIUtil.isUnderDarcula()) {
            uiDefaults.put("OptionButtonUI", BasicOptionButtonUI.class.getCanonicalName());
        }
    }

    private static void fixPopupWeight() {
        int popupWeight = 1;
        String property = System.getProperty("idea.popup.weight");
        if (property != null) {
            property = property.toLowerCase(Locale.ENGLISH).trim();
        }
        if (SystemInfo.isMacOSLeopard) {
            popupWeight = 2;
        } else if (property == null) {
            if (SystemInfo.isWindows) {
                popupWeight = 2;
            }
        } else if ("light".equals(property)) {
            popupWeight = 0;
        } else if ("medium".equals(property)) {
            popupWeight = 1;
        } else if ("heavy".equals(property)) {
            popupWeight = 2;
        } else {
            LOG.error("Illegal value of property \"idea.popup.weight\": " + property);
        }
        PopupFactory factory = PopupFactory.getSharedInstance();
        if (!(factory instanceof OurPopupFactory)) {
            factory = new OurPopupFactory(factory);
            PopupFactory.setSharedInstance(factory);
        }
        PopupUtil.setPopupType((PopupFactory)factory, (int)popupWeight);
    }

    private static void fixGtkPopupStyle() {
        if (!UIUtil.isUnderGTKLookAndFeel()) {
            return;
        }
        final SynthStyleFactory original = SynthLookAndFeel.getStyleFactory();
        SynthLookAndFeel.setStyleFactory(new SynthStyleFactory(){

            @Override
            public SynthStyle getStyle(JComponent c, Region id) {
                Integer x;
                SynthStyle style = original.getStyle(c, id);
                if (id == Region.POPUP_MENU && (x = (Integer)ReflectionUtil.getField(style.getClass(), (Object)style, Integer.TYPE, (String)"xThickness")) != null && x == 0) {
                    ReflectionUtil.setField(style.getClass(), (Object)style, Integer.TYPE, (String)"xThickness", (Object)1);
                    ReflectionUtil.setField(style.getClass(), (Object)style, Integer.TYPE, (String)"yThickness", (Object)3);
                }
                return style;
            }
        });
        new JBPopupMenu();
        SynthLookAndFeel.setStyleFactory(original);
    }

    private static void patchFileChooserStrings(UIDefaults defaults) {
        if (!defaults.containsKey(ourFileChooserTextKeys[0])) {
            for (String key : ourFileChooserTextKeys) {
                defaults.put(key, IdeBundle.message((String)key, (Object[])new Object[0]));
            }
        }
    }

    private static void patchGtkDefaults(UIDefaults defaults) {
        if (!UIUtil.isUnderGTKLookAndFeel()) {
            return;
        }
        Map map2 = ContainerUtil.newHashMap(Arrays.asList("OptionPane.errorIcon", "OptionPane.informationIcon", "OptionPane.warningIcon", "OptionPane.questionIcon"), Arrays.asList(AllIcons.General.ErrorDialog, AllIcons.General.InformationDialog, AllIcons.General.WarningDialog, AllIcons.General.QuestionDialog));
        SynthStyle style = SynthLookAndFeel.getStyle(new JOptionPane(""), Region.DESKTOP_ICON);
        for (String key : map2.keySet()) {
            if (defaults.get(key) != null) continue;
            Object icon = style == null ? null : style.get(null, key);
            defaults.put(key, icon instanceof Icon ? icon : map2.get(key));
        }
        Color fg = defaults.getColor("Label.foreground");
        Color bg = defaults.getColor("Label.background");
        if (fg != null && bg != null) {
            defaults.put("Label.disabledForeground", UIUtil.mix((Color)fg, (Color)bg, (double)0.5));
        }
    }

    private void patchLafFonts(UIDefaults uiDefaults) {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getOverrideLafFonts()) {
            this.storeOriginalFontDefaults(uiDefaults);
            LafManagerImpl.initFontDefaults(uiDefaults, UIUtil.getFontWithFallback((String)uiSettings.getFontFace(), (int)0, (int)uiSettings.getFontSize()));
            JBUI.setUserScaleFactor((float)JBUI.getFontScale((float)uiSettings.getFontSize()));
        } else {
            this.restoreOriginalFontDefaults(uiDefaults);
        }
    }

    private void restoreOriginalFontDefaults(UIDefaults defaults) {
        UIManager.LookAndFeelInfo lf = this.getCurrentLookAndFeel();
        HashMap<String, Object> lfDefaults = this.myStoredDefaults.get(lf);
        if (lfDefaults != null) {
            for (String resource : ourPatchableFontResources) {
                defaults.put(resource, lfDefaults.get(resource));
            }
        }
        JBUI.setUserScaleFactor((float)JBUI.getFontScale((float)JBUI.Fonts.label().getSize()));
    }

    private void storeOriginalFontDefaults(UIDefaults defaults) {
        UIManager.LookAndFeelInfo lf = this.getCurrentLookAndFeel();
        HashMap<String, Object> lfDefaults = this.myStoredDefaults.get(lf);
        if (lfDefaults == null) {
            lfDefaults = new HashMap();
            for (String resource : ourPatchableFontResources) {
                lfDefaults.put(resource, defaults.get(resource));
            }
            this.myStoredDefaults.put(lf, lfDefaults);
        }
    }

    private static void updateUI(Window window) {
        Window[] children2;
        IJSwingUtilities.updateComponentTreeUI(window);
        for (Window w : children2 = window.getOwnedWindows()) {
            IJSwingUtilities.updateComponentTreeUI(w);
        }
    }

    public void repaintUI() {
        Frame[] frames;
        for (Frame frame : frames = Frame.getFrames()) {
            LafManagerImpl.repaintUI(frame);
        }
    }

    private static void repaintUI(Window window) {
        Window[] children2;
        if (!window.isDisplayable()) {
            return;
        }
        window.repaint();
        for (Window aChildren : children2 = window.getOwnedWindows()) {
            LafManagerImpl.repaintUI(aChildren);
        }
    }

    private static void installCutCopyPasteShortcuts(InputMap inputMap, boolean useSimpleActionKeys) {
        String copyActionKey = useSimpleActionKeys ? "copy" : "copy-to-clipboard";
        String pasteActionKey = useSimpleActionKeys ? "paste" : "paste-from-clipboard";
        String cutActionKey = useSimpleActionKeys ? "cut" : "cut-to-clipboard";
        inputMap.put(KeyStroke.getKeyStroke(155, 130), copyActionKey);
        inputMap.put(KeyStroke.getKeyStroke(155, 65), pasteActionKey);
        inputMap.put(KeyStroke.getKeyStroke(127, 65), cutActionKey);
        inputMap.put(KeyStroke.getKeyStroke(67, 130), copyActionKey);
        inputMap.put(KeyStroke.getKeyStroke(86, 130), pasteActionKey);
        inputMap.put(KeyStroke.getKeyStroke(88, 130), "cut-to-clipboard");
    }

    public static void initInputMapDefaults(UIDefaults defaults) {
        InputMap tableInputMap;
        InputMap passwordFieldInputMap;
        InputMap textFieldInputMap;
        InputMap textAreaInputMap;
        InputMap treeInputMap = (InputMap)defaults.get("Tree.focusInputMap");
        if (treeInputMap != null) {
            treeInputMap.put(KeyStroke.getKeyStroke(10, 0), "toggle");
        }
        if ((textAreaInputMap = (InputMap)defaults.get("TextArea.focusInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(textAreaInputMap, false);
        }
        if ((textFieldInputMap = (InputMap)defaults.get("TextField.focusInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(textFieldInputMap, false);
        }
        if ((passwordFieldInputMap = (InputMap)defaults.get("PasswordField.focusInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(passwordFieldInputMap, false);
        }
        if ((tableInputMap = (InputMap)defaults.get("Table.ancestorInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(tableInputMap, true);
        }
    }

    public static void initFontDefaults(@NotNull UIDefaults defaults, @NotNull FontUIResource uiFont) {
        if (defaults == null) {
            LafManagerImpl.$$$reportNull$$$0(9);
        }
        if (uiFont == null) {
            LafManagerImpl.$$$reportNull$$$0(10);
        }
        defaults.put("Tree.ancestorInputMap", (Object)null);
        FontUIResource textFont = new FontUIResource(uiFont);
        FontUIResource monoFont = new FontUIResource("Monospaced", 0, uiFont.getSize());
        for (String fontResource : ourPatchableFontResources) {
            defaults.put(fontResource, uiFont);
        }
        if (!SystemInfo.isMac) {
            defaults.put("PasswordField.font", monoFont);
        }
        defaults.put("TextArea.font", monoFont);
        defaults.put("TextPane.font", textFont);
        defaults.put("EditorPane.font", textFont);
    }

    public static LafManagerImpl getTestInstance() {
        if (ourTestInstance == null) {
            ourTestInstance = new LafManagerImpl();
        }
        return ourTestInstance;
    }

    static {
        ourLafClassesAliases.put("idea.dark.laf.classname", DarculaLookAndFeelInfo.CLASS_NAME);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/laf/LafManagerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookAndFeelInfo";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaults";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiFont";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/laf/LafManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledLookAndFeels";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addLafManagerListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeLafManagerListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentLookAndFeel";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "initFontDefaults";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Win10MenuArrowIcon
    extends MenuArrowIcon {
        private static final String NAME = "menuTriangle";

        private Win10MenuArrowIcon() {
            super(LafIconLookup.getIcon((String)NAME), LafIconLookup.getSelectedIcon((String)NAME), LafIconLookup.getDisabledIcon((String)NAME));
        }
    }

    private static class DefaultMenuArrowIcon
    extends MenuArrowIcon {
        private static final boolean invert = UIUtil.isUnderDarcula();

        private DefaultMenuArrowIcon(Icon icon) {
            super(invert ? IconUtil.brighter((Icon)icon, (int)2) : IconUtil.darker((Icon)icon, (int)2), IconUtil.brighter((Icon)icon, (int)8), invert ? IconUtil.darker((Icon)icon, (int)2) : IconUtil.brighter((Icon)icon, (int)2));
        }
    }

    private static abstract class MenuArrowIcon
    implements Icon,
    UIResource {
        private final Icon icon;
        private final Icon selectedIcon;
        private final Icon disabledIcon;

        private MenuArrowIcon(Icon icon, Icon selectedIcon, Icon disabledIcon) {
            this.icon = icon;
            this.selectedIcon = selectedIcon;
            this.disabledIcon = disabledIcon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            ButtonModel model = b.getModel();
            if (!model.isEnabled()) {
                this.disabledIcon.paintIcon(c, g, x, y);
            } else if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                this.selectedIcon.paintIcon(c, g, x, y);
            } else {
                this.icon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    private static class OurPopupFactory
    extends PopupFactory {
        public static final int WEIGHT_LIGHT = 0;
        public static final int WEIGHT_MEDIUM = 1;
        public static final int WEIGHT_HEAVY = 2;
        private final PopupFactory myDelegate;

        public OurPopupFactory(PopupFactory delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public Popup getPopup(Component owner, Component contents, int x, int y) {
            boolean isHeavyWeightPopup;
            int popupType;
            Point point = OurPopupFactory.fixPopupLocation(contents, x, y);
            int n = popupType = UIUtil.isUnderGTKLookAndFeel() ? 2 : PopupUtil.getPopupType((PopupFactory)this);
            if (popupType == 2 && OurHeavyWeightPopup.isEnabled()) {
                return new OurHeavyWeightPopup(owner, contents, point.x, point.y);
            }
            if (popupType >= 0) {
                PopupUtil.setPopupType((PopupFactory)this.myDelegate, (int)popupType);
            }
            Popup popup2 = this.myDelegate.getPopup(owner, contents, point.x, point.y);
            final Window window = UIUtil.getWindow((Component)contents);
            final String cleanupKey = "LafManagerImpl.rootPaneCleanup";
            boolean bl = isHeavyWeightPopup = window instanceof RootPaneContainer && window != UIUtil.getWindow((Component)owner);
            if (isHeavyWeightPopup) {
                UIUtil.markAsTypeAheadAware((Window)window);
            }
            if (isHeavyWeightPopup && ((RootPaneContainer)((Object)window)).getRootPane().getClientProperty(cleanupKey) == null) {
                final JRootPane rootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                rootPane.putClientProperty(LafManagerImpl.WINDOW_ALPHA, Float.valueOf(1.0f));
                rootPane.putClientProperty(cleanupKey, cleanupKey);
                window.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                        if (PopupUtil.getPopupContainerFor((Component)rootPane) != null) {
                            window.removeWindowListener(this);
                            rootPane.putClientProperty(cleanupKey, null);
                        }
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                        window.removeWindowListener(this);
                        rootPane.putClientProperty(cleanupKey, null);
                        DialogWrapper.cleanupRootPane((JRootPane)rootPane);
                        DialogWrapper.cleanupWindowListeners((Window)window);
                    }
                });
            }
            OurPopupFactory.fixPopupSize(popup2, contents);
            return popup2;
        }

        private static Point fixPopupLocation(Component contents, int x, int y) {
            PointerInfo info;
            if (!(contents instanceof JToolTip)) {
                return new Point(x, y);
            }
            try {
                info = MouseInfo.getPointerInfo();
            }
            catch (InternalError e) {
                return new Point(x, y);
            }
            int deltaY = 0;
            if (info != null) {
                Point mouse = info.getLocation();
                deltaY = mouse.y - y;
            }
            Dimension size = contents.getPreferredSize();
            Rectangle rec = new Rectangle(new Point(x, y), size);
            ScreenUtil.moveRectangleToFitTheScreen((Rectangle)rec);
            if (rec.y < y) {
                rec.y += deltaY;
            }
            return rec.getLocation();
        }

        private static void fixPopupSize(Popup popup2, Component contents) {
            if (!UIUtil.isUnderGTKLookAndFeel() || !(contents instanceof JPopupMenu)) {
                return;
            }
            for (Class<?> aClass = popup2.getClass(); aClass != null && Popup.class.isAssignableFrom(aClass); aClass = aClass.getSuperclass()) {
                try {
                    Method getComponent2 = aClass.getDeclaredMethod("getComponent", new Class[0]);
                    getComponent2.setAccessible(true);
                    Object component = getComponent2.invoke((Object)popup2, new Object[0]);
                    if (!(component instanceof JWindow)) break;
                    ((JWindow)component).setSize(new Dimension(0, 0));
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
    }
}

