/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.TodoFilter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.TodoAttributes;
import com.intellij.psi.search.TodoAttributesUtil;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBus;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.EventListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="TodoConfiguration", storages={@Storage(value="editor.xml"), @Storage(value="other.xml", deprecated=true)})
public class TodoConfiguration
implements PersistentStateComponent<Element> {
    private TodoPattern[] myTodoPatterns;
    private TodoFilter[] myTodoFilters;
    private IndexPattern[] myIndexPatterns;
    private final EventDispatcher<PropertyChangeListener> myPropertyChangeMulticaster;
    @NonNls
    public static final String PROP_TODO_PATTERNS = "todoPatterns";
    @NonNls
    public static final String PROP_TODO_FILTERS = "todoFilters";
    @NonNls
    private static final String ELEMENT_PATTERN = "pattern";
    @NonNls
    private static final String ELEMENT_FILTER = "filter";
    private final MessageBus myMessageBus;

    public TodoConfiguration(@NotNull MessageBus messageBus) {
        if (messageBus == null) {
            TodoConfiguration.$$$reportNull$$$0(0);
        }
        this.myPropertyChangeMulticaster = EventDispatcher.create(PropertyChangeListener.class);
        this.myMessageBus = messageBus;
        messageBus.connect().subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme2) {
                TodoConfiguration.this.colorSettingsChanged();
            }
        });
        this.resetToDefaultTodoPatterns();
    }

    public static TodoConfiguration getInstance() {
        return (TodoConfiguration)ServiceManager.getService(TodoConfiguration.class);
    }

    public void resetToDefaultTodoPatterns() {
        this.myTodoPatterns = this.getDefaultPatterns();
        this.myTodoFilters = new TodoFilter[0];
        this.buildIndexPatterns();
    }

    @NotNull
    protected TodoPattern[] getDefaultPatterns() {
        TodoPattern[] todoPatternArray = new TodoPattern[]{new TodoPattern("\\btodo\\b.*", TodoAttributesUtil.createDefault(), false), new TodoPattern("\\bfixme\\b.*", TodoAttributesUtil.createDefault(), false)};
        if (todoPatternArray == null) {
            TodoConfiguration.$$$reportNull$$$0(1);
        }
        return todoPatternArray;
    }

    private void buildIndexPatterns() {
        this.myIndexPatterns = new IndexPattern[this.myTodoPatterns.length];
        for (int i = 0; i < this.myTodoPatterns.length; ++i) {
            this.myIndexPatterns[i] = this.myTodoPatterns[i].getIndexPattern();
        }
    }

    @NotNull
    public TodoPattern[] getTodoPatterns() {
        if (this.myTodoPatterns == null) {
            TodoConfiguration.$$$reportNull$$$0(2);
        }
        return this.myTodoPatterns;
    }

    @NotNull
    public IndexPattern[] getIndexPatterns() {
        if (this.myIndexPatterns == null) {
            TodoConfiguration.$$$reportNull$$$0(3);
        }
        return this.myIndexPatterns;
    }

    public void setTodoPatterns(@NotNull TodoPattern[] todoPatterns) {
        if (todoPatterns == null) {
            TodoConfiguration.$$$reportNull$$$0(4);
        }
        this.doSetTodoPatterns(todoPatterns, true);
    }

    private void doSetTodoPatterns(@NotNull TodoPattern[] todoPatterns, boolean shouldNotifyIndices) {
        if (todoPatterns == null) {
            TodoConfiguration.$$$reportNull$$$0(5);
        }
        Object[] oldTodoPatterns = this.myTodoPatterns;
        Object[] oldIndexPatterns = this.myIndexPatterns;
        this.myTodoPatterns = todoPatterns;
        this.buildIndexPatterns();
        if (shouldNotifyIndices && !Arrays.deepEquals(this.myIndexPatterns, oldIndexPatterns)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, "indexPatterns", oldTodoPatterns, todoPatterns);
            ((PropertyChangeListener)this.myMessageBus.syncPublisher(IndexPatternProvider.INDEX_PATTERNS_CHANGED)).propertyChange(event);
        }
        if (!Arrays.deepEquals(this.myTodoPatterns, oldTodoPatterns)) {
            PropertyChangeListener multicaster = (PropertyChangeListener)this.myPropertyChangeMulticaster.getMulticaster();
            multicaster.propertyChange(new PropertyChangeEvent(this, PROP_TODO_PATTERNS, oldTodoPatterns, todoPatterns));
        }
    }

    public TodoFilter getTodoFilter(String name) {
        for (TodoFilter filter : this.myTodoFilters) {
            if (!filter.getName().equals(name)) continue;
            return filter;
        }
        return null;
    }

    @NotNull
    public TodoFilter[] getTodoFilters() {
        if (this.myTodoFilters == null) {
            TodoConfiguration.$$$reportNull$$$0(6);
        }
        return this.myTodoFilters;
    }

    public void setTodoFilters(@NotNull TodoFilter[] filters) {
        if (filters == null) {
            TodoConfiguration.$$$reportNull$$$0(7);
        }
        TodoFilter[] oldFilters = this.myTodoFilters;
        this.myTodoFilters = filters;
        ((PropertyChangeListener)this.myPropertyChangeMulticaster.getMulticaster()).propertyChange(new PropertyChangeEvent(this, PROP_TODO_FILTERS, oldFilters, filters));
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            TodoConfiguration.$$$reportNull$$$0(8);
        }
        if (parentDisposable == null) {
            TodoConfiguration.$$$reportNull$$$0(9);
        }
        this.myPropertyChangeMulticaster.addListener((EventListener)listener2, parentDisposable);
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            TodoConfiguration.$$$reportNull$$$0(10);
        }
        SmartList patternsList = new SmartList();
        for (Element child : element.getChildren(ELEMENT_PATTERN)) {
            patternsList.add(new TodoPattern(child, TodoAttributesUtil.getDefaultColorSchemeTextAttributes()));
        }
        TodoPattern[] patterns = patternsList.isEmpty() ? this.getDefaultPatterns() : patternsList.toArray(new TodoPattern[0]);
        this.doSetTodoPatterns(patterns, false);
        SmartList filtersList = new SmartList();
        for (Element child : element.getChildren(ELEMENT_FILTER)) {
            filtersList.add(new TodoFilter(child, Arrays.asList(patterns)));
        }
        if (!filtersList.isEmpty() || this.myTodoFilters.length != 0) {
            this.setTodoFilters(filtersList.toArray(new TodoFilter[0]));
        }
    }

    public Element getState() {
        Element child;
        Element element = new Element("state");
        TodoPattern[] todoPatterns = this.myTodoPatterns;
        if (!Arrays.equals(this.myTodoPatterns, this.getDefaultPatterns())) {
            for (TodoPattern todoPattern : todoPatterns) {
                child = new Element(ELEMENT_PATTERN);
                todoPattern.writeExternal(child);
                element.addContent(child);
            }
        }
        for (TodoFilter todoFilter : this.myTodoFilters) {
            child = new Element(ELEMENT_FILTER);
            todoFilter.writeExternal(child, todoPatterns);
            element.addContent(child);
        }
        return element;
    }

    public void colorSettingsChanged() {
        for (TodoPattern pattern : this.myTodoPatterns) {
            TodoAttributes attributes = pattern.getAttributes();
            if (attributes.shouldUseCustomTodoColor()) continue;
            attributes.setUseCustomTodoColor(false, TodoAttributesUtil.getDefaultColorSchemeTextAttributes());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/TodoConfiguration";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROP_TODO_PATTERNS;
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/TodoConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPatterns";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTodoPatterns";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexPatterns";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTodoFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTodoPatterns";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doSetTodoPatterns";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setTodoFilters";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

